/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;

public class HTTPTransportReceiver {
    public static Map getGetRequestParameters(String requestURI) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (requestURI == null || "".equals(requestURI)) {
            return map;
        }
        char[] chars = requestURI.toCharArray();
        int NOT_BEGUN = 1500;
        int INSIDE_NAME = 1501;
        int INSIDE_VALUE = 1502;
        int state = 1500;
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        for (int index = 0; index < chars.length; ++index) {
            if (state == 1500) {
                if (chars[index] != '?') continue;
                state = 1501;
                continue;
            }
            if (state == 1501) {
                if (chars[index] == '=') {
                    state = 1502;
                    continue;
                }
                name.append(chars[index]);
                continue;
            }
            if (state != 1502) continue;
            if (chars[index] == ',') {
                state = 1501;
                map.put(name.toString(), value.toString());
                name.delete(0, name.length());
                value.delete(0, value.length());
                continue;
            }
            value.append(chars[index]);
        }
        if (name.length() + value.length() > 0) {
            map.put(name.toString(), value.toString());
        }
        return map;
    }

    public static String getServicesHTML(ConfigurationContext configurationContext) {
        String temp = "";
        HashMap services = configurationContext.getAxisConfiguration().getServices();
        Hashtable erroneousServices = configurationContext.getAxisConfiguration().getFaultyServices();
        boolean status = false;
        if (services != null && !services.isEmpty()) {
            status = true;
            ArrayList serviceCollection = new ArrayList();
            TreeSet allServices = new TreeSet(services.keySet());
            for (String serviceName : allServices) {
                serviceCollection.add(services.get(serviceName));
            }
            temp = temp + "<h2>Deployed services</h2>";
            for (AxisService axisService : serviceCollection) {
                if (Utils.isHiddenService((AxisService)axisService)) continue;
                Iterator iterator = axisService.getOperations();
                temp = temp + "<h3><a href=\"" + axisService.getName() + "?wsdl\">" + axisService.getName() + "</a></h3>";
                if (iterator.hasNext()) {
                    temp = temp + "Available operations <ul>";
                    while (iterator.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)iterator.next();
                        temp = temp + "<li>" + axisOperation.getName().getLocalPart() + "</li>";
                    }
                    temp = temp + "</ul>";
                    continue;
                }
                temp = temp + "No operations specified for this service";
            }
        }
        if (erroneousServices != null && !erroneousServices.isEmpty()) {
            temp = temp + "<hr><h2><font color=\"blue\">Faulty Services</font></h2>";
            status = true;
            TreeSet allFaultServices = new TreeSet(erroneousServices.keySet());
            for (String faultyserviceName : allFaultServices) {
                temp = temp + "<h3><font color=\"blue\">" + faultyserviceName + "</font></h3>";
            }
        }
        if (!status) {
            temp = "<h2>There are no services deployed</h2>";
        }
        temp = "<html><head><title>Axis2: Services</title></head><body>" + temp + "</body></html>";
        return temp;
    }

    public static String printServiceHTML(String serviceName, ConfigurationContext configurationContext) {
        String temp = "";
        try {
            AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
            AxisService axisService = axisConfig.getService(serviceName);
            Iterator iterator = axisService.getOperations();
            temp = temp + "<h3>" + axisService.getName() + "</h3>";
            temp = temp + "<a href=\"" + axisService.getName() + "?wsdl\">wsdl</a> <br/> ";
            temp = temp + "<i>Service Description :  " + axisService.getDocumentation() + "</i><br/><br/>";
            if (iterator.hasNext()) {
                temp = temp + "Available operations <ul>";
                while (iterator.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)iterator.next();
                    temp = temp + "<li>" + axisOperation.getName().getLocalPart() + "</li>";
                }
                temp = temp + "</ul>";
            } else {
                temp = temp + "No operations specified for this service";
            }
            temp = "<html><head><title>Axis2: Services</title></head><body>" + temp + "</body></html>";
        }
        catch (AxisFault axisFault) {
            temp = "<html><head><title>Service has a fualt</title></head><body><hr><h2><font color=\"blue\">" + axisFault.getMessage() + "</font></h2></body></html>";
        }
        return temp;
    }
}

