/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSOutTransportInfo
implements OutTransportInfo {
    private static final Log log = LogFactory.getLog((Class)JMSOutTransportInfo.class);
    private ConnectionFactory connectionFactory = null;
    private String connectionFactoryUser = null;
    private String connectionFactoryPassword = null;
    private Destination destination = null;
    private String contentType = null;

    JMSOutTransportInfo(ConnectionFactory connectionFactory, Destination dest) {
        this.connectionFactory = connectionFactory;
        this.destination = dest;
    }

    JMSOutTransportInfo(ConnectionFactory connectionFactory, String connectionFactoryUser, String connectionFactoryPassword, Destination dest) {
        this.connectionFactory = connectionFactory;
        this.connectionFactoryUser = connectionFactoryUser;
        this.connectionFactoryPassword = connectionFactoryPassword;
        this.destination = dest;
    }

    JMSOutTransportInfo(String url) {
        if (!url.startsWith("jms:/")) {
            this.handleException("Invalid JMS URL : " + url + " Must begin with the prefix " + "jms:/");
        } else {
            InitialContext context = null;
            Hashtable props = JMSUtils.getProperties(url);
            try {
                context = new InitialContext(props);
            }
            catch (NamingException e) {
                this.handleException("Could not get the initial context", e);
            }
            this.connectionFactory = this.getConnectionFactory(context, props);
            this.connectionFactoryUser = this.getConnectionFactoryUser(context, props);
            this.connectionFactoryPassword = this.getConnectionFactoryPass(context, props);
            this.destination = this.getDestination(context, url);
        }
    }

    private ConnectionFactory getConnectionFactory(Context context, Hashtable props) {
        try {
            String conFacJndiName = (String)props.get("transport.jms.ConnectionFactoryJNDIName");
            if (conFacJndiName != null) {
                return (ConnectionFactory)context.lookup(conFacJndiName);
            }
            throw new NamingException("JMS Connection Factory JNDI name cannot be determined from url");
        }
        catch (NamingException e) {
            this.handleException("Cannot get JMS Connection factory with props : " + props, e);
            return null;
        }
    }

    private String getConnectionFactoryUser(Context context, Hashtable props) {
        try {
            String conFacJndiUser = (String)props.get("transport.jms.ConnectionFactoryJNDIUser");
            if (conFacJndiUser != null) {
                return (String)context.lookup(conFacJndiUser);
            }
            return null;
        }
        catch (NamingException e) {
            this.handleException("Cannot get JMS Connection factory username with props : " + props, e);
            return null;
        }
    }

    private String getConnectionFactoryPass(Context context, Hashtable props) {
        try {
            String conFacJndiPass = (String)props.get("transport.jms.ConnectionFactoryJNDIPass");
            if (conFacJndiPass != null) {
                return (String)context.lookup(conFacJndiPass);
            }
            return null;
        }
        catch (NamingException e) {
            this.handleException("Cannot get JMS Connection factory password with props : " + props, e);
            return null;
        }
    }

    private Destination getDestination(Context context, String url) {
        String destinationName = JMSUtils.getDestination(url);
        try {
            return (Destination)context.lookup(destinationName);
        }
        catch (NameNotFoundException e) {
            log.warn((Object)("Cannot get or lookup JMS destination : " + destinationName + " from url : " + url + " : " + e.getMessage()));
        }
        catch (NamingException e) {
            this.handleException("Cannot get JMS destination : " + destinationName + " from url : " + url, e);
        }
        return null;
    }

    private void handleException(String s) {
        log.error((Object)s);
        throw new AxisJMSException(s);
    }

    private void handleException(String s, Exception e) {
        log.error((Object)s, (Throwable)e);
        throw new AxisJMSException(s, e);
    }

    public Destination getDestination() {
        return this.destination;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public String getConnectionFactoryPassword() {
        return this.connectionFactoryPassword;
    }

    public String getConnectionFactoryUser() {
        return this.connectionFactoryUser;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

