/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.TypeCache;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeDefCache<T1 extends AtlasBaseTypeDef, T2 extends AtlasType> {
    private static final Logger LOG = LoggerFactory.getLogger(TypeDefCache.class);
    private final TypeCache typeCache;
    private final Map<String, T1> typeDefGuidMap;
    private final Map<String, T1> typeDefNameMap;
    private final Map<String, T2> typeNameMap;

    public TypeDefCache(TypeCache typeCache) {
        this.typeCache = typeCache;
        this.typeDefGuidMap = new ConcurrentHashMap<String, T1>();
        this.typeDefNameMap = new ConcurrentHashMap<String, T1>();
        this.typeNameMap = new ConcurrentHashMap<String, T2>();
    }

    public TypeDefCache(TypeDefCache other, TypeCache typeCache) {
        this.typeCache = typeCache;
        this.typeDefGuidMap = new ConcurrentHashMap<String, T1>(other.typeDefGuidMap);
        this.typeDefNameMap = new ConcurrentHashMap<String, T1>(other.typeDefNameMap);
        this.typeNameMap = new ConcurrentHashMap<String, T2>(other.typeNameMap);
    }

    public void addType(T1 typeDef, T2 type) {
        if (typeDef != null && type != null) {
            if (StringUtils.isNotEmpty((String)((AtlasBaseTypeDef)typeDef).getGuid())) {
                this.typeDefGuidMap.put(((AtlasBaseTypeDef)typeDef).getGuid(), typeDef);
            }
            if (StringUtils.isNotEmpty((String)((AtlasBaseTypeDef)typeDef).getName())) {
                this.typeDefNameMap.put(((AtlasBaseTypeDef)typeDef).getName(), typeDef);
                this.typeNameMap.put(((AtlasBaseTypeDef)typeDef).getName(), type);
            }
            this.typeCache.addType((AtlasBaseTypeDef)typeDef, (AtlasType)type);
        }
    }

    public Collection<T1> getAll() {
        return Collections.unmodifiableCollection(this.typeDefNameMap.values());
    }

    public Collection<String> getAllNames() {
        return Collections.unmodifiableCollection(this.typeDefNameMap.keySet());
    }

    public T1 getTypeDefByGuid(String guid) {
        return (T1)(guid != null ? (AtlasBaseTypeDef)this.typeDefGuidMap.get(guid) : null);
    }

    public T1 getTypeDefByName(String name) {
        return (T1)(name != null ? (AtlasBaseTypeDef)this.typeDefNameMap.get(name) : null);
    }

    public Collection<T2> getAllTypes() {
        return Collections.unmodifiableCollection(this.typeNameMap.values());
    }

    public T2 getTypeByName(String name) {
        return (T2)(name != null ? (AtlasType)this.typeNameMap.get(name) : null);
    }

    public void updateGuid(String typeName, String newGuid) {
        AtlasBaseTypeDef typeDef;
        if (typeName != null && (typeDef = (AtlasBaseTypeDef)this.typeDefNameMap.get(typeName)) != null) {
            String currGuid = typeDef.getGuid();
            if (!this.typeDefGuidMap.containsKey(newGuid) || !StringUtils.equals((String)currGuid, (String)newGuid)) {
                if (LOG.isDebugEnabled()) {
                    if (!this.typeDefGuidMap.containsKey(newGuid)) {
                        LOG.debug("TypeDefGuidMap doesn't contain entry for guid {}. Adding new entry", (Object)newGuid);
                    } else {
                        LOG.debug("Removing entry for guid {} and adding entry for guid {}", (Object)currGuid, (Object)newGuid);
                    }
                }
                if (currGuid != null) {
                    this.typeDefGuidMap.remove(currGuid);
                }
                typeDef.setGuid(newGuid);
                if (newGuid != null) {
                    this.typeDefGuidMap.put(newGuid, typeDef);
                }
                this.typeCache.updateGuid(typeName, currGuid, newGuid);
            }
        }
    }

    public void removeTypeDefByGuid(String guid) {
        if (guid != null) {
            String name;
            AtlasBaseTypeDef typeDef = (AtlasBaseTypeDef)this.typeDefGuidMap.remove(guid);
            this.typeCache.removeTypeByGuid(guid);
            String string = name = typeDef != null ? typeDef.getName() : null;
            if (name != null) {
                this.typeDefNameMap.remove(name);
                this.typeNameMap.remove(name);
                this.typeCache.removeTypeByName(name);
            }
        }
    }

    public void removeTypeDefByName(String name) {
        if (name != null) {
            String guid;
            AtlasBaseTypeDef typeDef = (AtlasBaseTypeDef)this.typeDefNameMap.remove(name);
            this.typeNameMap.remove(name);
            this.typeCache.removeTypeByName(name);
            String string = guid = typeDef != null ? typeDef.getGuid() : null;
            if (guid != null) {
                this.typeDefGuidMap.remove(guid);
                this.typeCache.removeTypeByGuid(guid);
            }
        }
    }

    public void clear() {
        this.typeCache.clear();
        this.typeDefGuidMap.clear();
        this.typeDefNameMap.clear();
        this.typeNameMap.clear();
    }
}

