/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportLoggerFactory;
import org.apache.activemq.transport.TransportServerThreadSupport;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.tcp.TcpTransportFactory;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.activemq.wireformat.WireFormatFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpTransportServer
extends TransportServerThreadSupport {
    private static final Log LOG = LogFactory.getLog(TcpTransportServer.class);
    protected ServerSocket serverSocket;
    protected int backlog = 5000;
    protected WireFormatFactory wireFormatFactory = new OpenWireFormatFactory();
    protected final TcpTransportFactory transportFactory;
    protected long maxInactivityDuration = 30000L;
    protected int minmumWireFormatVersion;
    protected boolean trace = false;
    protected String logWriterName = TransportLoggerFactory.defaultLogWriterName;
    protected boolean dynamicManagement = false;
    protected boolean startLogging = true;
    protected Map<String, Object> transportOptions;
    protected final ServerSocketFactory serverSocketFactory;
    protected BlockingQueue<Socket> socketQueue = new LinkedBlockingQueue<Socket>();
    protected Thread socketHandlerThread;

    public TcpTransportServer(TcpTransportFactory transportFactory, URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        super(location);
        this.transportFactory = transportFactory;
        this.serverSocketFactory = serverSocketFactory;
    }

    public void bind() throws IOException {
        URI bind = this.getBindLocation();
        String host = bind.getHost();
        host = host == null || host.length() == 0 ? "localhost" : host;
        InetAddress addr = InetAddress.getByName(host);
        try {
            this.serverSocket = host.trim().equals("localhost") || addr.equals(InetAddress.getLocalHost()) ? this.serverSocketFactory.createServerSocket(bind.getPort(), this.backlog) : this.serverSocketFactory.createServerSocket(bind.getPort(), this.backlog, addr);
            this.serverSocket.setSoTimeout(2000);
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to bind to server socket: " + bind + " due to: " + e, e);
        }
        try {
            this.setConnectURI(new URI(bind.getScheme(), bind.getUserInfo(), this.resolveHostName(bind.getHost()), this.serverSocket.getLocalPort(), bind.getPath(), bind.getQuery(), bind.getFragment()));
        }
        catch (URISyntaxException e) {
            try {
                this.setConnectURI(new URI(bind.getScheme(), bind.getUserInfo(), addr.getHostAddress(), this.serverSocket.getLocalPort(), bind.getPath(), bind.getQuery(), bind.getFragment()));
            }
            catch (URISyntaxException e2) {
                throw IOExceptionSupport.create(e2);
            }
        }
    }

    public WireFormatFactory getWireFormatFactory() {
        return this.wireFormatFactory;
    }

    public void setWireFormatFactory(WireFormatFactory wireFormatFactory) {
        this.wireFormatFactory = wireFormatFactory;
    }

    @Override
    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public int getMinmumWireFormatVersion() {
        return this.minmumWireFormatVersion;
    }

    public void setMinmumWireFormatVersion(int minmumWireFormatVersion) {
        this.minmumWireFormatVersion = minmumWireFormatVersion;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public String getLogWriterName() {
        return this.logWriterName;
    }

    public void setLogWriterName(String logFormat) {
        this.logWriterName = logFormat;
    }

    public boolean isDynamicManagement() {
        return this.dynamicManagement;
    }

    public void setDynamicManagement(boolean useJmx) {
        this.dynamicManagement = useJmx;
    }

    public boolean isStartLogging() {
        return this.startLogging;
    }

    public void setStartLogging(boolean startLogging) {
        this.startLogging = startLogging;
    }

    @Override
    public void run() {
        while (!this.isStopped()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                if (socket == null) continue;
                if (this.isStopped() || this.getAcceptListener() == null) {
                    socket.close();
                    continue;
                }
                this.socketQueue.put(socket);
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception e) {
                if (!this.isStopping()) {
                    this.onAcceptError(e);
                    continue;
                }
                if (this.isStopped()) continue;
                LOG.warn("run()", e);
                this.onAcceptError(e);
            }
        }
    }

    protected Transport createTransport(Socket socket, WireFormat format) throws IOException {
        return new TcpTransport(format, socket);
    }

    public String toString() {
        return "" + this.getBindLocation();
    }

    protected String resolveHostName(String hostName) throws UnknownHostException {
        String result = hostName;
        if (hostName != null && (hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1"))) {
            result = InetAddress.getLocalHost().getHostName();
        }
        return result;
    }

    @Override
    protected void doStart() throws Exception {
        Runnable run = new Runnable(){

            public void run() {
                block3: {
                    try {
                        while (!TcpTransportServer.this.isStopped() && !TcpTransportServer.this.isStopping()) {
                            Socket sock = TcpTransportServer.this.socketQueue.poll(1L, TimeUnit.SECONDS);
                            if (sock == null) continue;
                            TcpTransportServer.this.handleSocket(sock);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info("socketQueue interuppted - stopping");
                        if (TcpTransportServer.this.isStopping()) break block3;
                        TcpTransportServer.this.onAcceptError(e);
                    }
                }
            }
        };
        this.socketHandlerThread = new Thread(null, run, "ActiveMQ Transport Server Thread Handler: " + this.toString(), this.getStackSize());
        this.socketHandlerThread.setDaemon(true);
        this.socketHandlerThread.setPriority(8);
        super.doStart();
        this.socketHandlerThread.start();
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        super.doStop(stopper);
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    public void setTransportOption(Map<String, Object> transportOptions) {
        this.transportOptions = transportOptions;
    }

    protected void handleSocket(Socket socket) {
        block4: {
            try {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("maxInactivityDuration", this.maxInactivityDuration);
                options.put("minmumWireFormatVersion", this.minmumWireFormatVersion);
                options.put("trace", this.trace);
                options.put("logWriterName", this.logWriterName);
                options.put("dynamicManagement", this.dynamicManagement);
                options.put("startLogging", this.startLogging);
                options.putAll(this.transportOptions);
                WireFormat format = this.wireFormatFactory.createWireFormat();
                Transport transport = this.createTransport(socket, format);
                Transport configuredTransport = this.transportFactory.serverConfigure(transport, format, options);
                this.getAcceptListener().onAccept(configuredTransport);
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception e) {
                if (!this.isStopping()) {
                    this.onAcceptError(e);
                }
                if (this.isStopped()) break block4;
                LOG.warn("run()", e);
                this.onAcceptError(e);
            }
        }
    }
}

