/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test.message;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NestedMapAndListPropertyTest
extends JmsTopicSendReceiveWithTwoConnectionsAndEmbeddedBrokerTest {
    private static final Log LOG = LogFactory.getLog(NestedMapAndListPropertyTest.class);

    protected void assertMessageValid(int index, Message message) throws JMSException {
        Object value = message.getObjectProperty("textField");
        NestedMapAndListPropertyTest.assertEquals((String)"textField", (Object)this.data[index], (Object)value);
        Map map = (Map)message.getObjectProperty("mapField");
        NestedMapAndListPropertyTest.assertNotNull((Object)map);
        NestedMapAndListPropertyTest.assertEquals((String)"mapField.a", (Object)"foo", map.get("a"));
        NestedMapAndListPropertyTest.assertEquals((String)"mapField.b", (Object)new Integer(23), map.get("b"));
        NestedMapAndListPropertyTest.assertEquals((String)"mapField.c", (Object)new Long(45L), map.get("c"));
        value = map.get("d");
        NestedMapAndListPropertyTest.assertTrue((String)"mapField.d should be a Map", (boolean)(value instanceof Map));
        map = (Map)value;
        NestedMapAndListPropertyTest.assertEquals((String)"mapField.d.x", (Object)"abc", map.get("x"));
        value = map.get("y");
        NestedMapAndListPropertyTest.assertTrue((String)"mapField.d.y is a List", (boolean)(value instanceof List));
        List list = (List)value;
        LOG.debug("mapField.d.y: " + list);
        NestedMapAndListPropertyTest.assertEquals((String)"listField.size", (int)3, (int)list.size());
        LOG.debug("Found map: " + map);
        list = (List)message.getObjectProperty("listField");
        LOG.debug("listField: " + list);
        NestedMapAndListPropertyTest.assertEquals((String)"listField.size", (int)3, (int)list.size());
        NestedMapAndListPropertyTest.assertEquals((String)"listField[0]", (Object)"a", list.get(0));
        NestedMapAndListPropertyTest.assertEquals((String)"listField[1]", (Object)"b", list.get(1));
        NestedMapAndListPropertyTest.assertEquals((String)"listField[2]", (Object)"c", list.get(2));
    }

    protected Message createMessage(int index) throws JMSException {
        Message answer = this.session.createMessage();
        answer.setStringProperty("textField", this.data[index]);
        HashMap<String, Object> grandChildMap = new HashMap<String, Object>();
        grandChildMap.put("x", "abc");
        grandChildMap.put("y", Arrays.asList("a", "b", "c"));
        HashMap<String, Object> nestedMap = new HashMap<String, Object>();
        nestedMap.put("a", "foo");
        nestedMap.put("b", new Integer(23));
        nestedMap.put("c", new Long(45L));
        nestedMap.put("d", grandChildMap);
        answer.setObjectProperty("mapField", nestedMap);
        answer.setObjectProperty("listField", Arrays.asList("a", "b", "c"));
        return answer;
    }
}

