/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class NetworkFailoverTest
extends TestCase {
    protected static final int MESSAGE_COUNT = 10;
    private static final Log LOG = LogFactory.getLog(NetworkFailoverTest.class);
    protected AbstractApplicationContext context;
    protected Connection localConnection;
    protected Connection remoteConnection;
    protected BrokerService localBroker;
    protected BrokerService remoteBroker;
    protected Session localSession;
    protected Session remoteSession;
    protected ActiveMQQueue included = new ActiveMQQueue("include.test.foo");
    protected String consumerName = "durableSubs";

    public void testRequestReply() throws Exception {
        final MessageProducer remoteProducer = this.remoteSession.createProducer(null);
        MessageConsumer remoteConsumer = this.remoteSession.createConsumer(this.included);
        remoteConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    TextMessage textMsg = (TextMessage)msg;
                    String payload = "REPLY: " + textMsg.getText();
                    Destination replyTo = msg.getJMSReplyTo();
                    textMsg.clearBody();
                    textMsg.setText(payload);
                    remoteProducer.send(replyTo, textMsg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        TemporaryQueue tempQueue = this.localSession.createTemporaryQueue();
        MessageProducer requestProducer = this.localSession.createProducer(this.included);
        requestProducer.setDeliveryMode(1);
        MessageConsumer requestConsumer = this.localSession.createConsumer(tempQueue);
        Thread.sleep(2000L);
        for (int i = 0; i < 10; ++i) {
            String payload = "test msg " + i;
            TextMessage msg = this.localSession.createTextMessage(payload);
            msg.setJMSReplyTo(tempQueue);
            requestProducer.send(msg);
            LOG.info("Failing over");
            ((FailoverTransport)((TransportFilter)((TransportFilter)((ActiveMQConnection)this.localConnection).getTransport()).getNext()).getNext()).handleTransportFailure(new IOException());
            TextMessage result = (TextMessage)requestConsumer.receive();
            NetworkFailoverTest.assertNotNull((Object)result);
            LOG.info(result.getText());
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.doSetUp();
    }

    protected void tearDown() throws Exception {
        this.localBroker.deleteAllMessages();
        this.remoteBroker.deleteAllMessages();
        this.doTearDown();
        super.tearDown();
    }

    protected void doTearDown() throws Exception {
        this.localConnection.close();
        this.remoteConnection.close();
        this.localBroker.stop();
        this.remoteBroker.stop();
    }

    protected void doSetUp() throws Exception {
        this.remoteBroker = this.createRemoteBroker();
        this.remoteBroker.start();
        this.localBroker = this.createLocalBroker();
        this.localBroker.start();
        String localURI = "tcp://localhost:61616";
        String remoteURI = "tcp://localhost:61617";
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("failover:(" + localURI + "," + remoteURI + "?trackMessages=true)?randomize=false&backup=true");
        this.localConnection = fac.createConnection();
        this.localConnection.setClientID("local");
        this.localConnection.start();
        fac = new ActiveMQConnectionFactory("failover:(" + remoteURI + "," + localURI + ")?randomize=false&backup=true");
        fac.setWatchTopicAdvisories(false);
        this.remoteConnection = fac.createConnection();
        this.remoteConnection.setClientID("remote");
        this.remoteConnection.start();
        this.localSession = this.localConnection.createSession(false, 1);
        this.remoteSession = this.remoteConnection.createSession(false, 1);
    }

    protected String getRemoteBrokerURI() {
        return "org/apache/activemq/network/remoteBroker.xml";
    }

    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/localBroker.xml";
    }

    protected BrokerService createBroker(String uri) throws Exception {
        ClassPathResource resource = new ClassPathResource(uri);
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)resource);
        resource = new ClassPathResource(uri);
        factory = new BrokerFactoryBean((Resource)resource);
        factory.afterPropertiesSet();
        BrokerService result = factory.getBroker();
        return result;
    }

    protected BrokerService createLocalBroker() throws Exception {
        return this.createBroker(this.getLocalBrokerURI());
    }

    protected BrokerService createRemoteBroker() throws Exception {
        return this.createBroker(this.getRemoteBrokerURI());
    }
}

