/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.File;
import java.io.IOException;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.JournalRWPerfToolSupport;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.JournalFacade;

public class JournalRWPerfTool
extends JournalRWPerfToolSupport {
    private int logFileSize = 0x3200000;

    public static void main(String[] args) throws Exception {
        JournalRWPerfTool tool = new JournalRWPerfTool();
        tool.initialWriteWorkers = 10;
        tool.syncFrequency = 15;
        tool.writeWorkerIncrement = 0;
        tool.writeWorkerThinkTime = 0;
        tool.verbose = false;
        tool.incrementDelay = 5000L;
        if (args.length > 0) {
            tool.journalDirectory = new File(args[0]);
        }
        if (args.length > 1) {
            tool.writeWorkerIncrement = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            tool.incrementDelay = Long.parseLong(args[2]);
        }
        if (args.length > 3) {
            tool.verbose = Boolean.getBoolean(args[3]);
        }
        if (args.length > 4) {
            tool.recordSize = Integer.parseInt(args[4]);
        }
        if (args.length > 5) {
            tool.syncFrequency = Integer.parseInt(args[5]);
        }
        if (args.length > 6) {
            tool.writeWorkerThinkTime = Integer.parseInt(args[6]);
        }
        tool.exec();
    }

    public Journal createJournal() throws IOException {
        AsyncDataManager dm = new AsyncDataManager();
        dm.setMaxFileLength(this.logFileSize);
        dm.setDirectory(this.journalDirectory);
        dm.start();
        return new JournalFacade(dm);
    }
}

