/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jndi;

import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.jndi.ActiveMQInitialContextFactoryTest;

public class CustomConnectionFactoryNameTest
extends ActiveMQInitialContextFactoryTest {
    public void testConnectionFactoriesArePresent() throws NamingException {
        super.testConnectionFactoriesArePresent();
        this.assertConnectionFactoryPresent("jms/Connection");
        this.assertConnectionFactoryPresent("jms/DURABLE_SUB_CONNECTION_FACTORY");
    }

    public void testConnectionFactoriesAreConfigured() throws NamingException {
        super.testConnectionFactoriesArePresent();
        ActiveMQConnectionFactory factory1 = (ActiveMQConnectionFactory)this.context.lookup("jms/Connection");
        CustomConnectionFactoryNameTest.assertNull((Object)factory1.getClientID());
        ActiveMQConnectionFactory factory2 = (ActiveMQConnectionFactory)this.context.lookup("jms/DURABLE_SUB_CONNECTION_FACTORY");
        CustomConnectionFactoryNameTest.assertEquals((String)"testclient", (String)factory2.getClientID());
    }

    protected String getConnectionFactoryLookupName() {
        return "myConnectionFactory";
    }

    protected void configureEnvironment() {
        super.configureEnvironment();
        this.environment.put("connectionFactoryNames", " myConnectionFactory, jms/Connection, jms/DURABLE_SUB_CONNECTION_FACTORY");
        this.environment.put("connection.jms/DURABLE_SUB_CONNECTION_FACTORY.clientID", "testclient");
    }
}

