/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;

public class JournalRoutePerformance
extends ContextTestSupport {
    AtomicLong produceCounter = new AtomicLong();
    AtomicLong consumeCounter = new AtomicLong();
    AtomicBoolean running = new AtomicBoolean(true);

    public void testPerformance() throws Exception {
        int payLoadSize = 1024;
        int concurrentProducers = 50;
        long delayBetweenSample = 1000L;
        long perfTestDuration = 60000L;
        StringBuffer t = new StringBuffer();
        for (int i = 0; i < payLoadSize; ++i) {
            t.append(97 + i % 26);
        }
        final byte[] payload = t.toString().getBytes("UTF-8");
        for (int i = 0; i < concurrentProducers; ++i) {
            Thread thread = new Thread("Producer: " + i){

                public void run() {
                    while (JournalRoutePerformance.this.running.get()) {
                        JournalRoutePerformance.this.template.sendBody("direct:in", (Object)payload);
                        JournalRoutePerformance.this.produceCounter.incrementAndGet();
                    }
                }
            };
            thread.start();
        }
        long produceTotal = 0L;
        long consumeTotal = 0L;
        long start = System.currentTimeMillis();
        long end = start + perfTestDuration;
        while (System.currentTimeMillis() < end) {
            Thread.sleep(delayBetweenSample);
            long totalTime = System.currentTimeMillis() - start;
            long p = this.produceCounter.getAndSet(0L);
            long c = this.consumeCounter.getAndSet(0L);
            System.out.println("Interval Produced " + this.stat(p, delayBetweenSample) + " m/s, Consumed " + this.stat(c, delayBetweenSample) + " m/s");
            System.out.println("Total Produced " + this.stat(produceTotal += p, totalTime) + " m/s, Consumed " + this.stat(consumeTotal += c, totalTime) + " m/s");
        }
        this.running.set(false);
    }

    private String stat(long pd, long delayBetweenSample) {
        return "" + 1.0 * (double)pd / (double)delayBetweenSample * 1000.0;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:in").to("activemq.journal:target/perf-test");
                this.from("activemq.journal:target/perf-test").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        JournalRoutePerformance.this.consumeCounter.incrementAndGet();
                    }
                });
            }
        };
    }
}

