/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.io.File;
import org.apache.activemq.camel.component.JournalEndpoint;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;

public class JournalConfigureTest
extends ContextTestSupport {
    public void testDefaltConfig() throws Exception {
        JournalEndpoint endpoint = this.resolveMandatoryEndpoint("activemq.journal:target/test");
        JournalConfigureTest.assertEquals((String)"directory", (Object)new File("target", "test"), (Object)endpoint.getDirectory());
        JournalConfigureTest.assertEquals((String)"syncConsume", (boolean)false, (boolean)endpoint.isSyncConsume());
        JournalConfigureTest.assertEquals((String)"syncProduce", (boolean)true, (boolean)endpoint.isSyncProduce());
    }

    public void testConfigViaOptions() throws Exception {
        JournalEndpoint endpoint = this.resolveMandatoryEndpoint("activemq.journal:target/test?syncConsume=true&syncProduce=false");
        JournalConfigureTest.assertEquals((String)"directory", (Object)new File("target", "test"), (Object)endpoint.getDirectory());
        JournalConfigureTest.assertEquals((String)"syncConsume", (boolean)true, (boolean)endpoint.isSyncConsume());
        JournalConfigureTest.assertEquals((String)"syncProduce", (boolean)false, (boolean)endpoint.isSyncProduce());
    }

    protected JournalEndpoint resolveMandatoryEndpoint(String uri) {
        Endpoint endpoint = super.resolveMandatoryEndpoint(uri);
        return (JournalEndpoint)((Object)this.assertIsInstanceOf(JournalEndpoint.class, endpoint));
    }
}

