/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DeadLetterTestSupport
extends TestSupport {
    private static final Log LOG = LogFactory.getLog(DeadLetterTestSupport.class);
    protected int messageCount = 10;
    protected long timeToLive;
    protected Connection connection;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected int deliveryMode = 2;
    protected boolean durableSubscriber;
    protected Destination dlqDestination;
    protected MessageConsumer dlqConsumer;
    protected BrokerService broker;
    protected boolean transactedMode;
    protected int acknowledgeMode = 2;
    private Destination destination;

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = this.createBroker();
        this.broker.start();
        this.connection = this.createConnection();
        this.connection.setClientID(this.toString());
        this.session = this.connection.createSession(this.transactedMode, this.acknowledgeMode);
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected abstract void doTest() throws Exception;

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        return broker;
    }

    protected void makeConsumer() throws JMSException {
        Destination destination = this.getDestination();
        LOG.info("Consuming from: " + destination);
        this.consumer = this.durableSubscriber ? this.session.createDurableSubscriber((Topic)destination, destination.toString()) : this.session.createConsumer(destination);
    }

    protected void makeDlqConsumer() throws JMSException {
        this.dlqDestination = this.createDlqDestination();
        LOG.info("Consuming from dead letter on: " + this.dlqDestination);
        this.dlqConsumer = this.session.createConsumer(this.dlqDestination);
    }

    protected void sendMessages() throws JMSException {
        Session session = this.connection.createSession(false, 1);
        this.producer = session.createProducer(this.getDestination());
        this.producer.setDeliveryMode(this.deliveryMode);
        this.producer.setTimeToLive(this.timeToLive);
        LOG.info("Sending " + this.messageCount + " messages to: " + this.getDestination());
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = this.createMessage(session, i);
            this.producer.send(message);
        }
    }

    protected TextMessage createMessage(Session session, int i) throws JMSException {
        return session.createTextMessage(this.getMessageText(i));
    }

    protected String getMessageText(int i) {
        return "message: " + i;
    }

    protected void assertMessage(Message message, int i) throws Exception {
        LOG.info("Received message: " + message);
        DeadLetterTestSupport.assertNotNull((String)("No message received for index: " + i), (Object)message);
        DeadLetterTestSupport.assertTrue((String)("Should be a TextMessage not: " + message), (boolean)(message instanceof TextMessage));
        TextMessage textMessage = (TextMessage)message;
        DeadLetterTestSupport.assertEquals((String)("text of message: " + i), (String)this.getMessageText(i), (String)textMessage.getText());
    }

    protected abstract Destination createDlqDestination();

    public void testTransientTopicMessage() throws Exception {
        this.topic = true;
        this.deliveryMode = 1;
        this.durableSubscriber = true;
        this.doTest();
    }

    public void testDurableTopicMessage() throws Exception {
        this.topic = true;
        this.deliveryMode = 2;
        this.durableSubscriber = true;
        this.doTest();
    }

    public void testTransientQueueMessage() throws Exception {
        this.topic = false;
        this.deliveryMode = 1;
        this.durableSubscriber = false;
        this.doTest();
    }

    public void testDurableQueueMessage() throws Exception {
        this.topic = false;
        this.deliveryMode = 2;
        this.durableSubscriber = false;
        this.doTest();
    }

    public Destination getDestination() {
        if (this.destination == null) {
            this.destination = this.createDestination();
        }
        return this.destination;
    }
}

