/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.InvalidSelectorException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.OpenTypeSupport;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationView
implements DestinationViewMBean {
    private static final Log LOG = LogFactory.getLog(DestinationViewMBean.class);
    protected final Destination destination;
    protected final ManagedRegionBroker broker;

    public DestinationView(ManagedRegionBroker broker, Destination destination) {
        this.broker = broker;
        this.destination = destination;
    }

    public void gc() {
        this.destination.gc();
    }

    @Override
    public String getName() {
        return this.destination.getName();
    }

    @Override
    public void resetStatistics() {
        this.destination.getDestinationStatistics().reset();
    }

    @Override
    public long getEnqueueCount() {
        return this.destination.getDestinationStatistics().getEnqueues().getCount();
    }

    @Override
    public long getDequeueCount() {
        return this.destination.getDestinationStatistics().getDequeues().getCount();
    }

    @Override
    public long getDispatchCount() {
        return this.destination.getDestinationStatistics().getDispatched().getCount();
    }

    @Override
    public long getInFlightCount() {
        return this.destination.getDestinationStatistics().getInflight().getCount();
    }

    @Override
    public long getConsumerCount() {
        return this.destination.getDestinationStatistics().getConsumers().getCount();
    }

    @Override
    public long getQueueSize() {
        return this.destination.getDestinationStatistics().getMessages().getCount();
    }

    public long getMessagesCached() {
        return this.destination.getDestinationStatistics().getMessagesCached().getCount();
    }

    @Override
    public int getMemoryPercentUsage() {
        return this.destination.getMemoryUsage().getPercentUsage();
    }

    @Override
    public long getMemoryLimit() {
        return this.destination.getMemoryUsage().getLimit();
    }

    @Override
    public void setMemoryLimit(long limit) {
        this.destination.getMemoryUsage().setLimit(limit);
    }

    @Override
    public double getAverageEnqueueTime() {
        return this.destination.getDestinationStatistics().getProcessTime().getAverageTime();
    }

    @Override
    public long getMaxEnqueueTime() {
        return this.destination.getDestinationStatistics().getProcessTime().getMaxTime();
    }

    @Override
    public long getMinEnqueueTime() {
        return this.destination.getDestinationStatistics().getProcessTime().getMinTime();
    }

    @Override
    public CompositeData[] browse() throws OpenDataException {
        try {
            return this.browse(null);
        }
        catch (InvalidSelectorException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompositeData[] browse(String selector) throws OpenDataException, InvalidSelectorException {
        Message[] messages = this.destination.browse();
        ArrayList<CompositeData> c = new ArrayList<CompositeData>();
        MessageEvaluationContext ctx = new MessageEvaluationContext();
        ctx.setDestination(this.destination.getActiveMQDestination());
        BooleanExpression selectorExpression = selector == null ? null : new SelectorParser().parse(selector);
        for (int i = 0; i < messages.length; ++i) {
            try {
                if (selectorExpression == null) {
                    c.add(OpenTypeSupport.convert(messages[i]));
                    continue;
                }
                ctx.setMessageReference(messages[i]);
                if (!selectorExpression.matches(ctx)) continue;
                c.add(OpenTypeSupport.convert(messages[i]));
                continue;
            }
            catch (Throwable e) {
                LOG.warn("exception browsing destination", e);
            }
        }
        CompositeData[] rc = new CompositeData[c.size()];
        c.toArray(rc);
        return rc;
    }

    @Override
    public List<Object> browseMessages() throws InvalidSelectorException {
        return this.browseMessages(null);
    }

    @Override
    public List<Object> browseMessages(String selector) throws InvalidSelectorException {
        Message[] messages = this.destination.browse();
        ArrayList<Object> answer = new ArrayList<Object>();
        MessageEvaluationContext ctx = new MessageEvaluationContext();
        ctx.setDestination(this.destination.getActiveMQDestination());
        BooleanExpression selectorExpression = selector == null ? null : new SelectorParser().parse(selector);
        for (int i = 0; i < messages.length; ++i) {
            try {
                Message message = messages[i];
                if (selectorExpression == null) {
                    answer.add(OpenTypeSupport.convert(message));
                    continue;
                }
                ctx.setMessageReference(message);
                if (!selectorExpression.matches(ctx)) continue;
                answer.add(message);
                continue;
            }
            catch (Throwable e) {
                LOG.warn("exception browsing destination", e);
            }
        }
        return answer;
    }

    @Override
    public TabularData browseAsTable() throws OpenDataException {
        try {
            return this.browseAsTable(null);
        }
        catch (InvalidSelectorException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TabularData browseAsTable(String selector) throws OpenDataException, InvalidSelectorException {
        OpenTypeSupport.OpenTypeFactory factory = OpenTypeSupport.getFactory(ActiveMQMessage.class);
        Message[] messages = this.destination.browse();
        CompositeType ct = factory.getCompositeType();
        TabularType tt = new TabularType("MessageList", "MessageList", ct, new String[]{"JMSMessageID"});
        TabularDataSupport rc = new TabularDataSupport(tt);
        MessageEvaluationContext ctx = new MessageEvaluationContext();
        ctx.setDestination(this.destination.getActiveMQDestination());
        BooleanExpression selectorExpression = selector == null ? null : new SelectorParser().parse(selector);
        for (int i = 0; i < messages.length; ++i) {
            try {
                if (selectorExpression == null) {
                    rc.put(new CompositeDataSupport(ct, factory.getFields(messages[i])));
                    continue;
                }
                ctx.setMessageReference(messages[i]);
                if (!selectorExpression.matches(ctx)) continue;
                rc.put(new CompositeDataSupport(ct, factory.getFields(messages[i])));
                continue;
            }
            catch (Throwable e) {
                LOG.warn("exception browsing destination", e);
            }
        }
        return rc;
    }

    @Override
    public String sendTextMessage(String body) throws Exception {
        return this.sendTextMessage(Collections.EMPTY_MAP, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendTextMessage(Map headers, String body) throws Exception {
        String brokerUrl = "vm://" + this.broker.getBrokerName();
        ActiveMQDestination dest = this.destination.getActiveMQDestination();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(brokerUrl);
        Connection connection = null;
        try {
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(dest);
            ActiveMQTextMessage msg = (ActiveMQTextMessage)session.createTextMessage(body);
            for (Map.Entry entry : headers.entrySet()) {
                msg.setObjectProperty((String)entry.getKey(), entry.getValue());
            }
            producer.setDeliveryMode(msg.getJMSDeliveryMode());
            producer.setPriority(msg.getPriority());
            long ttl = msg.getExpiration() - System.currentTimeMillis();
            producer.setTimeToLive(ttl > 0L ? ttl : 0L);
            producer.send(msg);
            String string = msg.getJMSMessageID();
            return string;
        }
        finally {
            connection.close();
        }
    }

    @Override
    public int getMaxAuditDepth() {
        return this.destination.getMaxAuditDepth();
    }

    @Override
    public int getMaxProducersToAudit() {
        return this.destination.getMaxProducersToAudit();
    }

    public boolean isEnableAudit() {
        return this.destination.isEnableAudit();
    }

    public void setEnableAudit(boolean enableAudit) {
        this.destination.setEnableAudit(enableAudit);
    }

    @Override
    public void setMaxAuditDepth(int maxAuditDepth) {
        this.destination.setMaxAuditDepth(maxAuditDepth);
    }

    @Override
    public void setMaxProducersToAudit(int maxProducersToAudit) {
        this.destination.setMaxProducersToAudit(maxProducersToAudit);
    }

    @Override
    public float getMemoryUsagePortion() {
        return this.destination.getMemoryUsage().getUsagePortion();
    }

    @Override
    public long getProducerCount() {
        return this.destination.getDestinationStatistics().getProducers().getCount();
    }

    @Override
    public boolean isProducerFlowControl() {
        return this.destination.isProducerFlowControl();
    }

    @Override
    public void setMemoryUsagePortion(float value) {
        this.destination.getMemoryUsage().setUsagePortion(value);
    }

    @Override
    public void setProducerFlowControl(boolean producerFlowControl) {
        this.destination.setProducerFlowControl(producerFlowControl);
    }
}

