/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.ServiceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubConnection
implements Service {
    private final BlockingQueue<Object> dispatchQueue = new LinkedBlockingQueue<Object>();
    private Connection connection;
    private Transport transport;
    private boolean shuttingDown;
    private TransportListener listener;
    public AtomicReference<Throwable> error = new AtomicReference();

    public StubConnection(BrokerService broker) throws Exception {
        this(TransportFactory.connect(broker.getVmConnectorURI()));
    }

    public StubConnection(Connection connection) {
        this.connection = connection;
    }

    public StubConnection(Transport transport) throws Exception {
        this.transport = transport;
        transport.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object command) {
                try {
                    if (command.getClass() == ShutdownInfo.class) {
                        StubConnection.this.shuttingDown = true;
                    }
                    StubConnection.this.dispatch(command);
                }
                catch (Exception e) {
                    this.onException(new IOException("" + e));
                }
            }

            public void onException(IOException e) {
                if (StubConnection.this.listener != null) {
                    StubConnection.this.listener.onException(e);
                }
                StubConnection.this.error.set(e);
            }
        });
        transport.start();
    }

    protected void dispatch(Object command) throws InterruptedException, IOException {
        if (this.listener != null) {
            this.listener.onCommand(command);
        }
        this.dispatchQueue.put(command);
    }

    public BlockingQueue<Object> getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void send(Command command) throws Exception {
        if (command instanceof Message) {
            Message message = (Message)command;
            message.setProducerId(message.getMessageId().getProducerId());
        }
        command.setResponseRequired(false);
        if (this.connection != null) {
            Response response = this.connection.service(command);
            if (response != null && response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                throw JMSExceptionSupport.create(er.getException());
            }
        } else if (this.transport != null) {
            this.transport.oneway(command);
        }
    }

    public Response request(Command command) throws Exception {
        Response response;
        if (command instanceof Message) {
            Message message = (Message)command;
            message.setProducerId(message.getMessageId().getProducerId());
        }
        command.setResponseRequired(true);
        if (this.connection != null) {
            response = this.connection.service(command);
            if (response != null && response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                throw JMSExceptionSupport.create(er.getException());
            }
            return response;
        }
        if (this.transport != null) {
            response = (Response)this.transport.request(command);
            if (response != null && response.isException()) {
                ExceptionResponse er = (ExceptionResponse)response;
                throw JMSExceptionSupport.create(er.getException());
            }
            return response;
        }
        return null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        this.shuttingDown = true;
        if (this.transport != null) {
            try {
                this.transport.oneway(new ShutdownInfo());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ServiceSupport.dispose(this.transport);
        }
    }

    public TransportListener getListener() {
        return this.listener;
    }

    public void setListener(TransportListener listener) {
        this.listener = listener;
    }
}

