/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.blob.DefaultBlobUploadStrategy;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.activemq.command.MessageId;

public class DefaultBlobUploadStrategyTest
extends TestCase {
    private static final String FILESERVER_URL = "http://localhost:8080/";
    private static final String URI = "vm://localhost?jms.blobTransferPolicy.defaultUploadUrl=http://localhost:8080/";

    public static void main(String[] args) {
        TestRunner.run(DefaultBlobUploadStrategyTest.class);
    }

    public void testDummy() throws Exception {
    }

    public void xtestUploadViaDefaultBlobUploadStrategy() throws Exception {
        int c;
        File file = File.createTempFile("amq-data-file-", ".dat");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.append("Hello World!");
        writer.close();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(URI);
        BlobTransferPolicy policy = factory.getBlobTransferPolicy();
        ActiveMQBlobMessage msg = new ActiveMQBlobMessage();
        msg.setMessageId(new MessageId());
        DefaultBlobUploadStrategy strategy = new DefaultBlobUploadStrategy(policy);
        strategy.uploadFile(msg, file);
        msg.setURL(new URL(FILESERVER_URL + msg.getMessageId()));
        InputStream in = msg.getInputStream();
        long bytesRead = 0L;
        byte[] buffer = new byte[0x100000];
        while ((c = in.read(buffer)) != -1) {
            bytesRead += (long)c;
        }
        in.close();
        TestCase.assertTrue((bytesRead == file.length() ? 1 : 0) != 0);
        strategy.deleteFile(msg);
    }
}

