/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.jms.core.JmsTemplate;

public abstract class EmbeddedBrokerTestSupport
extends TestCase {
    protected BrokerService broker;
    protected String bindAddress = "vm://localhost";
    protected ConnectionFactory connectionFactory;
    protected boolean useTopic;
    protected Destination destination;
    protected JmsTemplate template;
    private boolean usePooledConnectionWithTemplate = true;

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        this.startBroker();
        this.connectionFactory = this.createConnectionFactory();
        this.destination = this.createDestination();
        this.template = this.createJmsTemplate();
        this.template.setDefaultDestination(this.destination);
        this.template.setPubSubDomain(this.useTopic);
        this.template.afterPropertiesSet();
    }

    protected void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected JmsTemplate createJmsTemplate() {
        if (this.usePooledConnectionWithTemplate) {
            return new JmsTemplate((ConnectionFactory)new PooledConnectionFactory(this.bindAddress));
        }
        return new JmsTemplate(this.connectionFactory);
    }

    protected Destination createDestination() {
        return this.createDestination(this.getDestinationString());
    }

    protected Destination createDestination(String subject) {
        if (this.useTopic) {
            return new ActiveMQTopic(subject);
        }
        return new ActiveMQQueue(subject);
    }

    protected String getDestinationString() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.bindAddress);
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected void startBroker() throws Exception {
        this.broker.start();
    }

    protected boolean isPersistent() {
        return false;
    }

    protected Connection createConnection() throws Exception {
        return this.connectionFactory.createConnection();
    }
}

