/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.antora.maven.FileUtils;
import org.antora.maven.FrontendMojoExecutor;
import org.antora.maven.NodeVersionResolver;
import org.antora.maven.PackageJsonExplorer;
import org.antora.maven.PackageSpec;
import org.antora.maven.Platform;
import org.antora.maven.PlaybookProvider;
import org.antora.maven.ProvidedPlaybookRetriever;
import org.antora.maven.SystemNodeLinker;
import org.antora.maven.UserPropertyOptionCollector;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="antora", configurator="antora", requiresProject=false)
public class AntoraMavenPlugin
extends AbstractMojo {
    private static final String ANTORA_PACKAGE_NAME = "antora";
    private static final String ANTORA_CLI_PACKAGE_NAME = "@antora/cli";
    private static final String ANTORA_GENERATOR_PACKAGE_NAME = "@antora/site-generator";
    private static final String ANTORA_COMMAND_NAME = "antora";
    private static final String ANTORA_OPTION_PREFIX = "antora.option.";
    private static final String DEFAULT_PLAYBOOK_FILE = "antora-playbook.yml";
    private static final String PROVIDED_PLAYBOOK_FILE = "provided-antora-playbook.yml";
    private static final String NODE_MODULES = "node_modules";
    private final Platform platform = new Platform();
    @Component
    private BuildPluginManager buildPluginManager;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(alias="env")
    private Map<String, String> environmentVariables = Map.of();
    @Parameter(property="node.downloadServerId")
    private String nodeDownloadServerId;
    @Parameter(property="node.downloadUrl", defaultValue="https://nodejs.org/dist")
    private URL nodeDownloadUrl;
    @Parameter(property="node.executable")
    private String nodeExecutable;
    @Parameter(property="node.installDirectory")
    private File nodeInstallDirectory;
    @Parameter(defaultValue="lts", property="node.version")
    private String nodeVersion;
    @Parameter(property="antora.options")
    private List<String> options;
    @Parameter(property="antora.additionalOptions")
    private List<String> additionalOptions;
    @Parameter(property="antora.packages")
    private List<String> packages;
    @Parameter(property="antora.additionalPackages")
    private List<String> additionalPackages;
    @Parameter(alias="playbook", defaultValue="antora-playbook.yml", property="antora.playbook", required=true)
    private File playbookFile;
    @Parameter
    private PlaybookProvider playbookProvider;
    @Parameter(defaultValue="false", property="antora.skip")
    private boolean skip;
    @Parameter(defaultValue="latest")
    private String version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String playbookArgument;
        File basedir;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Antora site generation per configuration.");
            return;
        }
        this.validate();
        boolean standalone = !this.mavenSession.getRequest().isProjectPresent();
        File file = basedir = standalone ? FileUtils.currentDirectory() : this.mavenProject.getBasedir();
        if (this.nodeInstallDirectory == null) {
            this.nodeInstallDirectory = standalone ? basedir : new File(this.mavenProject.getBuild().getDirectory());
        }
        File nodeHomeDir = new File(this.nodeInstallDirectory, "node");
        File npmCacheDir = null;
        FrontendMojoExecutor frontendMojoExecutor = new FrontendMojoExecutor(this.getLog(), this.buildPluginManager, this.mavenSession, this.element("installDirectory", this.nodeInstallDirectory.getPath()));
        SystemNodeLinker systemNodeLinker = new SystemNodeLinker(this.getLog(), nodeHomeDir);
        if (this.nodeExecutable == null) {
            systemNodeLinker.unlinkNode();
            String resolvedNodeVersion = new NodeVersionResolver(this.getLog(), this.nodeDownloadUrl).resolveVersion(this.nodeVersion);
            frontendMojoExecutor.handleNodeVersionChange(nodeHomeDir, resolvedNodeVersion);
            npmCacheDir = new File(nodeHomeDir, "_npm");
            frontendMojoExecutor.executeMojo("install-node-and-npm", this.element("nodeDownloadRoot", this.chomp(this.nodeDownloadUrl.toString(), "/") + "/"), this.element("serverId", this.nodeDownloadServerId), this.element("nodeVersion", resolvedNodeVersion));
        } else {
            systemNodeLinker.linkNode(Path.of(this.nodeExecutable, new String[0]).toString());
        }
        LinkedHashMap<String, PackageSpec> allPackages = new LinkedHashMap<String, PackageSpec>();
        boolean usingNodeModules = false;
        if (this.playbookProvider == null) {
            playbookArgument = basedir.toPath().relativize(this.playbookFile.toPath()).toString();
            PackageJsonExplorer packageJsonExplorer = new PackageJsonExplorer(basedir);
            if (packageJsonExplorer.hasPackageFileWithDependencies()) {
                usingNodeModules = true;
                boolean hasLockfile = packageJsonExplorer.hasLockfile();
                frontendMojoExecutor.executeMojo("npm", this.element("arguments", hasLockfile ? "ci" : "i"), this.element("environmentVariables", this.npmInstallEnvironmentVariables(hasLockfile, npmCacheDir)));
                String antoraCommandName = this.platform.npmPackageCommandName("antora");
                if (!packageJsonExplorer.isBinScriptInstalled(antoraCommandName)) {
                    String cliVersion = packageJsonExplorer.getPackageVersion(ANTORA_GENERATOR_PACKAGE_NAME, hasLockfile);
                    if (cliVersion == null) {
                        this.getLog().info((CharSequence)"Could not determine version of Antora from package.json. Using value from version parameter instead.");
                        cliVersion = this.version;
                    }
                    this.addPackage(this.antoraCliPackage(cliVersion), allPackages);
                }
            } else {
                this.addPackage(this.antoraPackage(this.version), allPackages);
                this.addPackages(this.packages, allPackages);
                this.addPackages(this.additionalPackages, allPackages);
            }
        } else {
            File providedPlaybook = new File(basedir, PROVIDED_PLAYBOOK_FILE);
            playbookArgument = providedPlaybook.getName();
            Map<String, PackageSpec> providedPackages = new ProvidedPlaybookRetriever(this.getLog(), basedir).retrievePlaybook(this.playbookProvider, providedPlaybook);
            PackageSpec antoraPackage = providedPackages.remove("antora");
            if (this.mojoExecution.getConfiguration().getChild("version").getValue() != null) {
                antoraPackage = null;
            }
            providedPackages.remove(ANTORA_CLI_PACKAGE_NAME);
            this.addPackage(antoraPackage == null ? this.antoraPackage(this.version) : antoraPackage, allPackages);
            allPackages.putAll(providedPackages);
            this.addPackages(this.additionalPackages, allPackages);
        }
        if (!usingNodeModules) {
            this.deleteNodeModules(basedir);
        }
        List<String> allOptions = this.collectOptions(this.options, this.additionalOptions, this.mavenSession.getUserProperties());
        try {
            frontendMojoExecutor.executeMojo("npx", this.element("arguments", this.npxAntoraArguments(allPackages.values(), allOptions, playbookArgument)), this.element("environmentVariables", this.antoraEnvironmentVariables(this.environmentVariables, npmCacheDir)), this.element("skip", "false"));
        }
        catch (MojoExecutionException e) {
            throw new MojoFailureException("Antora failed to generate site successfully", (Throwable)e);
        }
    }

    private void validate() throws MojoExecutionException {
        File homeNodeModulesDir = new File(System.getProperty("user.home"), NODE_MODULES);
        if (homeNodeModulesDir.isDirectory() && !FileUtils.isEmptyDirectory(homeNodeModulesDir)) {
            this.getLog().warn((CharSequence)"Detected the existence of $HOME/node_modules, which is not compatible with this plugin. Please delete it.");
        }
        this.playbookProvider = PlaybookProvider.validate(this.playbookProvider);
        if (this.playbookProvider == null && !this.playbookFile.exists()) {
            String message = "Antora playbook file not found: " + String.valueOf(this.playbookFile);
            this.getLog().error((CharSequence)("Cannot run Antora because " + message));
            throw new MojoExecutionException(message);
        }
    }

    private Map<String, String> npmInstallEnvironmentVariables(boolean hasPackageLockFile, File npmCacheDir) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (npmCacheDir != null) {
            env.put("npm_config_cache", npmCacheDir.getPath());
        }
        env.put("npm_config_fund", "false");
        env.put("npm_config_omit", "optional");
        if (!hasPackageLockFile) {
            env.put("npm_config_package_lock", "false");
        }
        env.put("npm_config_update_notifier", "false");
        return env;
    }

    private String npxAntoraArguments(Collection<PackageSpec> allPackages, List<String> allOptions, String argument) {
        ArrayList<String> arguments = new ArrayList<String>(List.of("--yes"));
        if (allPackages.isEmpty()) {
            arguments.set(0, "--offline");
        } else {
            for (PackageSpec packageSpec : allPackages) {
                this.drain(arguments.add("--package") && arguments.add(packageSpec.toString()));
            }
        }
        arguments.add("antora");
        arguments.addAll(this.antoraOptions(allOptions));
        arguments.add(argument);
        return String.join((CharSequence)" ", arguments);
    }

    private List<String> antoraOptions(List<String> allOptions) {
        LinkedHashMap<String, List<String>> optionsMap = new LinkedHashMap<String, List<String>>();
        MavenExecutionRequest mavenExecutionRequest = this.mavenSession.getRequest();
        if (mavenExecutionRequest.isShowErrors()) {
            optionsMap.put("stacktrace", null);
        }
        if (mavenExecutionRequest.isProjectPresent()) {
            Path relativeBuildDirectory = this.mavenProject.getBasedir().toPath().relativize(Path.of(this.mavenProject.getBuild().getDirectory(), "site"));
            optionsMap.put("to-dir", List.of(this.platform.escapeCommandLineArgument(relativeBuildDirectory)));
        }
        if (allOptions != null) {
            this.appendOptions(allOptions, optionsMap);
        }
        ArrayList<String> opts = new ArrayList<String>();
        optionsMap.forEach((name, values) -> {
            String flag = "--" + name;
            if (values == null) {
                opts.add(flag);
                return;
            }
            values.forEach(value -> this.drain(opts.add(flag) && opts.add((String)value)));
        });
        return opts;
    }

    private Map<String, String> antoraEnvironmentVariables(Map<String, String> env, File npmCacheDir) {
        String nodeOptions;
        Map<String, String> systemEnv;
        String isTTY = (env = env.isEmpty() ? new HashMap<String, String>() : new HashMap<String, String>(env)).getOrDefault("IS_TTY", (systemEnv = System.getenv()).get("IS_TTY"));
        if (isTTY == null) {
            isTTY = "true";
            env.put("IS_TTY", "true");
        }
        String forceColorOverride = env.get("FORCE_COLOR");
        String noColorOverride = env.get("NO_COLOR");
        if ("true".equals(isTTY) && !"true".equals(noColorOverride) && !systemEnv.containsKey("NO_COLOR") && !"true".equals(forceColorOverride) && !systemEnv.containsKey("FORCE_COLOR") && this.mavenSession.getRequest().isInteractiveMode()) {
            forceColorOverride = "true";
            env.put("FORCE_COLOR", "true");
        }
        if (!"true".equals(forceColorOverride)) {
            env.remove("FORCE_COLOR");
        }
        if (!"true".equals(noColorOverride)) {
            env.remove("NO_COLOR");
        }
        env.put("NODE_OPTIONS", (String)((nodeOptions = env.getOrDefault("NODE_OPTIONS", systemEnv.get("NODE_OPTIONS"))) == null ? "" : nodeOptions + " ") + "--no-global-search-paths");
        if (npmCacheDir != null) {
            env.put("npm_config_cache", npmCacheDir.getPath());
        }
        env.put("npm_config_fund", "false");
        env.put("npm_config_lockfile_version", "3");
        env.put("npm_config_omit", "optional");
        env.put("npm_config_update_notifier", "false");
        return env;
    }

    private PackageSpec antoraPackage(String versionSpec) {
        return new PackageSpec("antora", versionSpec);
    }

    private PackageSpec antoraCliPackage(String versionSpec) {
        return new PackageSpec(ANTORA_CLI_PACKAGE_NAME, versionSpec);
    }

    private void addPackage(PackageSpec value, Map<String, PackageSpec> to) {
        to.put(value.getName(), value);
    }

    private void addPackages(List<String> packageSpecs, Map<String, PackageSpec> to) {
        if (packageSpecs.isEmpty()) {
            return;
        }
        for (String packageSpec : packageSpecs) {
            PackageSpec value;
            String name;
            if (packageSpec == null || (packageSpec = packageSpec.trim()).isEmpty() || "antora".equals(name = (value = PackageSpec.valueOf(packageSpec)).getName()) || ANTORA_CLI_PACKAGE_NAME.equals(name)) continue;
            to.put(name, value);
        }
    }

    private void deleteNodeModules(File basedir) {
        try {
            if (FileUtils.deleteDirectory(new File(basedir, NODE_MODULES))) {
                this.getLog().info((CharSequence)("Removing node_modules in " + String.valueOf(basedir)));
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Detected the existence of node_modules in " + String.valueOf(basedir) + ", which is not compatible with the current configuration of this plugin. Please delete it."));
        }
    }

    private void appendOptions(List<String> from, Map<String, List<String>> to) {
        from.forEach(text -> {
            String value;
            int indexOfLastCharInName;
            char lastCharInName;
            if (text == null || (text = text.stripLeading()).isEmpty()) {
                return;
            }
            String[] segments = text.split("[ =]", 2);
            String name = segments[0];
            if (name.startsWith("--")) {
                name = name.substring(2);
            }
            if ((lastCharInName = name.charAt(indexOfLastCharInName = name.length() - 1)) == '!') {
                to.remove(name.substring(0, indexOfLastCharInName));
                return;
            }
            String string = value = segments.length == 2 ? segments[1].stripTrailing() : null;
            if (lastCharInName == '?') {
                String[] valueAndFallbackValue;
                name = name.substring(0, indexOfLastCharInName);
                if (value == null || "false".equals(value)) {
                    value = null;
                } else if (value.contains(":") && (value = (valueAndFallbackValue = value.split(":", 2))[0].stripLeading()).isEmpty() && ((value = valueAndFallbackValue[1]).isEmpty() || "false".equals(value))) {
                    value = null;
                }
                this.drain(value == null ? to.remove(name) : to.put(name, null));
            } else if (value == null) {
                to.put(name, null);
            } else {
                value = this.platform.escapeCommandLineArgument(value);
                if (lastCharInName == ']' && indexOfLastCharInName > 1 && name.endsWith("[]")) {
                    List instances = (List)to.get(name = name.substring(0, indexOfLastCharInName - 1));
                    this.drain(instances == null ? to.put(name, this.createSingleValueList(value)) : Boolean.valueOf(instances.add(value)));
                } else {
                    to.put(name, this.createSingleValueList(value));
                }
            }
        });
    }

    private List<String> collectOptions(List<String> main, List<String> additional, Properties userProperties) {
        List<String> individual;
        ArrayList<String> result = new ArrayList<String>();
        if (!main.isEmpty()) {
            result.addAll(main);
        }
        if (!additional.isEmpty()) {
            result.addAll(additional);
        }
        if (!(individual = new UserPropertyOptionCollector(ANTORA_OPTION_PREFIX).collectOptions(userProperties)).isEmpty()) {
            result.addAll(individual);
        }
        return result.isEmpty() ? null : result;
    }

    private String chomp(String value, String tail) {
        return value.endsWith(tail) ? value.substring(0, value.length() - tail.length()) : value;
    }

    private List<String> createSingleValueList(String value) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(value);
        return list;
    }

    private void drain(Object result) {
    }

    private Xpp3Dom element(String name, String value) {
        Xpp3Dom result = new Xpp3Dom(name);
        result.setValue(value);
        return result;
    }

    private Xpp3Dom element(String name, Map<String, String> entries) {
        Xpp3Dom result = new Xpp3Dom(name);
        entries.forEach((entryName, entryValue) -> {
            Xpp3Dom entry = new Xpp3Dom(entryName);
            entry.setValue(entryValue);
            result.addChild(entry);
        });
        return result;
    }
}

