/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.util.List;
import org.ansj.domain.NewWordNatureAttr;
import org.ansj.domain.Term;
import org.ansj.library.NatureLibrary;
import org.ansj.library.NgramLibrary;
import org.ansj.recognition.NatureRecognition;

public class MathUtil {
    private static final double dSmoothingPara = 0.1;
    private static final int MAX_FREQUENCE = 2079997;
    private static final double dTemp = 4.807699241873907E-7;

    public static double compuScore(Term from, Term to) {
        double frequency = from.getTermNatures().allFreq + 1;
        if (frequency < 0.0) {
            return from.getScore() + 2079997.0;
        }
        int nTwoWordsFreq = NgramLibrary.getTwoWordFreq(from, to);
        double value = -Math.log(0.1 * frequency / 2159997.0 + 0.9 * (0.9999995192300758 * (double)nTwoWordsFreq / frequency + 4.807699241873907E-7));
        if (value < 0.0) {
            value += frequency;
        }
        if (value < 0.0) {
            value += frequency;
        }
        return from.getScore() + value;
    }

    public static double compuScoreFreq(Term from, Term term) {
        return from.getTermNatures().allFreq + term.getTermNatures().allFreq;
    }

    public static double compuNatureFreq(NatureRecognition.NatureTerm from, NatureRecognition.NatureTerm to) {
        double twoWordFreq = NatureLibrary.getTwoNatureFreq(from.termNature.nature, to.termNature.nature);
        if (twoWordFreq == 0.0) {
            twoWordFreq = Math.log(from.selfScore + to.selfScore);
        }
        double score = from.score + Math.log((from.selfScore + to.selfScore) * twoWordFreq) + to.selfScore;
        return score;
    }

    public static void main(String[] args) {
        System.out.println(Math.log(9.615398483747813E-7));
    }

    public static double leftRightEntropy(List<Term> all) {
        double score = 0.0;
        NewWordNatureAttr newWordAttr = null;
        Term first = all.get(0);
        int twoWordFreq = NgramLibrary.getTwoWordFreq(first.getFrom(), first);
        score -= (double)twoWordFreq;
        int length = all.size() - 1;
        Term end = all.get(all.size() - 1);
        twoWordFreq = NgramLibrary.getTwoWordFreq(end, end.getTo());
        score -= (double)twoWordFreq;
        for (int i = 0; i < length; ++i) {
            score -= (double)NgramLibrary.getTwoWordFreq(all.get(i), all.get(i + 1));
        }
        if (score < -3.0) {
            return 0.0;
        }
        newWordAttr = first.getTermNatures().newWordAttr;
        score += MathUtil.getTermScore(newWordAttr, newWordAttr.getB());
        newWordAttr = end.getTermNatures().newWordAttr;
        score += MathUtil.getTermScore(newWordAttr, newWordAttr.getE());
        double midelScore = 0.0;
        Term term = null;
        for (int i = 1; i < length; ++i) {
            term = all.get(i);
            newWordAttr = term.getTermNatures().newWordAttr;
            midelScore += MathUtil.getTermScore(newWordAttr, newWordAttr.getM());
        }
        return score += midelScore / (double)length;
    }

    private static double getTermScore(NewWordNatureAttr newWordAttr, int freq) {
        if (newWordAttr == NewWordNatureAttr.NULL) {
            return 3.0;
        }
        return (double)freq / (double)(newWordAttr.getAll() + 1) * Math.log(500000.0 / (double)(newWordAttr.getAll() + 1));
    }
}

