/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.util.List;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.library.InitDictionary;
import org.ansj.splitWord.Analysis;

public class Graph {
    protected String str = null;
    public Term[] terms = null;
    protected Term end = null;
    protected Term root = null;
    protected static final String E = "\u672b##\u672b";
    protected static final String B = "\u59cb##\u59cb";
    public boolean hasPerson;
    public boolean hasNum;

    public Graph(String str) {
        this.str = str;
        int size = str.length();
        this.terms = new Term[size + 1];
        this.end = new Term(E, size, TermNatures.END);
        this.root = new Term(B, -1, TermNatures.BEGIN);
        this.terms[size] = this.end;
    }

    public List<Term> getResult(Analysis.Merger merger) {
        return merger.merger();
    }

    public void addTerm(Term term) {
        if (!this.hasNum && term.getTermNatures().numAttr.numFreq > 0) {
            this.hasNum = true;
        }
        if (!this.hasPerson && term.getTermNatures().personAttr.flag) {
            this.hasPerson = true;
        }
        this.terms[term.getOffe()] = this.terms[term.getOffe()] == null ? term : term.setNext(this.terms[term.getOffe()]);
    }

    protected Term optimalRoot() {
        Term to = this.end;
        to.clearScore();
        Term from = null;
        while ((from = to.getFrom()) != null) {
            for (int i = from.getOffe() + 1; i < to.getOffe(); ++i) {
                this.terms[i] = null;
            }
            if (from.getOffe() > -1) {
                this.terms[from.getOffe()] = from;
            }
            from.setNext(null);
            from.setTo(to);
            from.clearScore();
            to = from;
        }
        return this.root;
    }

    public void rmLittlePath() {
        int maxTo = -1;
        Term temp = null;
        Term maxTerm = null;
        boolean flag = false;
        int length = this.terms.length - 1;
        block4: for (int i = 0; i < length; ++i) {
            maxTerm = this.getMaxTerm(i);
            if (maxTerm == null) continue;
            maxTo = maxTerm.getToValue();
            switch (maxTerm.getName().length()) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    if (this.terms[i + 1] == null) {
                        ++i;
                        continue block4;
                    }
                }
                default: {
                    int j;
                    for (j = i + 1; j < maxTo; ++j) {
                        temp = this.getMaxTerm(j);
                        if (temp == null || maxTo >= temp.getToValue()) continue;
                        maxTo = temp.getToValue();
                        flag = true;
                    }
                    if (flag) {
                        i = maxTo - 1;
                        flag = false;
                        continue block4;
                    }
                    maxTerm.setNext(null);
                    this.terms[i] = maxTerm;
                    for (j = i + 1; j < maxTo; ++j) {
                        this.terms[j] = null;
                    }
                }
            }
        }
    }

    private Term getMaxTerm(int i) {
        Term maxTerm = this.terms[i];
        if (maxTerm == null) {
            return null;
        }
        int maxTo = maxTerm.getToValue();
        Term term = maxTerm;
        while ((term = term.getNext()) != null) {
            if (maxTo >= term.getToValue()) continue;
            maxTo = term.getToValue();
            maxTerm = term;
        }
        return maxTerm;
    }

    public void rmLittleSinglePath() {
        int maxTo = -1;
        Term temp = null;
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i] == null || (maxTo = this.terms[i].getToValue()) - i == 1 || i + 1 == this.terms.length) continue;
            for (int j = i; j < maxTo; ++j) {
                temp = this.terms[j];
                if (temp == null || temp.getToValue() > maxTo || temp.getName().length() != 1) continue;
                this.terms[j] = null;
            }
        }
    }

    public void walkPathByScore() {
        Term term = null;
        this.mergerByScore(this.root, 0);
        for (int i = 0; i < this.terms.length; ++i) {
            for (term = this.terms[i]; term != null && term.getFrom() != null && term != this.end; term = term.getNext()) {
                int to = term.getToValue();
                this.mergerByScore(term, to);
            }
        }
        this.optimalRoot();
    }

    public void walkPath() {
        Term term = null;
        this.merger(this.root, 0);
        for (int i = 0; i < this.terms.length; ++i) {
            for (term = this.terms[i]; term != null && term.getFrom() != null && term != this.end; term = term.getNext()) {
                int to = term.getToValue();
                this.merger(term, to);
            }
        }
        this.optimalRoot();
    }

    private void merger(Term fromTerm, int to) {
        Term term = null;
        if (this.terms[to] != null) {
            for (term = this.terms[to]; term != null; term = term.getNext()) {
                term.setPathScore(fromTerm);
            }
        } else {
            char c = this.str.charAt(to);
            TermNatures tn = InitDictionary.termNatures[c];
            if (tn == null) {
                tn = TermNatures.NULL;
            }
            this.terms[to] = new Term(String.valueOf(c), to, tn);
            this.terms[to].setPathScore(fromTerm);
        }
    }

    private void mergerByScore(Term fromTerm, int to) {
        Term term = null;
        if (this.terms[to] != null) {
            for (term = this.terms[to]; term != null; term = term.getNext()) {
                term.setPathSelfScore(fromTerm);
            }
        }
    }
}

