/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import love.cq.domain.Forest;
import love.cq.domain.Value;
import love.cq.domain.WoodInterface;
import love.cq.library.Library;
import love.cq.util.IOUtil;
import love.cq.util.StringUtil;
import org.ansj.library.UserDefineLibrary;

public class DicManager {
    private static String userLibraryPath = null;
    private static File[] files = new File[0];
    private Forest forest = null;
    private String name;
    private static final ReentrantLock LOCK = new ReentrantLock();

    public DicManager(String name) {
        this.name = name;
    }

    public void insertFileToLibrary(String filePath, String charEncoding) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertFileToLibrary(File file, String charEncoding) {
        String forestName = file.getName().split("-")[0];
        Forest forest = UserDefineLibrary.getUserForestMap().get(forestName);
        if (forest == null) {
            forest = new Forest();
            UserDefineLibrary.getUserForestMap().put(forestName, forest);
        }
        BufferedReader reader = null;
        String temp = null;
        try {
            reader = IOUtil.getReader((InputStream)new FileInputStream(file), (String)"utf-8");
            while (StringUtil.isNotBlank((CharSequence)(temp = reader.readLine()))) {
                Library.insertWord((WoodInterface)forest, (String)temp.toLowerCase());
            }
        }
        catch (Exception e) {
            System.err.println("init library error " + file.getName() + " the error is " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void insertWordToLibrary(String word) {
        this.insertWordToLibrary(word, "userDefine", UserDefineLibrary.DEFAULT_FREQ);
    }

    public void insertWordToLibrary(String word, String nature, int freq) {
        Library.insertWord((Forest)this.forest, (Value)new Value(word.toLowerCase(), new String[]{nature, String.valueOf(freq)}));
    }

    public static Forest getLibrary(String name) {
        Forest forest = UserDefineLibrary.getUserForestMap().get(name);
        if (forest != null) {
            return forest;
        }
        if (files == null || files.length == 0) {
            System.err.println("not find any library by name " + name);
            return null;
        }
        new DicManager(name).initLibraryByName(name);
        return UserDefineLibrary.getUserForestMap().get(name);
    }

    private void initLibraryByName(String name) {
        Forest forest = null;
        LOCK.lock();
        forest = UserDefineLibrary.getUserForestMap().get(name);
        if (forest != null) {
            return;
        }
        DicManager dicManager = new DicManager(name);
        boolean flag = false;
        for (File file : files) {
            if (!file.getName().equals(name) && !file.getName().startsWith(name + "-")) continue;
            flag = true;
            dicManager.insertFileToLibrary(file, "utf-8");
        }
        if (!flag) {
            System.err.println("not find any library by name " + name);
        }
        LOCK.unlock();
    }
}

