/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord.analysis;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import love.cq.domain.Forest;
import org.ansj.domain.Term;
import org.ansj.library.UserDefineLibrary;
import org.ansj.recognition.AsianPersonRecognition;
import org.ansj.recognition.ForeignPersonRecognition;
import org.ansj.recognition.NumRecognition;
import org.ansj.recognition.UserDefineRecognition;
import org.ansj.splitWord.Analysis;
import org.ansj.util.Graph;

public class ToAnalysis
extends Analysis {
    private Forest[] forests = null;

    @Override
    protected List<Term> getResult(final Graph graph) {
        Analysis.Merger merger = new Analysis.Merger(){

            @Override
            public List<Term> merger() {
                graph.walkPath();
                if (graph.hasNum) {
                    NumRecognition.recognition(graph.terms);
                }
                if (graph.hasPerson) {
                    new AsianPersonRecognition(graph.terms).recognition();
                    graph.walkPathByScore();
                    AsianPersonRecognition.nameAmbiguity(graph.terms);
                    new ForeignPersonRecognition(graph.terms).recognition();
                    graph.walkPathByScore();
                }
                if (ToAnalysis.this.forests == null) {
                    this.userDefineRecognition(graph, null);
                } else {
                    for (Forest forest : ToAnalysis.this.forests) {
                        if (forest == null) continue;
                        this.userDefineRecognition(graph, forest);
                    }
                }
                return this.getResult();
            }

            private void userDefineRecognition(Graph graph2, Forest forest) {
                new UserDefineRecognition(graph2.terms, forest).recognition();
                graph2.rmLittlePath();
                graph2.walkPathByScore();
            }

            private List<Term> getResult() {
                ArrayList<Term> result = new ArrayList<Term>();
                int length = graph.terms.length - 1;
                for (int i = 0; i < length; ++i) {
                    if (graph.terms[i] == null) continue;
                    result.add(graph.terms[i]);
                }
                return result;
            }
        };
        return merger.merger();
    }

    private ToAnalysis() {
    }

    public ToAnalysis(Forest[] forests) {
        if (forests == null) {
            forests = new Forest[]{UserDefineLibrary.FOREST};
        }
        this.forests = forests;
    }

    public ToAnalysis(Reader reader) {
        super(reader);
    }

    public ToAnalysis(Reader reader, Forest[] forests) {
        super(reader);
        if (forests == null) {
            forests = new Forest[]{UserDefineLibrary.FOREST};
        }
        this.forests = forests;
    }

    public static List<Term> parse(String str) {
        return new ToAnalysis().parseStr(str);
    }

    public static List<Term> parse(String str, Forest ... forests) {
        return new ToAnalysis(forests).parseStr(str);
    }
}

