/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord.analysis;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.ansj.app.newWord.LearnTool;
import org.ansj.domain.Term;
import org.ansj.recognition.NatureRecognition;
import org.ansj.recognition.NewWordRecognition;
import org.ansj.recognition.NumRecognition;
import org.ansj.recognition.UserDefineRecognition;
import org.ansj.splitWord.Analysis;
import org.ansj.util.Graph;

public class NlpAnalysis
extends Analysis {
    private LearnTool learn = null;

    public NlpAnalysis(Reader reader, LearnTool learn) {
        super(reader);
        this.learn = learn;
    }

    @Override
    protected List<Term> getResult(final Graph graph) {
        Analysis.Merger merger = new Analysis.Merger(){

            @Override
            public List<Term> merger() {
                graph.walkPath();
                if (graph.hasNum) {
                    NumRecognition.recognition(graph.terms);
                }
                List<Term> result = this.getResult();
                new NatureRecognition(result).recognition();
                NlpAnalysis.this.learn.learn(graph);
                new UserDefineRecognition(graph.terms).recognition();
                graph.walkPathByScore();
                new NewWordRecognition(graph.terms, NlpAnalysis.this.learn).recognition();
                graph.walkPathByScore();
                result = this.getResult();
                return result;
            }

            private List<Term> getResult() {
                ArrayList<Term> result = new ArrayList<Term>();
                int length = graph.terms.length - 1;
                for (int i = 0; i < length; ++i) {
                    if (graph.terms[i] == null) continue;
                    result.add(graph.terms[i]);
                }
                return result;
            }
        };
        return merger.merger();
    }

    private NlpAnalysis(LearnTool learn) {
        this.learn = learn;
    }

    public static List<Term> parse(String str, LearnTool learn) {
        return new NlpAnalysis(learn).parseStr(str);
    }

    public static List<Term> parse(String str) {
        return new NlpAnalysis(new LearnTool()).parseStr(str);
    }
}

