/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord.analysis;

import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import org.ansj.domain.Term;
import org.ansj.recognition.AsianPersonRecognition;
import org.ansj.recognition.NumRecognition;
import org.ansj.recognition.UserDefineRecognition;
import org.ansj.splitWord.Analysis;
import org.ansj.util.Graph;

public class IndexAnalysis
extends Analysis {
    public IndexAnalysis(Reader reader) {
        super(reader);
    }

    @Override
    protected List<Term> getResult(final Graph graph) {
        Analysis.Merger merger = new Analysis.Merger(){

            @Override
            public List<Term> merger() {
                graph.walkPath();
                NumRecognition.recognition(graph.terms);
                new AsianPersonRecognition(graph.terms).recognition();
                new UserDefineRecognition(graph.terms).recognition();
                return this.result();
            }

            private List<Term> result() {
                LinkedList<Term> all = new LinkedList<Term>();
                Term term = null;
                String temp = null;
                int length = graph.terms.length - 1;
                for (int i = 0; i < length; ++i) {
                    term = graph.terms[i];
                    while (term != null) {
                        all.add(term);
                        temp = term.getName();
                        if ((term = term.getNext()) != null && term.getName().length() != 1 && !temp.equals(term.getName())) continue;
                    }
                }
                return all;
            }
        };
        return merger.merger();
    }

    private IndexAnalysis() {
    }

    public static List<Term> parse(String str) {
        return new IndexAnalysis().parseStr(str);
    }
}

