/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import love.cq.splitWord.GetWord;
import love.cq.util.StringUtil;
import org.ansj.domain.Term;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.library.InitDictionary;
import org.ansj.library.UserDefineLibrary;
import org.ansj.splitWord.impl.GetWordsImpl;
import org.ansj.util.Graph;
import org.ansj.util.WordAlert;

public abstract class Analysis {
    public int offe;
    private int tempLength;
    private GetWordsImpl gwi = new GetWordsImpl();
    private BufferedReader br;
    private LinkedList<Term> terms = new LinkedList();
    private Term term = null;

    public Analysis(Reader reader) {
        this.br = new BufferedReader(reader);
    }

    protected Analysis() {
    }

    public Term next() throws IOException {
        if (!this.terms.isEmpty()) {
            this.term = this.terms.poll();
            this.term.updateOffe(this.offe);
            return this.term;
        }
        String temp = this.br.readLine();
        while (StringUtil.isBlank((CharSequence)temp)) {
            if (temp == null) {
                return null;
            }
            this.offe = this.offe + temp.length() + 1;
            temp = this.br.readLine();
        }
        this.offe += this.tempLength;
        this.analysisStr(temp);
        if (!this.terms.isEmpty()) {
            this.term = this.terms.poll();
            this.term.updateOffe(this.offe);
            return this.term;
        }
        return null;
    }

    private void analysisStr(String temp) {
        Graph gp = new Graph(temp);
        int startOffe = 0;
        if (UserDefineLibrary.ambiguityForest != null) {
            GetWord gw = new GetWord(UserDefineLibrary.ambiguityForest, temp);
            String[] params = null;
            while (gw.getAllWords() != null) {
                if (gw.offe > startOffe) {
                    this.analysis(gp, temp.substring(startOffe, gw.offe), startOffe);
                }
                params = gw.getParams();
                startOffe = gw.offe;
                for (int i = 0; i < params.length; i += 2) {
                    gp.addTerm(new Term(params[i], startOffe, new TermNatures(new TermNature(params[i + 1], 1))));
                    startOffe += params[i].length();
                }
            }
            if (startOffe == 0) {
                this.analysis(gp, temp, startOffe);
            } else {
                this.analysis(gp, temp.substring(startOffe, temp.length()), startOffe);
            }
        } else {
            this.analysis(gp, temp, startOffe);
        }
        List<Term> result = this.getResult(gp);
        this.terms.addAll(result);
    }

    private void analysis(Graph gp, String temp, int startOffe) {
        int start = 0;
        int end = 0;
        int length = 0;
        length = temp.length();
        this.tempLength = length + 1;
        String str = null;
        char c = '\u0000';
        block5: for (int i = 0; i < length; ++i) {
            switch (InitDictionary.status[InitDictionary.conversion(temp.charAt(i))]) {
                case 0: {
                    gp.addTerm(new Term(temp.charAt(i) + "", startOffe + i, TermNatures.NULL));
                    continue block5;
                }
                case 4: {
                    start = i;
                    end = 1;
                    while (++i < length && InitDictionary.status[temp.charAt(i)] == 4) {
                        ++end;
                    }
                    str = WordAlert.alertEnglish(temp, start, end);
                    gp.addTerm(new Term(str, start + startOffe, TermNatures.EN));
                    --i;
                    continue block5;
                }
                case 5: {
                    start = i;
                    end = 1;
                    while (++i < length && InitDictionary.status[temp.charAt(i)] == 5) {
                        ++end;
                    }
                    str = WordAlert.alertNumber(temp, start, end);
                    gp.addTerm(new Term(str, start + startOffe, TermNatures.NB));
                    --i;
                    continue block5;
                }
                default: {
                    start = i;
                    end = i;
                    c = temp.charAt(start);
                    while (InitDictionary.IN_SYSTEM[c] > '\u0000') {
                        ++end;
                        if (++i >= length) break;
                        c = temp.charAt(i);
                    }
                    if (start == end) {
                        gp.addTerm(new Term(String.valueOf(c), i + startOffe, TermNatures.NULL));
                    }
                    str = temp.substring(start, end);
                    this.gwi.setStr(str);
                    while ((str = this.gwi.allWords()) != null) {
                        gp.addTerm(new Term(str, this.gwi.offe + start + startOffe, this.gwi.getTermNatures()));
                    }
                    if (InitDictionary.IN_SYSTEM[c] > '\u0000' || InitDictionary.status[c] > 3) {
                        --i;
                        continue block5;
                    }
                    gp.addTerm(new Term(String.valueOf(c), i + startOffe, TermNatures.NULL));
                }
            }
        }
    }

    protected List<Term> parseStr(String temp) {
        this.analysisStr(temp);
        return this.terms;
    }

    protected abstract List<Term> getResult(Graph var1);

    public void resetContent(BufferedReader br) {
        this.offe = 0;
        this.tempLength = 0;
        this.br = br;
    }

    public abstract class Merger {
        public abstract List<Term> merger();
    }
}

