/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition;

import love.cq.domain.Forest;
import love.cq.domain.WoodInterface;
import love.cq.util.ObjectBean;
import org.ansj.domain.Term;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.library.UserDefineLibrary;
import org.ansj.util.TermUtil;

public class UserDefineRecognition {
    private Term[] terms = null;
    private WoodInterface forest;
    private WoodInterface branch = this.forest = UserDefineLibrary.FOREST;
    private int offe = -1;
    private int endOffe = -1;
    private int tempFreq = 50;
    private String tempNature;

    public UserDefineRecognition(Term[] terms) {
        this.terms = terms;
    }

    public UserDefineRecognition(Term[] terms, Forest forest) {
        this.terms = terms;
        if (forest != null) {
            this.branch = this.forest = forest;
        }
    }

    public void recognition() {
        if (this.branch == null) {
            return;
        }
        int length = this.terms.length - 1;
        boolean flag = true;
        for (int i = 0; i < length; ++i) {
            if (this.terms[i] == null) continue;
            flag = this.branch != this.forest;
            this.branch = this.termStatus(this.branch, this.terms[i]);
            if (this.branch == null) {
                if (this.offe != -1) {
                    i = this.offe;
                }
                this.reset();
                continue;
            }
            if (this.branch.getStatus() == 3) {
                this.endOffe = i;
                this.tempNature = this.branch.getParams()[0];
                this.tempFreq = ObjectBean.getInt((String)this.branch.getParams()[1], (int)50);
                if (this.offe != -1 && this.offe < this.endOffe) {
                    i = this.offe;
                    this.makeNewTerm();
                    this.reset();
                    continue;
                }
                this.reset();
                continue;
            }
            if (this.branch.getStatus() == 2) {
                this.endOffe = i;
                if (this.offe == -1) {
                    this.offe = i;
                    continue;
                }
                this.tempNature = this.branch.getParams()[0];
                this.tempFreq = ObjectBean.getInt((String)this.branch.getParams()[1], (int)50);
                if (!flag) continue;
                this.makeNewTerm();
                continue;
            }
            if (this.branch.getStatus() != 1 || this.offe != -1) continue;
            this.offe = i;
        }
        if (this.offe != -1 && this.offe < this.endOffe) {
            this.makeNewTerm();
        }
    }

    private void makeNewTerm() {
        StringBuilder sb = new StringBuilder();
        for (int j = this.offe; j <= this.endOffe; ++j) {
            if (this.terms[j] == null) continue;
            sb.append(this.terms[j].getName());
        }
        TermNatures termNatures = new TermNatures(new TermNature(this.tempNature, this.tempFreq));
        Term term = new Term(sb.toString(), this.offe, termNatures);
        term.setNature(termNatures.termNatures[0].nature);
        term.selfScore = -1 * this.tempFreq;
        TermUtil.insertTerm(this.terms, term);
    }

    private void reset() {
        this.offe = -1;
        this.endOffe = -1;
        this.tempFreq = 50;
        this.tempNature = null;
        this.branch = this.forest;
    }

    private WoodInterface termStatus(WoodInterface branch, Term term) {
        String name = term.getName();
        for (int j = 0; j < name.length(); ++j) {
            if ((branch = branch.get(name.charAt(j))) != null) continue;
            return null;
        }
        return branch;
    }
}

