/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition;

import love.cq.domain.SmartForest;
import org.ansj.app.newWord.LearnTool;
import org.ansj.domain.NewWord;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.util.TermUtil;

public class NewWordRecognition {
    private Term[] terms = null;
    private double score;
    private StringBuilder sb = new StringBuilder();
    private SmartForest<NewWord> forest = null;
    private SmartForest<NewWord> branch = null;
    private TermNatures tempNatures;
    private Term from;
    private Term to;
    private int offe;

    public NewWordRecognition(Term[] terms, LearnTool learn) {
        this.terms = terms;
        this.forest = learn.getForest();
        this.branch = learn.getForest();
    }

    public void recognition() {
        if (this.branch == null) {
            return;
        }
        int length = this.terms.length - 1;
        Term term = null;
        for (int i = 0; i < length; ++i) {
            if (this.terms[i] == null) continue;
            this.from = this.terms[i].getFrom();
            this.terms[i].score = 0.0;
            this.terms[i].selfScore = 0.0;
            this.branch = this.branch.getBranch(this.terms[i].getName());
            if (this.branch == null || this.branch.getStatus() == 3) {
                this.reset();
                continue;
            }
            this.offe = i;
            term = this.terms[i];
            this.sb.append(term.getName());
            if (this.branch.getStatus() == 2) {
                term.selfScore = ((NewWord)this.branch.getParam()).getScore();
            }
            boolean flag = true;
            block6: while (flag) {
                term = term.getTo();
                this.branch = this.branch.getBranch(term.getName());
                if (this.branch == null) break;
                switch (this.branch.getStatus()) {
                    case 1: {
                        this.sb.append(term.getName());
                        continue block6;
                    }
                    case 2: {
                        this.sb.append(term.getName());
                        this.score = ((NewWord)this.branch.getParam()).getScore();
                        this.tempNatures = ((NewWord)this.branch.getParam()).getNature();
                        this.to = term.getTo();
                        this.makeNewTerm();
                        continue block6;
                    }
                    case 3: {
                        this.sb.append(term.getName());
                        this.score = ((NewWord)this.branch.getParam()).getScore();
                        this.tempNatures = ((NewWord)this.branch.getParam()).getNature();
                        this.to = term.getTo();
                        this.makeNewTerm();
                        flag = false;
                        continue block6;
                    }
                }
                System.out.println("\u600e\u4e48\u80fd\u51fa\u73b00\u5462?");
            }
            this.reset();
        }
    }

    private void makeNewTerm() {
        Term term = new Term(this.sb.toString(), this.offe, this.tempNatures);
        term.selfScore = this.score;
        term.setNature(this.tempNatures.termNatures[0].nature);
        TermUtil.termLink(this.from, term);
        TermUtil.termLink(term, this.to);
        TermUtil.insertTerm(this.terms, term);
    }

    private void reset() {
        this.offe = -1;
        this.tempNatures = null;
        this.branch = this.forest;
        this.score = 0.0;
        this.sb = new StringBuilder();
    }
}

