/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition;

import java.util.List;
import org.ansj.domain.Term;
import org.ansj.domain.TermNature;
import org.ansj.util.MathUtil;

public class NatureRecognition {
    private NatureTerm root = new NatureTerm(TermNature.BEGIN);
    private NatureTerm[] end = new NatureTerm[]{new NatureTerm(TermNature.END)};
    private List<Term> terms = null;
    private NatureTerm[][] natureTermTable = null;

    public NatureRecognition(List<Term> terms) {
        this.terms = terms;
        this.natureTermTable = new NatureTerm[terms.size() + 1][];
        this.natureTermTable[terms.size()] = this.end;
    }

    public void recognition() {
        int length = this.terms.size();
        for (int i = 0; i < length; ++i) {
            this.natureTermTable[i] = this.getNatureTermArr(this.terms.get((int)i).getTermNatures().termNatures);
        }
        this.walk();
    }

    public void walk() {
        int length = this.natureTermTable.length - 1;
        this.setScore(this.root, this.natureTermTable[0]);
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this.natureTermTable[i].length; ++j) {
                this.setScore(this.natureTermTable[i][j], this.natureTermTable[i + 1]);
            }
        }
        this.optimalRoot();
    }

    private void setScore(NatureTerm natureTerm, NatureTerm[] natureTerms) {
        for (int i = 0; i < natureTerms.length; ++i) {
            natureTerms[i].setScore(natureTerm);
        }
    }

    private NatureTerm[] getNatureTermArr(TermNature[] termNatures) {
        NatureTerm[] natureTerms = new NatureTerm[termNatures.length];
        for (int i = 0; i < natureTerms.length; ++i) {
            natureTerms[i] = new NatureTerm(termNatures[i]);
        }
        return natureTerms;
    }

    private void optimalRoot() {
        NatureTerm to = this.end[0];
        NatureTerm from = null;
        int index = this.natureTermTable.length - 1;
        while ((from = to.from) != null && index > 0) {
            this.terms.get(--index).setNature(from.termNature.nature);
            to = from;
        }
    }

    public class NatureTerm {
        public TermNature termNature;
        public double score = 0.0;
        public double selfScore;
        public NatureTerm from;

        protected NatureTerm(TermNature termNature) {
            this.termNature = termNature;
            this.selfScore = termNature.frequency + 1;
        }

        public void setScore(NatureTerm natureTerm) {
            double tempScore = MathUtil.compuNatureFreq(natureTerm, this);
            if (this.from == null || this.score < tempScore) {
                this.score = tempScore;
                this.from = natureTerm;
            }
        }

        public String toString() {
            return this.termNature.nature.natureStr + "/" + this.selfScore;
        }
    }
}

