/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition;

import java.util.ArrayList;
import java.util.List;
import org.ansj.domain.CompanyNatureAttr;
import org.ansj.domain.NewWord;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.library.company.CompanyAttrLibrary;
import org.ansj.util.TermUtil;

public class CompanyRecogntion {
    private static final double[] FACTORY = CompanyAttrLibrary.loadFactory();
    private Term[] terms;
    private Term tempTerm = null;
    private int offe;
    private Term beginTerm;
    private Term maxTerm = null;

    public CompanyRecogntion(Term[] terms) {
        this.terms = terms;
    }

    public List<NewWord> getNewWords() {
        ArrayList<NewWord> all = new ArrayList<NewWord>();
        Term term = null;
        for (int i = 0; i < this.terms.length; ++i) {
            term = this.terms[i];
            if (term == null) continue;
            term.selfScore = 0.0;
            term.score = 0.0;
            if (!(term.getTermNatures().companyAttr.bb < -0.005) || term.getTermNatures().companyAttr.b <= 1000) continue;
            double tempScore = term.getTermNatures().companyAttr.bb;
            this.offe = term.getOffe();
            this.tempTerm = null;
            this.beginTerm = term.getFrom();
            this.recogntion(term, tempScore);
            if (this.maxTerm == null) continue;
            all.add(new NewWord(this.maxTerm.getName(), TermNatures.NT, this.maxTerm.selfScore, 1));
            this.maxTerm = null;
        }
        return all;
    }

    public void recogntion() {
        Term term = null;
        for (int i = 0; i < this.terms.length; ++i) {
            term = this.terms[i];
            if (term == null) continue;
            term.selfScore = 0.0;
            term.score = 0.0;
            if (!(term.getTermNatures().companyAttr.bb < -0.005) || term.getTermNatures().companyAttr.b <= 1000) continue;
            double tempScore = term.getTermNatures().companyAttr.bb;
            this.offe = term.getOffe();
            this.tempTerm = null;
            this.beginTerm = term.getFrom();
            this.recogntion(term, tempScore);
            if (this.maxTerm == null) continue;
            TermUtil.insertTerm(this.terms, this.maxTerm);
            this.maxTerm = null;
        }
    }

    private void recogntion(Term term, double score) {
        String companyName = term.getName();
        CompanyNatureAttr companyAttr = null;
        while ((term = term.getTo()) != null && (companyAttr = term.getTermNatures().companyAttr) != CompanyNatureAttr.NULL) {
            companyName = companyName + term.getName();
            if (companyAttr.eb < -0.005 && companyAttr.e > 200) {
                Term to;
                this.tempTerm = new Term(companyName, this.offe, TermNatures.NT);
                this.tempTerm.selfScore = score += term.getTermNatures().companyAttr.eb;
                if (this.beginTerm == null || this.beginTerm.getTermNatures() == TermNatures.BEGIN) {
                    this.tempTerm.selfScore += this.beginTerm.getTermNatures().companyAttr.pb;
                }
                if ((to = term.getTo()) == null || to.getTermNatures() == TermNatures.END) {
                    this.tempTerm.selfScore += to.getTermNatures().companyAttr.sb;
                }
                int length = companyName.length() > 50 ? 50 : companyName.length();
                this.tempTerm.selfScore *= -Math.log(1.0 - FACTORY[length]);
                if (this.maxTerm == null || this.maxTerm.selfScore > this.tempTerm.selfScore) {
                    this.maxTerm = this.tempTerm;
                }
            }
            if (companyAttr.mb < -0.005 && companyAttr.m > 50) {
                score += term.getTermNatures().companyAttr.mb;
                continue;
            }
            return;
        }
    }
}

