/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.recognition;

import java.util.ArrayList;
import java.util.List;
import org.ansj.domain.NewWord;
import org.ansj.domain.PersonNatureAttr;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.library.NgramLibrary;
import org.ansj.util.TermUtil;

public class AsianPersonRecognition {
    private static final double[] FACTORY = new double[]{0.16271366224044456, 0.8060521860870434, 0.031234151672511947};
    private boolean skip = false;
    private Term[] terms;

    public AsianPersonRecognition(Term[] terms) {
        this.terms = terms;
    }

    public void recognition() {
        List<Term> termList = this.recogntion_();
        for (Term term2 : termList) {
            TermUtil.insertTerm(this.terms, term2);
        }
    }

    private List<Term> recogntion_() {
        Term term = null;
        Term tempTerm = null;
        ArrayList<Term> termList = new ArrayList<Term>();
        int beginFreq = 10;
        for (int i = 0; i < this.terms.length; ++i) {
            term = this.terms[i];
            if (term == null || !term.getTermNatures().personAttr.flag) continue;
            term.score = 0.0;
            term.selfScore = 0.0;
            int freq = 0;
            for (int j = 2; j > -1; --j) {
                freq = term.getTermNatures().personAttr.getFreq(j, 0);
                if (freq <= 10 && (term.getName().length() != 2 || freq <= 10) || (tempTerm = this.nameFind(i, beginFreq, j)) == null) continue;
                termList.add(tempTerm);
                if (!this.skip) continue;
                for (int j2 = i; j2 < tempTerm.getToValue(); ++j2) {
                    if (this.terms[j2] == null) continue;
                    this.terms[j2].score = 0.0;
                    this.terms[j2].selfScore = 0.0;
                }
                i = tempTerm.getToValue() - 1;
                break;
            }
            beginFreq = term.getTermNatures().personAttr.begin + 1;
        }
        return termList;
    }

    private Term nameFind(int offe, int beginFreq, int size) {
        int i;
        StringBuilder sb = new StringBuilder();
        int undefinite = 0;
        this.skip = false;
        PersonNatureAttr pna = null;
        int index = 0;
        int freq = 0;
        double allFreq = 0.0;
        Term term = null;
        for (i = offe; i < this.terms.length; ++i) {
            if (this.terms[i] == null) continue;
            term = this.terms[i];
            pna = term.getTermNatures().personAttr;
            freq = pna.getFreq(size, index);
            if (freq == 0) {
                return null;
            }
            if (pna.allFreq > 0) {
                ++undefinite;
            }
            sb.append(term.getName());
            allFreq += Math.log(term.getTermNatures().allFreq + 1);
            allFreq += -Math.log(freq);
            if (++index == size + 2) break;
        }
        double score = -Math.log(FACTORY[size]);
        score += allFreq;
        double endFreq = 0.0;
        boolean flag = true;
        while (flag) {
            if (++i >= this.terms.length) {
                endFreq = 10.0;
                flag = false;
                continue;
            }
            if (this.terms[i] == null) continue;
            int twoWordFreq = NgramLibrary.getTwoWordFreq(term, this.terms[i]);
            if (twoWordFreq > 3) {
                return null;
            }
            endFreq = this.terms[i].getTermNatures().personAttr.end + 1;
            flag = false;
        }
        score -= Math.log(endFreq);
        if ((score -= Math.log(beginFreq)) > -3.0) {
            return null;
        }
        if (allFreq > 0.0 && undefinite > 0) {
            return null;
        }
        this.skip = undefinite == 0;
        term = new Term(sb.toString(), offe, TermNatures.NR);
        term.selfScore = score;
        return term;
    }

    public List<NewWord> getNewWords() {
        ArrayList<NewWord> all = new ArrayList<NewWord>();
        List<Term> termList = this.recogntion_();
        for (Term term2 : termList) {
            all.add(new NewWord(term2.getName(), TermNatures.NR, term2.selfScore, 1));
        }
        return all;
    }

    public static void nameAmbiguity(Term[] terms) {
        Term term = null;
        Term next = null;
        for (int i = 0; i < terms.length - 1; ++i) {
            term = terms[i];
            if (term == null || term.getTermNatures() != TermNatures.NR || term.getName().length() != 2) continue;
            next = terms[i + 2];
            if (next.getTermNatures().personAttr.split <= 0) continue;
            term.setName(term.getName() + next.getName().charAt(0));
            terms[i + 2] = null;
            terms[i + 3] = new Term(next.getName().substring(1), next.getOffe(), TermNatures.NULL);
            TermUtil.termLink(term, terms[i + 3]);
            TermUtil.termLink(terms[i + 3], next.getTo());
        }
    }
}

