/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library.name;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ansj.domain.PersonNatureAttr;
import org.ansj.util.MyStaticValue;

public class PersonAttrLibrary {
    private HashMap<String, PersonNatureAttr> pnMap = null;

    public HashMap<String, PersonNatureAttr> getPersonMap() throws NumberFormatException, IOException {
        if (this.pnMap != null) {
            return this.pnMap;
        }
        this.init1();
        this.init2();
        return this.pnMap;
    }

    private void init2() throws NumberFormatException, IOException {
        Map<String, int[][]> personFreqMap = MyStaticValue.getPersonFreqMap();
        Set<Map.Entry<String, int[][]>> entrySet = personFreqMap.entrySet();
        PersonNatureAttr pna = null;
        for (Map.Entry<String, int[][]> entry : entrySet) {
            pna = this.pnMap.get(entry.getKey());
            if (pna == null) {
                pna = new PersonNatureAttr();
                pna.setlocFreq(entry.getValue());
                this.pnMap.put(entry.getKey(), pna);
                continue;
            }
            pna.setlocFreq(entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init1() throws NumberFormatException, IOException {
        BufferedReader br = null;
        try {
            this.pnMap = new HashMap();
            br = MyStaticValue.getPersonReader();
            String temp = null;
            String[] strs = null;
            PersonNatureAttr pna = null;
            while ((temp = br.readLine()) != null) {
                pna = new PersonNatureAttr();
                strs = temp.split("\t");
                pna = this.pnMap.get(strs[0]);
                if (pna == null) {
                    pna = new PersonNatureAttr();
                }
                pna.addFreq(Integer.parseInt(strs[1]), Integer.parseInt(strs[2]));
                this.pnMap.put(strs[0], pna);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

