/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import love.cq.domain.Forest;
import love.cq.domain.Value;
import love.cq.library.Library;
import love.cq.util.IOUtil;
import love.cq.util.StringUtil;
import org.ansj.util.MyStaticValue;

public class UserDefineLibrary {
    public static final String DEFAULT_NATURE = "userDefine";
    public static final Integer DEFAULT_FREQ = 1000;
    public static final String DEFAULT_FREQ_STR = "1000";
    public static Forest FOREST = null;
    public static Forest ambiguityForest = null;
    private static final HashMap<String, Forest> userForestMap = new HashMap();

    public static void insertWord(String keyword, String nature, int freq) {
        String[] paramers = new String[]{nature, String.valueOf(freq)};
        Value value = new Value(keyword, paramers);
        Library.insertWord((Forest)FOREST, (Value)value);
    }

    private static void initAmbiguityLibrary() {
        String ambiguityLibrary = MyStaticValue.ambiguityLibrary;
        if (StringUtil.isBlank((CharSequence)ambiguityLibrary)) {
            MyStaticValue.LIBRARYLOG.warning("init ambiguity  waring :" + ambiguityLibrary + " because : not find that file or can not to read !");
            return;
        }
        try {
            ambiguityLibrary = MyStaticValue.ambiguityLibrary;
        }
        catch (Exception exception) {
            MyStaticValue.LIBRARYLOG.warning("init ambiguity  waring :" + ambiguityLibrary + " because : not find that file or can not to read !");
        }
        File file = new File(ambiguityLibrary);
        if (file.isFile() && file.canRead()) {
            try {
                ambiguityForest = Library.makeForest((String)ambiguityLibrary);
            }
            catch (Exception e) {
                MyStaticValue.LIBRARYLOG.warning("init ambiguity  error :" + ambiguityLibrary + " because : not find that file or can not to read !");
                e.printStackTrace();
            }
            MyStaticValue.LIBRARYLOG.info("init ambiguityLibrary ok!");
        } else {
            MyStaticValue.LIBRARYLOG.warning("init ambiguity  waring :" + ambiguityLibrary + " because : not find that file or can not to read !");
        }
    }

    private static void initUserLibrary() {
        try {
            FOREST = new Forest();
            String userLibrary = MyStaticValue.userLibrary;
            UserDefineLibrary.loadLibrary(FOREST, userLibrary);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void loadFile(Forest forest, File file) {
        if (!file.canRead()) {
            MyStaticValue.LIBRARYLOG.warning("file in path " + file.getAbsolutePath() + " can not to read!");
            return;
        }
        String temp = null;
        BufferedReader br = null;
        String[] strs = null;
        Value value = null;
        try {
            br = IOUtil.getReader((InputStream)new FileInputStream(file), (String)"UTF-8");
            while ((temp = br.readLine()) != null) {
                if (StringUtil.isBlank((CharSequence)temp)) continue;
                strs = temp.split("\t");
                value = strs.length != 3 ? new Value(strs[0], new String[]{DEFAULT_NATURE, DEFAULT_FREQ_STR}) : new Value(strs[0], new String[]{strs[1], strs[2]});
                Library.insertWord((Forest)forest, (Value)value);
            }
            MyStaticValue.LIBRARYLOG.info("init user userLibrary ok path is : " + file.getAbsolutePath());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            IOUtil.close((Reader)br);
            br = null;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtil.close(br);
                    br = null;
                    throw throwable;
                }
            }
            IOUtil.close((Reader)br);
            br = null;
        }
        IOUtil.close((Reader)br);
        br = null;
    }

    public static void loadLibrary(Forest forest, String path) {
        File file = null;
        if (path != null) {
            file = new File(path);
            if (!file.canRead() || file.isHidden()) {
                MyStaticValue.LIBRARYLOG.warning("init userLibrary  waring :" + path + " because : not find that file or can not to read !");
                return;
            }
            if (file.isFile()) {
                UserDefineLibrary.loadFile(forest, file);
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().trim().endsWith(".dic")) continue;
                    UserDefineLibrary.loadFile(forest, files[i]);
                }
            } else {
                MyStaticValue.LIBRARYLOG.warning("init user library  error :" + path + " because : not find that file !");
            }
        }
    }

    public static void removeWord(String word) {
        Library.removeWord((Forest)FOREST, (String)word);
    }

    public static void clear() {
        FOREST.clear();
    }

    public static HashMap<String, Forest> getUserForestMap() {
        return userForestMap;
    }

    static {
        UserDefineLibrary.initUserLibrary();
        UserDefineLibrary.initAmbiguityLibrary();
    }
}

