/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import org.ansj.domain.BigramEntry;
import org.ansj.domain.Term;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.library.InitDictionary;
import org.ansj.util.MyStaticValue;

public class NgramLibrary {
    private static BigramEntry[][] bigramTables = null;

    public static void main(String[] args) {
        Term from = new Term("\u963f", 0, new TermNatures(TermNature.NULL));
        from.getTermNatures().id = InitDictionary.getWordId(from.getName());
        Term to = new Term("\u5168\u56fd", 0, new TermNatures(TermNature.NULL));
        to.getTermNatures().id = InitDictionary.getWordId(to.getName());
        System.out.println(NgramLibrary.getTwoWordFreq(from, to));
    }

    public static int getTwoWordFreq(Term from, Term to) {
        if (from.getTermNatures().id < 0) {
            return 0;
        }
        BigramEntry[] be = bigramTables[from.getTermNatures().id];
        int index = NgramLibrary.binarySearch(be, to.getTermNatures().id);
        if (index < 0) {
            return 0;
        }
        return be[index].freq;
    }

    private static int binarySearch(BigramEntry[] be, int key) {
        int low = 0;
        int high = be.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            BigramEntry midVal = be[mid];
            int cmp = midVal.id - key;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static void setBigramTables(BigramEntry[][] bigramTables) {
        NgramLibrary.bigramTables = bigramTables;
    }

    static {
        try {
            long start = System.currentTimeMillis();
            bigramTables = MyStaticValue.getBigramTables();
            MyStaticValue.LIBRARYLOG.info("init ngram ok use time :" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

