/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import love.cq.util.StringUtil;
import org.ansj.domain.Nature;
import org.ansj.domain.Term;
import org.ansj.util.MyStaticValue;

public class NatureLibrary {
    private static final int YI = 1;
    private static final int FYI = -1;
    private static final HashMap<String, Nature> NATUREMAP = new HashMap();
    private static int[][] NATURETABLE = null;

    private static void init() throws IOException {
        String split = "\t";
        BufferedReader reader = MyStaticValue.getNatureMapReader();
        String temp = null;
        String[] strs = null;
        int maxLength = 0;
        int p0 = 0;
        int p1 = 0;
        int p2 = 0;
        while ((temp = reader.readLine()) != null) {
            strs = temp.split(split);
            if (strs.length != 4) continue;
            p0 = Integer.parseInt(strs[0]);
            p1 = Integer.parseInt(strs[1]);
            p2 = Integer.parseInt(strs[3]);
            NATUREMAP.put(strs[2], new Nature(strs[2], p0, p1, p2));
            maxLength = Math.max(maxLength, p1);
        }
        reader.close();
        NATURETABLE = new int[maxLength + 1][maxLength + 1];
        reader = MyStaticValue.getNatureTableReader();
        int j = 0;
        while ((temp = reader.readLine()) != null) {
            if (StringUtil.isBlank((CharSequence)temp)) continue;
            strs = temp.split(split);
            for (int i = 0; i < strs.length; ++i) {
                NatureLibrary.NATURETABLE[j][i] = Integer.parseInt(strs[i]);
            }
            ++j;
        }
        reader.close();
    }

    public static int getTwoNatureFreq(Nature from, Nature to) {
        if (from.index < 0 || to.index < 0) {
            return 0;
        }
        return NATURETABLE[from.index][to.index];
    }

    public static int getTwoTermFreq(Term fromTerm, Term toTerm) {
        Nature from = fromTerm.getNatrue();
        Nature to = toTerm.getNatrue();
        if (from.index < 0 || to.index < 0) {
            return 0;
        }
        return NATURETABLE[from.index][to.index];
    }

    public static Nature getNature(String natureStr) {
        Nature nature = NATUREMAP.get(natureStr);
        if (nature == null) {
            nature = new Nature(natureStr, -1, -1, 1);
            NATUREMAP.put(natureStr, nature);
            return nature;
        }
        return nature;
    }

    public static void main(String[] args) throws IOException {
    }

    static {
        try {
            NatureLibrary.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bcd\u6027\u5217\u8868\u52a0\u8f7d\u5931\u8d25!");
        }
    }
}

