/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import love.cq.util.StringUtil;
import org.ansj.dic.DicReader;
import org.ansj.domain.CompanyNatureAttr;
import org.ansj.domain.NewWordNatureAttr;
import org.ansj.domain.PersonNatureAttr;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.library.company.CompanyAttrLibrary;
import org.ansj.library.name.PersonAttrLibrary;
import org.ansj.library.newWord.NewWordAttrLibrary;
import org.ansj.util.MyStaticValue;

public class InitDictionary {
    public static int arrayLength;
    public static final char[] IN_SYSTEM;
    public static int[] base;
    public static int[] check;
    public static byte[] status;
    public static String[] words;
    public static TermNatures[] termNatures;

    private static void init() {
        long start = System.currentTimeMillis();
        try {
            InitDictionary.initArrays();
            MyStaticValue.LIBRARYLOG.info("init core library ok use time :" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            e.printStackTrace();
            MyStaticValue.LIBRARYLOG.warning("init library core library error! ");
        }
    }

    public static void initArrays() throws Exception {
        BufferedReader reader = MyStaticValue.getArraysReader();
        InitDictionary.initArraySize(reader);
        reader.close();
        reader = MyStaticValue.getArraysReader();
        InitDictionary.initArrays(reader);
        reader.close();
    }

    private static void initArraySize(BufferedReader reader) throws IOException {
        String temp = null;
        String last = null;
        while ((temp = reader.readLine()) != null) {
            last = temp;
        }
        String[] strs = last.split("\t");
        arrayLength = Integer.parseInt(strs[0]) + 1;
        base = new int[arrayLength];
        check = new int[arrayLength];
        status = new byte[arrayLength];
        words = new String[arrayLength];
        termNatures = new TermNatures[arrayLength];
    }

    public static void initArrays(BufferedReader reader) throws Exception {
        HashMap<String, PersonNatureAttr> personMap = new PersonAttrLibrary().getPersonMap();
        PersonNatureAttr personAttr = null;
        HashMap<String, CompanyNatureAttr> companyMap = new CompanyAttrLibrary().getCompanyMap();
        CompanyNatureAttr companyAttr = null;
        HashMap<String, NewWordNatureAttr> newWordMap = new NewWordAttrLibrary().getNewWordMap();
        NewWordNatureAttr newWordAttr = null;
        String temp = null;
        String[] strs = null;
        int num = 0;
        while ((temp = reader.readLine()) != null) {
            strs = temp.split("\t");
            num = Integer.parseInt(strs[0]);
            InitDictionary.base[num] = Integer.parseInt(strs[2]);
            InitDictionary.check[num] = Integer.parseInt(strs[3]);
            InitDictionary.status[num] = Byte.parseByte(strs[4]);
            if ("null".equals(strs[5])) continue;
            InitDictionary.words[num] = strs[1];
            if (status[num] < 4) {
                for (int i = 0; i < strs[1].length(); ++i) {
                    InitDictionary.IN_SYSTEM[strs[1].charAt((int)i)] = strs[1].charAt(i);
                }
            }
            TermNatures tn = new TermNatures(TermNature.setNatureStrToArray(strs[5]), num);
            personAttr = personMap.get(strs[1]);
            if (personAttr != null) {
                tn.setPersonNatureAttr(personAttr);
            }
            if ((companyAttr = companyMap.get(strs[1])) != null) {
                tn.setCompanyAttr(companyAttr);
            }
            if ((newWordAttr = newWordMap.get(strs[1])) != null) {
                newWordAttr.updateAll(tn.allFreq);
                tn.setNewWordAttr(newWordAttr);
            }
            InitDictionary.termNatures[num] = tn;
        }
        Set<Map.Entry<String, PersonNatureAttr>> entrySet = personMap.entrySet();
        char c = '\u0000';
        TermNatures tn = null;
        for (Map.Entry<String, PersonNatureAttr> entry : entrySet) {
            if (entry.getKey().length() != 1 || status[c = entry.getKey().charAt(0)] > 1) continue;
            if (status[c] == 0) {
                InitDictionary.base[c] = c;
                InitDictionary.check[c] = -1;
                InitDictionary.status[c] = 3;
                InitDictionary.words[c] = entry.getKey();
            }
            if ((tn = termNatures[c]) == null) {
                tn = new TermNatures(TermNature.NR);
            }
            tn.setPersonNatureAttr(entry.getValue());
            InitDictionary.termNatures[c] = tn;
        }
        Set<Map.Entry<String, CompanyNatureAttr>> cnSet = companyMap.entrySet();
        for (Map.Entry<String, CompanyNatureAttr> entry : cnSet) {
            if (entry.getKey().length() != 1 || status[c = entry.getKey().charAt(0)] > 1) continue;
            if (status[c] == 0) {
                InitDictionary.base[c] = c;
                InitDictionary.check[c] = -1;
                InitDictionary.status[c] = 3;
                InitDictionary.words[c] = entry.getKey();
            }
            if ((tn = termNatures[c]) == null) {
                tn = new TermNatures(TermNature.NULL);
            }
            tn.setCompanyAttr(entry.getValue());
            InitDictionary.termNatures[c] = tn;
        }
        BufferedReader reader2 = DicReader.getReader("jianFan.dic");
        while ((temp = reader2.readLine()) != null) {
            if (StringUtil.isBlank((CharSequence)(temp = temp.trim())) || IN_SYSTEM[temp.charAt(0)] != '\u0000') continue;
            InitDictionary.IN_SYSTEM[temp.charAt((int)0)] = temp.charAt(2);
        }
        reader.close();
        reader2.close();
    }

    public static boolean isInSystemDic(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return true;
        }
        int baseValue = str.charAt(0);
        int checkValue = 0;
        for (int i = 1; i < str.length(); ++i) {
            checkValue = baseValue;
            if ((baseValue = base[baseValue] + str.charAt(i)) > check.length - 1) {
                return false;
            }
            if (check[baseValue] == -1 || check[baseValue] == checkValue) continue;
            return false;
        }
        return status[baseValue] > 1;
    }

    public static int getWordId(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return 0;
        }
        int baseValue = str.charAt(0);
        int checkValue = 0;
        for (int i = 1; i < str.length(); ++i) {
            checkValue = baseValue;
            if ((baseValue = base[baseValue] + str.charAt(i)) > check.length - 1) {
                return 0;
            }
            if (check[baseValue] == -1 || check[baseValue] == checkValue) continue;
            return 0;
        }
        return baseValue;
    }

    public static char conversion(char c) {
        char value = IN_SYSTEM[c];
        if (value == '\u0000') {
            return c;
        }
        return value;
    }

    static {
        IN_SYSTEM = new char[65536];
        base = null;
        check = null;
        status = null;
        words = null;
        termNatures = null;
        InitDictionary.init();
    }
}

