/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.domain;

import org.ansj.domain.Nature;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.recognition.ForeignPersonRecognition;
import org.ansj.util.MathUtil;

public class Term
implements Comparable<Term> {
    public static final Term NULL = new Term("NULL", 0, TermNatures.NULL);
    private String name;
    private int offe;
    private TermNatures termNatures = null;
    private Term next;
    public double score = 0.0;
    public double selfScore = 1.0;
    private Term from;
    private Term to;
    private Nature nature;
    public boolean isFName;

    public Term(String name, int offe, TermNatures termNatures) {
        this.nature = TermNature.NULL.nature;
        this.isFName = false;
        this.name = name;
        this.offe = offe;
        this.termNatures = termNatures;
        if (termNatures == TermNatures.NR || termNatures == TermNatures.NULL || name.length() == 1) {
            this.isFName = ForeignPersonRecognition.isFName(this.name);
        }
    }

    public int getToValue() {
        return this.offe + this.name.length();
    }

    public int getOffe() {
        return this.offe;
    }

    public void setOffe(int offe) {
        this.offe = offe;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPathScore(Term from) {
        double score = MathUtil.compuScore(from, this);
        if (this.from == null || this.getScore() >= score) {
            this.setFromAndScore(from, score);
        }
    }

    public void setPathSelfScore(Term from) {
        double score = this.selfScore + from.getScore();
        if (this.from == null || this.getScore() > score) {
            this.setFromAndScore(from, score);
        }
    }

    private void setFromAndScore(Term from, double score) {
        this.from = from;
        this.score = score;
    }

    public Term merage(Term to) {
        this.name = this.name + to.getName();
        return this;
    }

    public void updateOffe(int offe) {
        this.offe += offe;
    }

    public Term getNext() {
        return this.next;
    }

    public Term setNext(Term next) {
        this.next = next;
        return this;
    }

    public double getScore() {
        return this.score;
    }

    public Term getFrom() {
        return this.from;
    }

    public Term getTo() {
        return this.to;
    }

    public void setFrom(Term from) {
        this.from = from;
    }

    public void setTo(Term to) {
        this.to = to;
    }

    public TermNatures getTermNatures() {
        return this.termNatures;
    }

    @Override
    public int compareTo(Term o) {
        if (this.score > o.score) {
            return 0;
        }
        return 1;
    }

    public void setNature(Nature nature) {
        this.nature = nature;
    }

    public Nature getNatrue() {
        return this.nature;
    }

    public String toString() {
        if (this.nature != null && !"null".equals(this.nature.natureStr)) {
            return this.name + "/" + this.nature.natureStr;
        }
        return this.name;
    }

    public void clearScore() {
        this.score = 0.0;
        this.selfScore = 0.0;
    }
}

