/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.domain;

import org.ansj.domain.TermNatures;

public class NewWord {
    private String name;
    private double score;
    private TermNatures nature;
    private int allFreq;
    private double averageScore;
    private boolean isActive = false;

    public NewWord(String name, TermNatures nature, double score, int freq) {
        this.name = name;
        this.nature = nature;
        this.score = this.getScore(nature, score);
        this.allFreq = freq;
        this.averageScore = score;
        if (this.allFreq > 2 || this.averageScore < -0.5) {
            this.isActive = true;
        }
    }

    private double getScore(TermNatures nature, double score) {
        if (TermNatures.NW.equals(nature)) {
            return score * -1.0;
        }
        if (TermNatures.NR.equals(nature)) {
            return score * 100.0;
        }
        if (TermNatures.NT.equals(nature)) {
            return score * 10.0;
        }
        return score;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getScore() {
        return this.score;
    }

    public TermNatures getNature() {
        return this.nature;
    }

    public void setNature(TermNatures nature) {
        this.nature = nature;
    }

    public void update(double score, TermNatures tn, int freq) {
        this.score += this.getScore(tn, score);
        this.allFreq += freq;
        this.averageScore = this.score / (double)freq;
        if (tn == null || !TermNatures.NW.equals(tn)) {
            this.nature = tn;
        }
        if (this.allFreq > 2 || this.averageScore < -0.5) {
            this.isActive = true;
        }
    }

    public String toString() {
        return this.name + "\t" + this.score + "\t" + this.getNature().termNatures[0];
    }

    public int getAllFreq() {
        return this.allFreq;
    }

    public double getAverageScore() {
        return this.averageScore;
    }
}

