/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.newWord;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.ansj.domain.Term;
import org.ansj.util.MathUtil;

public class PatHashMap {
    private HashMap<String, Node> hm = new HashMap();
    private int allFreq;

    public void addList(List<Term> terms) {
        int length = terms.size();
        if (length < 2) {
            return;
        }
        ArrayList<Term> all = null;
        for (int i = 0; i < length; ++i) {
            all = new ArrayList<Term>(length - i);
            for (int j = i; j < length; ++j) {
                all.add(terms.get(j));
                if (all.size() <= 1) continue;
                double leftRightEntropy = MathUtil.leftRightEntropy(all);
                ++this.allFreq;
                StringBuilder sb = new StringBuilder();
                for (Term term : all) {
                    sb.append(term.getName());
                }
                String name = sb.toString();
                Node node = this.hm.get(name);
                if (node == null) {
                    node = new Node(name);
                    node.score = leftRightEntropy;
                    node.freq = 1;
                    this.hm.put(name, node);
                    continue;
                }
                node.score += leftRightEntropy;
                node.freq += 1;
            }
        }
    }

    public Collection<Node> getWords() {
        Collection<Node> values = this.hm.values();
        return values;
    }

    private boolean filter(Node node, double validate) {
        return !((double)node.freq < validate) || !(node.score < 1.0);
    }

    class Node
    implements Comparable<Node> {
        private double score;
        private String name;
        private int freq;

        public Node(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return this.name.equals(((Node)obj).name);
        }

        @Override
        public int compareTo(Node o) {
            if (this.score < o.score) {
                return 1;
            }
            if (this.score > o.score) {
                return -1;
            }
            if (this.name.length() < o.name.length()) {
                return 1;
            }
            return -1;
        }

        public int getFreq() {
            return this.freq;
        }

        public double getScore() {
            return this.score;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name + ":" + this.score + ":" + this.freq;
        }
    }
}

