/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.newWord;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import love.cq.util.StringUtil;
import org.ansj.app.newWord.LearnTool;
import org.ansj.app.newWord.PatHashMap;
import org.ansj.dic.DicReader;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.splitWord.analysis.NlpAnalysis;
import org.ansj.util.Graph;

public class NewWordDetection {
    private static final HashSet<String> hs = new HashSet();

    public Collection<PatHashMap.Node> getNewWords(Graph graph) throws IOException {
        PatHashMap pt = this.makePatHash(graph);
        Collection<PatHashMap.Node> words = pt.getWords();
        return words;
    }

    private PatHashMap makePatHash(Graph graph) {
        PatHashMap pt = new PatHashMap();
        ArrayList<Term> tempList = new ArrayList<Term>();
        for (Term term : graph.terms) {
            if (term == null) continue;
            if (this.filter(term)) {
                tempList.add(term);
                continue;
            }
            if (tempList.size() > 1) {
                pt.addList(tempList);
            }
            if (tempList.size() <= 0) continue;
            if (tempList.size() < 10) {
                tempList.clear();
                continue;
            }
            tempList = new ArrayList();
        }
        return pt;
    }

    private boolean filter(Term term) {
        int length = term.getName().length();
        if (length > 1) {
            return false;
        }
        if (hs.contains(term.getName()) || term.getName().trim().length() == 0) {
            return false;
        }
        String natureStr = term.getNatrue().natureStr;
        return !(natureStr.contains("m") || "v".equals(natureStr) && term.getTermNatures().allFreq > 100 * length || "d".equals(natureStr) && term.getTermNatures().allFreq > 1000 || "z".equals(natureStr) || term.getTermNatures() == TermNatures.NB) && term.getTermNatures() != TermNatures.EN;
    }

    public static void main(String[] args) throws IOException {
        String content = "DOMDOM\u5206\u4e3aHTML DOM\u548cXML DOM\u4e24\u79cd\u3002\u5b83\u4eec\u5206\u522b\u5b9a\u4e49\u4e86\u8bbf\u95ee\u548c\u64cd\u4f5cHTML/XML\u6587\u6863\u7684\u6807\u51c6\u65b9\u6cd5\uff0c\u5e76\u5c06\u5bf9\u5e94\u7684\u6587\u6863\u5448\u73b0\u4e3a\u5e26\u6709\u5143\u7d20\u3001\u5c5e\u6027\u548c\u6587\u672c\u7684\u6811\u7ed3\u6784\uff08\u8282\u70b9\u6811\uff09 1\uff09DOM\u6811\u5b9a\u4e49\u4e86HTML/XML\u6587\u6863\u7684\u903b\u8f91\u7ed3\u6784\uff0c\u7ed9\u51fa\u4e86\u4e00\u79cd\u5e94\u7528\u7a0b\u5e8f\u8bbf\u95ee\u548c\u5904\u7406XML\u6587\u6863\u7684\u65b9\u6cd5\u3002 2\uff09\u5728DOM\u6811\u4e2d\uff0c\u6709\u4e00\u4e2a\u6839\u8282\u70b9\uff0c\u6240\u6709\u5176\u4ed6\u7684\u8282\u70b9\u90fd\u662f\u6839\u8282\u70b9\u7684\u540e\u4ee3\u3002 3) \u5728\u5e94\u7528\u8fc7\u7a0b\u4e2d\uff0c\u57fa\u4e8eDOM\u7684HTML/XML\u5206\u6790\u5668\u5c06\u4e00\u4e2aHTML/XML\u6587\u6863\u8f6c\u6362\u6210\u4e00\u68f5DOM\u6811\uff0c\u5e94\u7528\u7a0b\u5e8f\u901a\u8fc7\u5bf9DOM\u6811\u7684\u64cd\u4f5c\uff0c\u6765\u5b9e\u73b0\u5bf9HTML/XML\u6587\u6863\u6570\u636e\u7684\u64cd\u4f5c\u3002DOM= Document Object Model\uff0c\u6587\u6863\u5bf9\u8c61\u6a21\u578b\uff0cDOM\u53ef\u4ee5\u4ee5\u4e00\u79cd\u72ec\u7acb\u4e8e\u5e73\u53f0\u548c\u8bed\u8a00\u7684\u65b9\u5f0f\u8bbf\u95ee\u548c\u4fee\u6539\u4e00\u4e2a\u6587\u6863\u7684\u5185\u5bb9\u548c\u7ed3\u6784\u3002\u6362\u53e5\u8bdd\u8bf4\uff0c\u8fd9\u662f\u8868\u793a\u548c\u5904\u7406\u4e00\u4e2aHTML\u6216XML\u6587\u6863\u7684\u5e38\u7528\u65b9\u6cd5\u3002\u6709\u4e00\u70b9\u5f88\u91cd\u8981\uff0cDOM\u7684\u8bbe\u8ba1\u662f\u4ee5\u5bf9\u8c61\u7ba1\u7406\u7ec4\u7ec7\uff08OMG\uff09\u7684\u89c4\u7ea6\u4e3a\u57fa\u7840\u7684\uff0c\u56e0\u6b64\u53ef\u4ee5\u7528\u4e8e\u4efb\u4f55\u7f16\u7a0b\u8bed\u8a00.\u2022               D\uff1a\u6587\u6863 \u2013 html \u6587\u6863 \u6216 xml \u6587\u6863\u2022         O\uff1a\u5bf9\u8c61 \u2013 document \u5bf9\u8c61\u7684\u5c5e\u6027\u548c\u65b9\u6cd5\u2022         M\uff1a\u6a21\u578b\u2022               DOM \u662f\u9488\u5bf9xml(html)\u7684\u57fa\u4e8e\u6811\u7684API\u3002\u2022               DOM\u6811:\u8282\u70b9\uff08node\uff09\u7684\u5c42\u6b21\u3002\u2022               DOM \u628a\u4e00\u4e2a\u6587\u6863\u8868\u793a\u4e3a\u4e00\u68f5\u5bb6\u8c31\u6811\uff08\u7236\uff0c\u5b50\uff0c\u5144\u5f1f\uff09\u2022               DOM\u5b9a\u4e49\u4e86Node\u7684\u63a5\u53e3\u4ee5\u53ca\u8bb8\u591a\u79cd\u8282\u70b9\u7c7b\u578b\u6765\u8868\u793aXML\u8282\u70b9\u7684\u591a\u4e2a\u65b9\u9762DOM\u7684\u7ed3\u6784<html>:       <head>              <title>HTML DOM</title>       </head>       <body>       <h1>DOM\u7684\u7ed3\u6784</h1>       <p><a href=\u201dhref\u201d>\u94fe\u63a5</a></p></body></html>html\u662f\u6839\u8282\u70b9\uff0chead\uff0cbody\u662fhtml\u7684\u5b50\u8282\u70b9\uff0ctitle\u662fhead\u7684\u5b50\u8282\u70b9\uff0cbody\u662fh1\uff0cp\u7684\u7236\u8282\u70b9 \u8282\u70b9l       \u6839\u636e DOM\uff0cHTML \u6587\u6863\u4e2d\u7684\u6bcf\u4e2a\u6210\u5206\u90fd\u662f\u4e00\u4e2a\u8282\u70b9\u3002DOM \u662f\u8fd9\u6837\u89c4\u5b9a\u7684\uff1a\u2022         \u6574\u4e2a\u6587\u6863\u662f\u4e00\u4e2a\u6587\u6863\u8282\u70b9 \u2022         \u6bcf\u4e2a HTML \u6807\u7b7e\u662f\u4e00\u4e2a\u5143\u7d20\u8282\u70b9 \u2022         \u5305\u542b\u5728 HTML \u5143\u7d20\u4e2d\u7684\u6587\u672c\u662f\u6587\u672c\u8282\u70b9 \u2022         \u6bcf\u4e00\u4e2a HTML \u5c5e\u6027\u662f\u4e00\u4e2a\u5c5e\u6027\u8282\u70b9 \u2022         \u6ce8\u91ca\u5c5e\u4e8e\u6ce8\u91ca\u8282\u70b9 Node \u5c42\u6b21l       \u8282\u70b9\u5f7c\u6b64\u90fd\u6709\u7b49\u7ea7\u5173\u7cfb\u3002HTML \u6587\u6863\u4e2d\u7684\u6240\u6709\u8282\u70b9\u7ec4\u6210\u4e86\u4e00\u4e2a\u6587\u6863\u6811\uff08\u6216\u8282\u70b9\u6811\uff09\u3002HTML \u6587\u6863\u4e2d\u7684\u6bcf\u4e2a\u5143\u7d20\u3001\u5c5e\u6027\u3001\u6587\u672c\u7b49\u90fd\u4ee3\u8868\u7740\u6811\u4e2d\u7684\u4e00\u4e2a\u8282\u70b9\u3002\u6811\u8d77\u59cb\u4e8e\u6587\u6863\u8282\u70b9\uff0c\u5e76\u7531\u6b64\u7ee7\u7eed\u4f38\u51fa\u679d\u6761\uff0c\u76f4\u5230\u5904\u4e8e\u8fd9\u68f5\u6811\u6700\u4f4e\u7ea7\u522b\u7684\u6240\u6709\u6587\u672c\u8282\u70b9\u4e3a\u6b62\u3002\u8282\u70b9\u53ca\u5176\u7c7b\u578bl       \u8282\u70b9       \u7531\u7ed3\u6784\u56fe\u4e2d\u6211\u4eec\u53ef\u4ee5\u770b\u5230\uff0c\u6574\u4e2a\u6587\u6863\u5c31\u662f\u4e00\u4e2a\u6587\u6863\u8282\u70b9\u3002        \u800c\u6bcf\u4e00\u4e2aHMTL\u6807\u7b7e\u90fd\u662f\u4e00\u4e2a\u5143\u7d20\u8282\u70b9\u3002        \u6807\u7b7e\u4e2d\u7684\u6587\u5b57\u5219\u662f\u6587\u672c\u8282\u70b9\u3002        \u6807\u7b7e\u7684\u5c5e\u6027\u662f\u5c5e\u6027\u8282\u70b9\u3002        \u4e00\u5207\u90fd\u662f\u8282\u70b9\u2026\u2026l       \u8282\u70b9\u6811        \u8282\u70b9\u6811\u7684\u6982\u5ff5\u4ece\u56fe\u4e2d\u4e00\u76ee\u4e86\u7136\uff0c\u6700\u4e0a\u9762\u7684\u5c31\u662f\u201c\u6811\u6839\u201d\u4e86\u3002\u8282\u70b9\u4e4b\u95f4\u6709\u7236\u5b50\u5173\u7cfb\uff0c\u7956\u5148\u4e0e\u5b50\u5b59\u5173\u7cfb\uff0c\u5144\u59b9\u5173\u7cfb\u3002\u8fd9\u4e9b\u5173\u7cfb\u4ece\u56fe\u4e2d\u4e5f\u5f88\u597d\u770b\u51fa\u6765\uff0c\u76f4\u63a5\u8fde\u7ebf\u7684\u5c31\u662f\u7236\u5b50\u5173\u7cfb\u4e86\u3002\u800c\u6709\u4e00\u4e2a\u7236\u4eb2\u7684\u5c31\u662f\u5144\u59b9\u5173\u7cfb\u2026\u2026  NODE\u63a5\u53e3\u7684\u7279\u6027\u548c\u65b9\u6cd5        \u7279\u6027/\u65b9\u6cd5     \u7c7b\u578b/\u8fd4\u56de\u7c7b\u578b     \u8bf4    \u660e         nodeName     String     \u8282\u70b9\u7684\u540d\u5b57\uff1b\u6839\u636e\u8282\u70b9\u7684\u7c7b\u578b\u800c\u5b9a\u4e49         nodeValue     String     \u8282\u70b9\u7684\u503c\uff1b\u6839\u636e\u8282\u70b9\u7684\u7c7b\u578b\u800c\u5b9a\u4e49         nodeType     Number     \u8282\u70b9\u7684\u7c7b\u578b\u5e38\u91cf\u503c\u4e4b\u4e00         ownerDocument     Document     \u6307\u5411\u8fd9\u4e2a\u8282\u70b9\u6240\u5c5e\u7684\u6587\u6863         firstChild     Node     \u6307\u5411\u5728childNodes\u5217\u8868\u4e2d\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9         lastChild     Node     \u6307\u5411\u5728childNodes\u5217\u8868\u4e2d\u7684\u6700\u540e\u4e00\u4e2a\u8282\u70b9         childNodes     NodeList     \u6240\u6709\u5b50\u8282\u70b9\u7684\u5217\u8868         previousSibling     Node     \u6307\u5411\u524d\u4e00\u4e2a\u5144\u5f1f\u8282\u70b9\uff1b\u5982\u679c\u8fd9\u4e2a\u8282\u70b9\u5c31\u662f\u7b2c\u4e00\u4e2a\u5144 \u5f1f\u8282\u70b9\uff0c\u90a3\u4e48\u8be5\u503c\u4e3anull         nextSibling     Node     \u6307\u5411\u540e\u4e00\u4e2a\u5144\u5f1f\u8282\u70b9\uff1b\u5982\u679c\u8fd9\u4e2a\u8282\u70b9\u5c31\u662f\u6700\u540e\u4e00\u4e2a\u5144 \u5f1f\u8282\u70b9\uff0c\u90a3\u4e48\u8be5\u503c\u4e3anull         hasChildNodes()     Boolean     \u5f53childNodes\u5305\u542b\u4e00\u4e2a\u6216\u591a\u4e2a\u8282\u70b9\u65f6\uff0c\u8fd4\u56de\u771f         attributes     NamedNodeMap     \u5305\u542b\u4e86\u4ee3\u8868\u4e00\u4e2a\u5143\u7d20\u7684\u7279\u6027\u7684Attr\u5bf9\u8c61\uff1b\u4ec5\u7528\u4e8e Element\u8282\u70b9         appendChild(node)       Node     \u5c06node\u6dfb\u52a0\u5230childNodes\u7684\u672b\u5c3e         removeChild(node)     Node     \u4ecechildNodes\u4e2d\u5220\u9664node         replaceChild (newnode, oldnode)     Node     \u5c06childNodes\u4e2d\u7684oldnode\u66ff\u6362\u6210newnode         insertBefore (newnode, refnode)     Node     \u5728childNodes\u4e2d\u7684refnode\u4e4b\u524d\u63d2\u5165newnode        \u67e5\u627e\u5e76\u8bbf\u95ee\u8282\u70b9\u4f60\u53ef\u901a\u8fc7\u82e5\u5e72\u79cd\u65b9\u6cd5\u6765\u67e5\u627e\u60a8\u5e0c\u671b\u64cd\u4f5c\u7684\u5143\u7d20\uff1a\u901a\u8fc7\u4f7f\u7528 getElementById() \u548c getElementsByTagName() \u65b9\u6cd5 \u901a\u8fc7\u4f7f\u7528\u4e00\u4e2a\u5143\u7d20\u8282\u70b9\u7684 parentNode\u3001firstChild \u4ee5\u53ca lastChild \u5c5e\u6027 \u67e5\u627e\u5143\u7d20\u8282\u70b91\uff09getElementById() var element = document.getElementById ( ID )2\uff09getElementsByName()<input type='text' name='tname' value='\u56fd\u5e8660\u5e74_1' /><br><input type='text' name='tname' value='\u56fd\u5e8660\u5e74_2' /><br><input type='text' name='tname' value='\u56fd\u5e8660\u5e74_3' /><br> function test(){       var tnameArray=document.getElementsByName('tname');  alert(tnameArray.length);        for(var i=0;i<tnameArray.length;i++){               window.alert(tnameArray[i].value);            }         }3\uff09getElementsByTagName()var elements = document.getElementsByTagName(tagName);     var elements = element.getElementsByTagName(tagName);\u6216var container =   document.getElementById(\u201csid\u201d);   var elements = container.getElementsByTagName(\u201cp\u201d);   alert(elements .length);\u5904\u7406inputvar inputElements=document.getElementsByTagName('input');    //\u8f93\u51fainput\u6807\u7b7e\u7684\u957f\u5ea6alert(inputElements.length);       for(var i=0;i<inputElements.length;i++){      if(inputElements[i].type!='button'){alert(inputElements[i].value);}}\u5904\u7406select//\u83b7\u53d6select\u6807\u7b7evar selectElements=document.getElementsByTagName('select');     //\u83b7\u53d6select\u4e0b\u7684\u5b50\u6807\u7b7e  for(var j=0;j<selectElements.length;j++){       var optionElements=selectElements[j].getElementsByTagName('option');       for(var i=0;i<optionElements.length;i++){            alert(optionElements[i].value); } }\u4e00\u4e9b\u5e38\u7528\u7684\u8bbf\u95ee\u8282\u70b9\u7684\u5c5e\u6027\u53ca\u7528\u6cd5parentNode\uff1a\u7236\u8282\u70b9\u3001firstChil\uff1a\u7b2c\u4e00\u4e2a\u5b50\u8282\u70b9\u3001lastChild\u6700\u540e\u4e00\u4e2a\u5b50\u8282\u70b9hasChildNodes()   :\u8be5\u65b9\u6cd5\u7528\u6765\u68c0\u67e5\u4e00\u4e2a\u5143\u7d20\u662f\u5426\u6709\u5b50\u8282\u70b9\uff0c\u8fd4\u56de\u503c\u662f true \u6216 false.  var booleanValue = element.hasChildNodes();\u6587\u672c\u8282\u70b9\u548c\u5c5e\u6027\u8282\u70b9\u4e0d\u53ef\u80fd\u518d\u5305\u542b\u4efb\u4f55\u5b50\u8282\u70b9\uff0c\u6240\u4ee5\u5bf9\u8fd9\u4e24\u7c7b\u8282\u70b9\u4f7f\u7528 hasChildNodes \u65b9\u6cd5\u7684\u8fd4\u56de\u503c\u6c38\u8fdc\u662f false.\u5982\u679c hasChildNodes \u65b9\u6cd5\u7684\u8fd4\u56de\u503c\u662f false\uff0c\u5219 childNodes,firstChild,lastChild \u5c06\u662f\u7a7a\u6570\u7ec4\u548c\u7a7a\u5b57\u7b26\u4e32\u3002Document\u3002documentElement\uff1a\u8fd4\u56de\u5b58\u5728\u4e8e XML \u4ee5\u53ca HTML \u6587\u6863\u4e2d\u7684\u6587\u6863\u6839\u8282\u70b9document.body \uff1a\u662f\u5bf9 HTML \u9875\u9762\u7684\u7279\u6b8a\u6269\u5c55\uff0c\u63d0\u4f9b\u4e86\u5bf9 <body> \u6807\u7b7e\u7684\u76f4\u63a5\u8bbf\u95eenodeName\uff08\u8282\u70b9\u540d\u79f0\uff09 nodeValue\uff08\u8282\u70b9\u503c\uff09 nodeType\uff08\u8282\u70b9\u7c7b\u578b\uff09  \u6ce8\uff1anodeName \u6240\u5305\u542b\u7684 XML \u5143\u7d20\u7684\u6807\u7b7e\u540d\u79f0\u6c38\u8fdc\u662f\u5927\u5199\u7684nodeName \u662f\u4e00\u4e2a\u53ea\u8bfb\u5c5e\u6027\u3002 \u6848\u4f8b\uff1a\u83b7\u53d6\u8282\u70b9\u7684\u540d\u79f0\u53cavalue<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'><html>    <head>       <title>demo01.html</title>       <meta http-equiv='keywords' content='keyword1,keyword2,keyword3'>       <meta http-equiv='description' content='this is my page'>       <meta http-equiv='content-type' content='text/html; charset=UTF-8'>       <!--<link rel='stylesheet' type='text/css' href='./styles.css'>-->    </head>    <body>       <h1>           \u4f60\u597d\uff0ckouxiaolin       </h1>    </body></html><script type='text/javascript'><!--window.onload=function(){var root=document.documentElement;alert('\u8ddf\u6807\u7b7e\u7684\u540d\u79f0\uff1a'+root.nodeName); var ss=root.firstChild;alert('root\u7684\u7b2c\u4e00\u4e2a\u5b50\u6807\u7b7ehead\uff1a'+ss.nodeName); var ee=root.lastChild;alert('root\u7684\u6700\u540e\u4e00\u4e2a\u5b50\u6807\u7b7ebody\uff1a'+ee.nodeName); var body=document.body;alert('body\u6807\u7b7e\uff1a'+body.nodeName); var h1=body.firstChild;alert('body\u6807\u7b7e\u7684\u7b2c\u4e00\u4e2a\u5b50\u6807\u7b7eh1\uff1a'+h1.nodeName); var tt=h1.firstChild;alert('h1\u6807\u7b7e\u7684\u5b50\u6807\u7b7e\u540d\u79f0\uff1a'+tt.nodeName);alert('h1\u6807\u7b7e\u7684\u6587\u672c\u5185\u5bb9\uff1a'+tt.nodeValue);}//  -->  </script>\u904d\u5386select\u4e2d\u6240\u6709\u7684option\u5bf9\u8c61\u7684\u6587\u672c\u503c<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'><html>    <head>       <title>Demo02.html</title>       <meta http-equiv='keywords' content='keyword1,keyword2,keyword3'>       <meta http-equiv='description' content='this is my page'>       <meta http-equiv='content-type' content='text/html; charset=UTF-8'>       <!--<link rel='stylesheet' type='text/css' href='./styles.css'>-->       <script type='text/javascript'>window.onload = function() {    //\u901a\u8fc7getElementById('edu')\u65b9\u6cd5\u83b7\u53d6select\u7684\u5bf9\u8c61    var edus = document.getElementById('edu');    //\u901a\u8fc7select\u4e2doptions\u96c6\u5408\u83b7\u53d6\u6240\u6709\u7684option\u5bf9\u8c61    var edus1  =   edus.options;    var msg ='';    //\u904d\u5386\u6240\u6709\u7684option\u5bf9\u8c61\u7684\u6587\u672c\u503c      for(var i=0;i<edus1.length;i++){          msg+=edus1[i].innerHTML+',';      }     //\u628a\u83b7\u53d6\u7684msg\u4fe1\u606f\u5199\u5165\u5230showMsg\u7684div\u4e2d     document.getElementById('showMsg').innerHTML=msg;    }</script>    </head>    <body>    <div>       <form action=''>       \u7528\u6237\u540d:<input type='text' name='name' />       \u5b66\u5386:<select id='edu' name='education'>           <option value='\u5927\u4e13'>\u5927\u4e13\u751f</option>           <option value='\u672c\u79d1'>\u672c\u79d1\u751f</option>           <option value='\u7855\u58eb'>\u7855\u58eb\u751f</option>           <option value='\u535a\u58eb'>\u535a\u58eb\u751f</option>       </select>       <input type='submit' value='\u6ce8\u518c' />       </form>    </div>          \u7528\u6237\u7684\u5b66\u5386\u662f\uff1a   <div id='showMsg'>   </div>    </body></html>\u6216<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'><html>    <head>       <title>Demo02.html</title>       <meta http-equiv='keywords' content='keyword1,keyword2,keyword3'>       <meta http-equiv='description' content='this is my page'>       <meta http-equiv='content-type' content='text/html; charset=UTF-8'>       <!--<link rel='stylesheet' type='text/css' href='./styles.css'>-->       <script type='text/javascript'>window.onload = function() {    //\u901a\u8fc7getElementById('edu')\u65b9\u6cd5\u83b7\u53d6select\u7684\u5bf9\u8c61    var edus = document.getElementById('edu');    var edus1 = edus.childNodes;    alert(edus1.length);    var fc = edus.firstChild;    alert(fc.nodeName);    var lc = edus.lastChild;    alert(lc.nodeName);    var llc = lc.firstChild;    alert(llc.nodeValue);     var msg = '';    for ( var i = 0; i < edus1.length; i++) {       if (edus1[i].nodeType == 1)           msg += edus1[i].lastChild.nodeValue + ',';    }    document.getElementById('showMsg').innerHTML = msg;}</script>    </head>    <body>       <div>           <form action=''>              \u7528\u6237\u540d:              <input type='text' name='name' />              \u5b66\u5386:              <select id='edu' name='education'>                  <option value='\u5927\u4e13'>                     \u5927\u4e13\u751f                  </option>                  <option value='\u672c\u79d1'>                     \u672c\u79d1\u751f                  </option>                  <option value='\u7855\u58eb'>                     \u7855\u58eb\u751f                  </option>                  <option value='\u535a\u58eb'>                     \u535a\u58eb\u751f                  </option>              </select>              <input type='submit' value='\u6ce8\u518c' />           </form>       </div>       \u7528\u6237\u7684\u5b66\u5386\u662f\uff1a       <div id='showMsg'>       </div>    </body></html>  ' 6302859, 0, 23, '2011-3-16 20:42:00', ' \u53cd\u5c04\u7684\u6982\u5ff5\u662f\u7531Smith\u57281982\u5e74\u9996\u6b21\u63d0\u51fa\u7684\uff0c\u4e3b\u8981\u662f\u6307\u7a0b\u5e8f\u53ef\u4ee5\u8bbf\u95ee\u3001\u68c0\u6d4b\u548c\u4fee\u6539\u5b83\u672c\u8eab\u72b6\u6001\u6216\u884c\u4e3a\u7684\u4e00\u79cd\u80fd\u529b\u3002\u8fd9\u4e00\u6982\u5ff5\u7684\u63d0\u51fa\u5f88\u5feb\u5f15\u53d1\u4e86\u8ba1\u7b97\u673a\u79d1\u5b66\u9886\u57df\u5173\u4e8e\u5e94\u7528\u53cd\u5c04\u6027\u7684\u7814\u7a76\u3002\u5b83\u9996\u5148\u88ab\u7a0b\u5e8f\u8bed\u8a00\u7684\u8bbe\u8ba1\u9886\u57df\u6240\u91c7\u7528,\u5e76\u5728Lisp\u548c\u9762\u5411\u5bf9\u8c61\u65b9\u9762\u53d6\u5f97\u4e86\u6210\u7ee9\u3002\u5176\u4e2dLEAD/LEAD++ \u3001OpenC++ \u3001MetaXa\u548cOpenJava\u7b49\u5c31\u662f\u57fa\u4e8e\u53cd\u5c04\u673a\u5236\u7684\u8bed\u8a00\u3002\u6700\u8fd1\uff0c\u53cd\u5c04\u673a\u5236\u4e5f\u88ab\u5e94\u7528\u5230\u4e86\u89c6\u7a97\u7cfb\u7edf\u3001\u64cd\u4f5c\u7cfb\u7edf\u548c\u6587\u4ef6\u7cfb\u7edf\u4e2d\u3002 \u53cd\u5c04\u672c\u8eab\u5e76\u4e0d\u662f\u4e00\u4e2a\u65b0\u6982\u5ff5\uff0c\u5b83\u53ef\u80fd\u4f1a\u4f7f\u6211\u4eec\u8054\u60f3\u5230\u5149\u5b66\u4e2d\u7684\u53cd\u5c04\u6982\u5ff5\uff0c\u5c3d\u7ba1\u8ba1\u7b97\u673a\u79d1\u5b66\u8d4b\u4e88\u4e86\u53cd\u5c04\u6982\u5ff5\u65b0\u7684\u542b\u4e49\uff0c\u4f46\u662f\uff0c\u4ece\u73b0\u8c61\u4e0a\u6765\u8bf4\uff0c\u5b83\u4eec\u786e\u5b9e\u6709\u67d0\u4e9b\u76f8\u901a\u4e4b\u5904\uff0c\u8fd9\u4e9b\u6709\u52a9\u4e8e\u6211\u4eec\u7684\u7406\u89e3\u3002\u5728\u8ba1\u7b97\u673a\u79d1\u5b66\u9886\u57df\uff0c\u53cd\u5c04\u662f\u6307\u4e00\u7c7b\u5e94\u7528\uff0c\u5b83\u4eec\u80fd\u591f\u81ea\u63cf\u8ff0\u548c\u81ea\u63a7\u5236\u3002\u4e5f\u5c31\u662f\u8bf4\uff0c\u8fd9\u7c7b\u5e94\u7528\u901a\u8fc7\u91c7\u7528\u67d0\u79cd\u673a\u5236\u6765\u5b9e\u73b0\u5bf9\u81ea\u5df1\u884c\u4e3a\u7684\u63cf\u8ff0\uff08self-representation\uff09\u548c\u76d1\u6d4b\uff08examination\uff09\uff0c\u5e76\u80fd\u6839\u636e\u81ea\u8eab\u884c\u4e3a\u7684\u72b6\u6001\u548c\u7ed3\u679c\uff0c\u8c03\u6574\u6216\u4fee\u6539\u5e94\u7528\u6240\u63cf\u8ff0\u884c\u4e3a\u7684\u72b6\u6001\u548c\u76f8\u5173\u7684\u8bed\u4e49\u3002\u53ef\u4ee5\u770b\u51fa\uff0c\u540c\u4e00\u822c\u7684\u53cd\u5c04\u6982\u5ff5\u76f8\u6bd4\uff0c\u8ba1\u7b97\u673a\u79d1\u5b66\u9886\u57df\u7684\u53cd\u5c04\u4e0d\u5355\u5355\u6307\u53cd\u5c04\u672c\u8eab\uff0c\u8fd8\u5305\u62ec\u5bf9\u53cd\u5c04\u7ed3\u679c\u6240\u91c7\u53d6\u7684\u63aa\u65bd\u3002\u6240\u6709\u91c7\u7528\u53cd\u5c04\u673a\u5236\u7684\u7cfb\u7edf\uff08\u5373\u53cd\u5c04\u7cfb\u7edf\uff09\u90fd\u5e0c\u671b\u4f7f\u7cfb\u7edf\u7684\u5b9e\u73b0\u66f4\u5f00\u653e\u3002\u53ef\u4ee5\u8bf4\uff0c\u5b9e\u73b0\u4e86\u53cd\u5c04\u673a\u5236\u7684\u7cfb\u7edf\u90fd\u5177\u6709\u5f00\u653e\u6027\uff0c\u4f46\u5177\u6709\u5f00\u653e\u6027\u7684\u7cfb\u7edf\u5e76\u4e0d\u4e00\u5b9a\u91c7\u7528\u4e86\u53cd\u5c04\u673a\u5236\uff0c\u5f00\u653e\u6027\u662f\u53cd\u5c04\u7cfb\u7edf\u7684\u5fc5\u8981\u6761\u4ef6\u3002\u4e00\u822c\u6765\u8bf4\uff0c\u53cd\u5c04\u7cfb\u7edf\u9664\u4e86\u6ee1\u8db3\u5f00\u653e\u6027\u6761\u4ef6\u5916\u8fd8\u5fc5\u987b\u6ee1\u8db3\u539f\u56e0\u8fde\u63a5\uff08Causally-connected\uff09\u3002\u6240\u8c13\u539f\u56e0\u8fde\u63a5\u662f\u6307\u5bf9\u53cd\u5c04\u7cfb\u7edf\u81ea\u63cf\u8ff0\u7684\u6539\u53d8\u80fd\u591f\u7acb\u5373\u53cd\u6620\u5230\u7cfb\u7edf\u5e95\u5c42\u7684\u5b9e\u9645\u72b6\u6001\u548c\u884c\u4e3a\u4e0a\u7684\u60c5\u51b5\uff0c\u53cd\u4e4b\u4ea6\u7136\u3002\u5f00\u653e\u6027\u548c\u539f\u56e0\u8fde\u63a5\u662f\u53cd\u5c04\u7cfb\u7edf\u7684\u4e24\u5927\u57fa\u672c\u8981\u7d20\u3002 Java\u4e2d\uff0c\u53cd\u5c04\u662f\u4e00\u79cd\u5f3a\u5927\u7684\u5de5\u5177\u3002\u5b83\u4f7f\u60a8\u80fd\u591f\u521b\u5efa\u7075\u6d3b\u7684\u4ee3\u7801\uff0c\u8fd9\u4e9b\u4ee3\u7801\u53ef\u4ee5\u5728\u8fd0\u884c\u65f6\u88c5\u914d\uff0c\u65e0\u9700\u5728\u7ec4\u4ef6\u4e4b\u95f4\u8fdb\u884c\u6e90\u4ee3\u8868\u94fe\u63a5\u3002\u53cd\u5c04\u5141\u8bb8\u6211\u4eec\u5728\u7f16\u5199\u4e0e\u6267\u884c\u65f6\uff0c\u4f7f\u6211\u4eec\u7684\u7a0b\u5e8f\u4ee3\u7801\u80fd\u591f\u63a5\u5165\u88c5\u8f7d\u5230JVM\u4e2d\u7684\u7c7b\u7684\u5185\u90e8\u4fe1\u606f\uff0c\u800c\u4e0d\u662f\u6e90\u4ee3\u7801\u4e2d\u9009\u5b9a\u7684\u7c7b\u534f\u4f5c\u7684\u4ee3\u7801\u3002\u8fd9\u4f7f\u53cd\u5c04\u6210\u4e3a\u6784\u5efa\u7075\u6d3b\u7684\u5e94\u7528\u7684\u4e3b\u8981\u5de5\u5177\u3002\u4f46\u9700\u6ce8\u610f\u7684\u662f\uff1a\u5982\u679c\u4f7f\u7528\u4e0d\u5f53\uff0c\u53cd\u5c04\u7684\u6210\u672c\u5f88\u9ad8\u3002 \u4e8c\u3001Java\u4e2d\u7684\u7c7b\u53cd\u5c04\uff1a Reflection \u662f Java \u7a0b\u5e8f\u5f00\u53d1\u8bed\u8a00\u7684\u7279\u5f81\u4e4b\u4e00\uff0c\u5b83\u5141\u8bb8\u8fd0\u884c\u4e2d\u7684 Java \u7a0b\u5e8f\u5bf9\u81ea\u8eab\u8fdb\u884c\u68c0\u67e5\uff0c\u6216\u8005\u8bf4\u201c\u81ea\u5ba1\u201d\uff0c\u5e76\u80fd\u76f4\u63a5\u64cd\u4f5c\u7a0b\u5e8f\u7684\u5185\u90e8\u5c5e\u6027\u3002Java \u7684\u8fd9\u4e00\u80fd\u529b\u5728\u5b9e\u9645\u5e94\u7528\u4e2d\u4e5f\u8bb8\u7528\u5f97\u4e0d\u662f\u5f88\u591a\uff0c\u4f46\u662f\u5728\u5176\u5b83\u7684\u7a0b\u5e8f\u8bbe\u8ba1\u8bed\u8a00\u4e2d\u6839\u672c\u5c31\u4e0d\u5b58\u5728\u8fd9\u4e00\u7279\u6027\u3002\u4f8b\u5982\uff0cPascal\u3001C \u6216\u8005 C++ \u4e2d\u5c31\u6ca1\u6709\u529e\u6cd5\u5728\u7a0b\u5e8f\u4e2d\u83b7\u5f97\u51fd\u6570\u5b9a\u4e49\u76f8\u5173\u7684\u4fe1\u606f\u3002 1\uff0e\u68c0\u6d4b\u7c7b\uff1a 1.1 reflection\u7684\u5de5\u4f5c\u673a\u5236 \u8003\u8651\u4e0b\u9762\u8fd9\u4e2a\u7b80\u5355\u7684\u4f8b\u5b50\uff0c\u8ba9\u6211\u4eec\u770b\u770b reflection \u662f\u5982\u4f55\u5de5\u4f5c\u7684\u3002 import java.lang.reflect.*; public class DumpMethods { public static void main(String args[]) { try { Class c = Class.forName(args[0]); Method m[] = c.getDeclaredMethods(); for (int i = 0; i < m.length; i++) System.out.println(m[i].toString()); } catch (Throwable e) { System.err.println(e); } } } \u6309\u5982\u4e0b\u8bed\u53e5\u6267\u884c\uff1a java DumpMethods java.util.Stack \u5b83\u7684\u7ed3\u679c\u8f93\u51fa\u4e3a\uff1a public java.lang.Object java.util.Stack.push(java.lang.Object) public synchronized java.lang.Object java.util.Stack.pop() public synchronized java.lang.Object java.util.Stack.peek() public boolean java.util.Stack.empty() public synchronized int java.util.Stack.search(java.lang.Object) \u8fd9\u6837\u5c31\u5217\u51fa\u4e86java.util.Stack \u7c7b\u7684\u5404\u65b9\u6cd5\u540d\u4ee5\u53ca\u5b83\u4eec\u7684\u9650\u5236\u7b26\u548c\u8fd4\u56de\u7c7b\u578b\u3002 \u8fd9\u4e2a\u7a0b\u5e8f\u4f7f\u7528 Class.forName \u8f7d\u5165\u6307\u5b9a\u7684\u7c7b\uff0c\u7136\u540e\u8c03\u7528 getDeclaredMethods \u6765\u83b7\u53d6\u8fd9\u4e2a\u7c7b\u4e2d\u5b9a\u4e49\u4e86\u7684\u65b9\u6cd5\u5217\u8868\u3002java.lang.reflect.Methods \u662f\u7528\u6765\u63cf\u8ff0\u67d0\u4e2a\u7c7b\u4e2d\u5355\u4e2a\u65b9\u6cd5\u7684\u4e00\u4e2a\u7c7b\u3002 1.2 Java\u7c7b\u53cd\u5c04\u4e2d\u7684\u4e3b\u8981\u65b9\u6cd5 \u5bf9\u4e8e\u4ee5\u4e0b\u4e09\u7c7b\u7ec4\u4ef6\u4e2d\u7684\u4efb\u4f55\u4e00\u7c7b\u6765\u8bf4 -- \u6784\u9020\u51fd\u6570\u3001\u5b57\u6bb5\u548c\u65b9\u6cd5 -- java.lang.Class \u63d0\u4f9b\u56db\u79cd\u72ec\u7acb\u7684\u53cd\u5c04\u8c03\u7528\uff0c\u4ee5\u4e0d\u540c\u7684\u65b9\u5f0f\u6765\u83b7\u5f97\u4fe1\u606f\u3002\u8c03\u7528\u90fd\u9075\u5faa\u4e00\u79cd\u6807\u51c6\u683c\u5f0f\u3002\u4ee5\u4e0b\u662f\u7528\u4e8e\u67e5\u627e\u6784\u9020\u51fd\u6570\u7684\u4e00\u7ec4\u53cd\u5c04\u8c03\u7528\uff1a l Constructor getConstructor(Class[] params) -- \u83b7\u5f97\u4f7f\u7528\u7279\u6b8a\u7684\u53c2\u6570\u7c7b\u578b\u7684\u516c\u5171\u6784\u9020\u51fd\u6570\uff0c l Constructor[] getConstructors() -- \u83b7\u5f97\u7c7b\u7684\u6240\u6709\u516c\u5171\u6784\u9020\u51fd\u6570 l Constructor getDeclaredConstructor(Class[] params) -- \u83b7\u5f97\u4f7f\u7528\u7279\u5b9a\u53c2\u6570\u7c7b\u578b\u7684\u6784\u9020\u51fd\u6570(\u4e0e\u63a5\u5165\u7ea7\u522b\u65e0\u5173) l Constructor[] getDeclaredConstructors() -- \u83b7\u5f97\u7c7b\u7684\u6240\u6709\u6784\u9020\u51fd\u6570(\u4e0e\u63a5\u5165\u7ea7\u522b\u65e0\u5173) \u83b7\u5f97\u5b57\u6bb5\u4fe1\u606f\u7684Class \u53cd\u5c04\u8c03\u7528\u4e0d\u540c\u4e8e\u90a3\u4e9b\u7528\u4e8e\u63a5\u5165\u6784\u9020\u51fd\u6570\u7684\u8c03\u7528\uff0c\u5728\u53c2\u6570\u7c7b\u578b\u6570\u7ec4\u4e2d\u4f7f\u7528\u4e86\u5b57\u6bb5\u540d\uff1a l Field getField(String name) -- \u83b7\u5f97\u547d\u540d\u7684\u516c\u5171\u5b57\u6bb5 l Field[] getFields() -- \u83b7\u5f97\u7c7b\u7684\u6240\u6709\u516c\u5171\u5b57\u6bb5 l Field getDeclaredField(String name) -- \u83b7\u5f97\u7c7b\u58f0\u660e\u7684\u547d\u540d\u7684\u5b57\u6bb5 l Field[] getDeclaredFields() -- \u83b7\u5f97\u7c7b\u58f0\u660e\u7684\u6240\u6709\u5b57\u6bb5 \u7528\u4e8e\u83b7\u5f97\u65b9\u6cd5\u4fe1\u606f\u51fd\u6570\uff1a l Method getMethod(String name, Class[] params) -- \u4f7f\u7528\u7279\u5b9a\u7684\u53c2\u6570\u7c7b\u578b\uff0c\u83b7\u5f97\u547d\u540d\u7684\u516c\u5171\u65b9\u6cd5 l Method[] getMethods() -- \u83b7\u5f97\u7c7b\u7684\u6240\u6709\u516c\u5171\u65b9\u6cd5 l Method getDeclaredMethod(String name, Class[] params) -- \u4f7f\u7528\u7279\u5199\u7684\u53c2\u6570\u7c7b\u578b\uff0c\u83b7\u5f97\u7c7b\u58f0\u660e\u7684\u547d\u540d\u7684\u65b9\u6cd5 l Method[] getDeclaredMethods() -- \u83b7\u5f97\u7c7b\u58f0\u660e\u7684\u6240\u6709\u65b9\u6cd5 1.3\u5f00\u59cb\u4f7f\u7528 Reflection\uff1a \u7528\u4e8e reflection \u7684\u7c7b\uff0c\u5982 Method\uff0c\u53ef\u4ee5\u5728 java.lang.relfect \u5305\u4e2d\u627e\u5230\u3002\u4f7f\u7528\u8fd9\u4e9b\u7c7b\u7684\u65f6\u5019\u5fc5\u987b\u8981\u9075\u5faa\u4e09\u4e2a\u6b65\u9aa4\uff1a\u7b2c\u4e00\u6b65\u662f\u83b7\u5f97\u4f60\u60f3\u64cd\u4f5c\u7684\u7c7b\u7684 java.lang.Class \u5bf9\u8c61\u3002\u5728\u8fd0\u884c\u4e2d\u7684 Java \u7a0b\u5e8f\u4e2d\uff0c\u7528 java.lang.Class \u7c7b\u6765\u63cf\u8ff0\u7c7b\u548c\u63a5\u53e3\u7b49\u3002 \u4e0b\u9762\u5c31\u662f\u83b7\u5f97\u4e00\u4e2a Class \u5bf9\u8c61\u7684\u65b9\u6cd5\u4e4b\u4e00\uff1a Class c = Class.forName('java.lang.String'); \u8fd9\u6761\u8bed\u53e5\u5f97\u5230\u4e00\u4e2a String \u7c7b\u7684\u7c7b\u5bf9\u8c61\u3002\u8fd8\u6709\u53e6\u4e00\u79cd\u65b9\u6cd5\uff0c\u5982\u4e0b\u9762\u7684\u8bed\u53e5\uff1a Class c = int.class; \u6216\u8005 Class c = Integer.TYPE; \u5b83\u4eec\u53ef\u83b7\u5f97\u57fa\u672c\u7c7b\u578b\u7684\u7c7b\u4fe1\u606f\u3002\u5176\u4e2d\u540e\u4e00\u79cd\u65b9\u6cd5\u4e2d\u8bbf\u95ee\u7684\u662f\u57fa\u672c\u7c7b\u578b\u7684\u5c01\u88c5\u7c7b (\u5982 Integer) \u4e2d\u9884\u5148\u5b9a\u4e49\u597d\u7684 TYPE \u5b57\u6bb5\u3002 \u7b2c\u4e8c\u6b65\u662f\u8c03\u7528\u8bf8\u5982 getDeclaredMethods \u7684\u65b9\u6cd5\uff0c\u4ee5\u53d6\u5f97\u8be5\u7c7b\u4e2d\u5b9a\u4e49\u7684\u6240\u6709\u65b9\u6cd5\u7684\u5217\u8868\u3002 \u4e00\u65e6\u53d6\u5f97\u8fd9\u4e2a\u4fe1\u606f\uff0c\u5c31\u53ef\u4ee5\u8fdb\u884c\u7b2c\u4e09\u6b65\u4e86\u2014\u2014\u4f7f\u7528 reflection API \u6765\u64cd\u4f5c\u8fd9\u4e9b\u4fe1\u606f\uff0c\u5982\u4e0b\u9762\u8fd9\u6bb5\u4ee3\u7801\uff1a Class c = Class.forName('java.lang.String'); Method m[] = c.getDeclaredMethods(); System.out.println(m[0].toString()); \u5b83\u5c06\u4ee5\u6587\u672c\u65b9\u5f0f\u6253\u5370\u51fa String \u4e2d\u5b9a\u4e49\u7684\u7b2c\u4e00\u4e2a\u65b9\u6cd5\u7684\u539f\u578b\u3002 2\uff0e\u5904\u7406\u5bf9\u8c61\uff1a \u5982\u679c\u8981\u4f5c\u4e00\u4e2a\u5f00\u53d1\u5de5\u5177\u50cfdebugger\u4e4b\u7c7b\u7684\uff0c\u4f60\u5fc5\u987b\u80fd\u53d1\u73b0filed values,\u4ee5\u4e0b\u662f\u4e09\u4e2a\u6b65\u9aa4: a.\u521b\u5efa\u4e00\u4e2aClass\u5bf9\u8c61 b.\u901a\u8fc7getField \u521b\u5efa\u4e00\u4e2aField\u5bf9\u8c61 c.\u8c03\u7528Field.getXXX(Object)\u65b9\u6cd5(XXX\u662fInt,Float\u7b49\uff0c\u5982\u679c\u662f\u5bf9\u8c61\u5c31\u7701\u7565\uff1bObject\u662f\u6307\u5b9e\u4f8b). \u4f8b\u5982\uff1a import java.lang.reflect.*; import java.awt.*; class SampleGet { public static void main(String[] args) { Rectangle r = new Rectangle(100, 325); printHeight(r); } static void printHeight(Rectangle r) { Field heightField; Integer heightValue; Class c = r.getClass(); try { heightField = c.getField('height'); heightValue = (Integer) heightField.get(r); System.out.println('Height: ' + heightValue.toString()); } catch (NoSuchFieldException e) { System.out.println(e); } catch (SecurityException e) { System.out.println(e); } catch (IllegalAccessException e) { System.out.println(e); } } } \u4e09\u3001\u5b89\u5168\u6027\u548c\u53cd\u5c04\uff1a \u5728\u5904\u7406\u53cd\u5c04\u65f6\u5b89\u5168\u6027\u662f\u4e00\u4e2a\u8f83\u590d\u6742\u7684\u95ee\u9898\u3002\u53cd\u5c04\u7ecf\u5e38\u7531\u6846\u67b6\u578b\u4ee3\u7801\u4f7f\u7528\uff0c\u7531\u4e8e\u8fd9\u4e00\u70b9\uff0c\u6211\u4eec\u53ef\u80fd\u5e0c\u671b\u6846\u67b6\u80fd\u591f\u5168\u9762\u63a5\u5165\u4ee3\u7801\uff0c\u65e0\u9700\u8003\u8651\u5e38\u89c4\u7684\u63a5\u5165\u9650\u5236\u3002\u4f46\u662f\uff0c\u5728\u5176\u5b83\u60c5\u51b5\u4e0b\uff0c\u4e0d\u53d7\u63a7\u5236\u7684\u63a5\u5165\u4f1a\u5e26\u6765\u4e25\u91cd\u7684\u5b89\u5168\u6027\u98ce\u9669\uff0c\u4f8b\u5982\u5f53\u4ee3\u7801\u5728\u4e0d\u503c\u5f97\u4fe1\u4efb\u7684\u4ee3\u7801\u5171\u4eab\u7684\u73af\u5883\u4e2d\u8fd0\u884c\u65f6\u3002 \u7531\u4e8e\u8fd9\u4e9b\u4e92\u76f8\u77db\u76fe\u7684\u9700\u6c42\uff0cJava\u7f16\u7a0b\u8bed\u8a00\u5b9a\u4e49\u4e00\u79cd\u591a\u7ea7\u522b\u65b9\u6cd5\u6765\u5904\u7406\u53cd\u5c04\u7684\u5b89\u5168\u6027\u3002\u57fa\u672c\u6a21\u5f0f\u662f\u5bf9\u53cd\u5c04\u5b9e\u65bd\u4e0e\u5e94\u7528\u4e8e\u6e90\u4ee3\u7801\u63a5\u5165\u76f8\u540c\u7684\u9650\u5236\uff1a n \u4ece\u4efb\u610f\u4f4d\u7f6e\u5230\u7c7b\u516c\u5171\u7ec4\u4ef6\u7684\u63a5\u5165 n \u7c7b\u81ea\u8eab\u5916\u90e8\u65e0\u4efb\u4f55\u5230\u79c1\u6709\u7ec4\u4ef6\u7684\u63a5\u5165 n \u53d7\u4fdd\u62a4\u548c\u6253\u5305\uff08\u7f3a\u7701\u63a5\u5165\uff09\u7ec4\u4ef6\u7684\u6709\u9650\u63a5\u5165 \u4e0d\u8fc7\u81f3\u5c11\u6709\u4e9b\u65f6\u5019\uff0c\u56f4\u7ed5\u8fd9\u4e9b\u9650\u5236\u8fd8\u6709\u4e00\u79cd\u7b80\u5355\u7684\u65b9\u6cd5\u3002\u6211\u4eec\u53ef\u4ee5\u5728\u6211\u4eec\u6240\u5199\u7684\u7c7b\u4e2d\uff0c\u6269\u5c55\u4e00\u4e2a\u666e\u901a\u7684\u57fa\u672c\u7c7bjava.lang.reflect.AccessibleObject \u7c7b\u3002\u8fd9\u4e2a\u7c7b\u5b9a\u4e49\u4e86\u4e00\u79cdsetAccessible\u65b9\u6cd5\uff0c\u4f7f\u6211\u4eec\u80fd\u591f\u542f\u52a8\u6216\u5173\u95ed\u5bf9\u8fd9\u4e9b\u7c7b\u4e2d\u5176\u4e2d\u4e00\u4e2a\u7c7b\u7684\u5b9e\u4f8b\u7684\u63a5\u5165\u68c0\u6d4b\u3002\u552f\u4e00\u7684\u95ee\u9898\u5728\u4e8e\u5982\u679c\u4f7f\u7528\u4e86\u5b89\u5168\u6027\u7ba1\u7406\u5668\uff0c\u5b83\u5c06\u68c0\u6d4b\u6b63\u5728\u5173\u95ed\u63a5\u5165\u68c0\u6d4b\u7684\u4ee3\u7801\u662f\u5426\u8bb8\u53ef\u4e86\u8fd9\u6837\u505a\u3002\u5982\u679c\u672a\u8bb8\u53ef\uff0c\u5b89\u5168\u6027\u7ba1\u7406\u5668\u629b\u51fa\u4e00\u4e2a\u4f8b\u5916\u3002 \u4e0b\u9762\u662f\u4e00\u6bb5\u7a0b\u5e8f\uff0c\u5728TwoString \u7c7b\u7684\u4e00\u4e2a\u5b9e\u4f8b\u4e0a\u4f7f\u7528\u53cd\u5c04\u6765\u663e\u793a\u5b89\u5168\u6027\u6b63\u5728\u8fd0\u884c\uff1a public class ReflectSecurity { public static void main(String[] args) { try { TwoString ts = new TwoString('a', 'b'); Field field = clas.getDeclaredField('m_s1'); // field.setAccessible(true); System.out.println('Retrieved value is ' + field.get(inst)); } catch (Exception ex) { ex.printStackTrace(System.out); } } } \u5982\u679c\u6211\u4eec\u7f16\u8bd1\u8fd9\u4e00\u7a0b\u5e8f\u65f6\uff0c\u4e0d\u4f7f\u7528\u4efb\u4f55\u7279\u5b9a\u53c2\u6570\u76f4\u63a5\u4ece\u547d\u4ee4\u884c\u8fd0\u884c\uff0c\u5b83\u5c06\u5728field .get(inst)\u8c03\u7528\u4e2d\u629b\u51fa\u4e00\u4e2aIllegalAccessException\u5f02\u5e38\u3002\u5982\u679c\u6211\u4eec\u4e0d\u6ce8\u91cafield.setAccessible(true)\u4ee3\u7801\u884c\uff0c\u90a3\u4e48\u91cd\u65b0\u7f16\u8bd1\u5e76\u91cd\u65b0\u8fd0\u884c\u8be5\u4ee3\u7801\uff0c\u5b83\u5c06\u7f16\u8bd1\u6210\u529f\u3002\u6700\u540e\uff0c\u5982\u679c\u6211\u4eec\u5728\u547d\u4ee4\u884c\u6dfb\u52a0\u4e86JVM\u53c2\u6570-Djava.security.manager\u4ee5\u5b9e\u73b0\u5b89\u5168\u6027\u7ba1\u7406\u5668\uff0c\u5b83\u4ecd\u7136\u5c06\u4e0d\u80fd\u901a\u8fc7\u7f16\u8bd1\uff0c\u9664\u975e\u6211\u4eec\u5b9a\u4e49\u4e86ReflectSecurity\u7c7b\u7684\u8bb8\u53ef\u6743\u9650\u3002 \u56db\u3001\u53cd\u5c04\u6027\u80fd\uff1a \u53cd\u5c04\u662f\u4e00\u79cd\u5f3a\u5927\u7684\u5de5\u5177\uff0c\u4f46\u4e5f\u5b58\u5728\u4e00\u4e9b\u4e0d\u8db3\u3002\u4e00\u4e2a\u4e3b\u8981\u7684\u7f3a\u70b9\u662f\u5bf9\u6027\u80fd\u6709\u5f71\u54cd\u3002\u4f7f\u7528\u53cd\u5c04\u57fa\u672c\u4e0a\u662f\u4e00\u79cd\u89e3\u91ca\u64cd\u4f5c\uff0c\u6211\u4eec\u53ef\u4ee5\u544a\u8bc9JVM\uff0c\u6211\u4eec\u5e0c\u671b\u505a\u4ec0\u4e48\u5e76\u4e14\u5b83\u6ee1\u8db3\u6211\u4eec\u7684\u8981\u6c42\u3002\u8fd9\u7c7b\u64cd\u4f5c\u603b\u662f\u6162\u4e8e\u53ea\u76f4\u63a5\u6267\u884c\u76f8\u540c\u7684\u64cd\u4f5c\u3002 \u4e0b\u9762\u7684\u7a0b\u5e8f\u662f\u5b57\u6bb5\u63a5\u5165\u6027\u80fd\u6d4b\u8bd5\u7684\u4e00\u4e2a\u4f8b\u5b50\uff0c\u5305\u62ec\u57fa\u672c\u7684\u6d4b\u8bd5\u65b9\u6cd5\u3002\u6bcf\u79cd\u65b9\u6cd5\u6d4b\u8bd5\u5b57\u6bb5\u63a5\u5165\u7684\u4e00\u79cd\u5f62\u5f0f -- accessSame \u4e0e\u540c\u4e00\u5bf9\u8c61\u7684\u6210\u5458\u5b57\u6bb5\u534f\u4f5c\uff0caccessOther \u4f7f\u7528\u53ef\u76f4\u63a5\u63a5\u5165\u7684\u53e6\u4e00\u5bf9\u8c61\u7684\u5b57\u6bb5\uff0caccessReflection \u4f7f\u7528\u53ef\u901a\u8fc7\u53cd\u5c04\u63a5\u5165\u7684\u53e6\u4e00\u5bf9\u8c61\u7684\u5b57\u6bb5\u3002\u5728\u6bcf\u79cd\u60c5\u51b5\u4e0b\uff0c\u65b9\u6cd5\u6267\u884c\u76f8\u540c\u7684\u8ba1\u7b97 -- \u5faa\u73af\u4e2d\u7b80\u5355\u7684\u52a0/\u4e58\u987a\u5e8f\u3002 \u7a0b\u5e8f\u5982\u4e0b\uff1a public int accessSame(int loops) { m_value = 0; for (int index = 0; index < loops; index++) { m_value = (m_value + ADDITIVE_VALUE) * MULTIPLIER_VALUE; } return m_value; } public int accessReference(int loops) { TimingClass timing = new TimingClass(); for (int index = 0; index < loops; index++) { timing.m_value = (timing.m_value + ADDITIVE_VALUE) * MULTIPLIER_VALUE; } return timing.m_value; } public int accessReflection(int loops) throws Exception { TimingClass timing = new TimingClass(); try { Field field = TimingClass.class. getDeclaredField('m_value'); for (int index = 0; index < loops; index++) { int value = (field.getInt(timing) + ADDITIVE_VALUE) * MULTIPLIER_VALUE; field.setInt(timing, value); } return timing.m_value; } catch (Exception ex) { System.out.println('Error using reflection'); throw ex; } } \u5728\u4e0a\u9762\u7684\u4f8b\u5b50\u4e2d\uff0c\u6d4b\u8bd5\u7a0b\u5e8f\u91cd\u590d\u8c03\u7528\u6bcf\u79cd\u65b9\u6cd5\uff0c\u4f7f\u7528\u4e00\u4e2a\u5927\u5faa\u73af\u6570\uff0c\u4ece\u800c\u5e73\u5747\u591a\u6b21\u8c03\u7528\u7684\u65f6\u95f4\u8861\u91cf\u7ed3\u679c\u3002\u5e73\u5747\u503c\u4e2d\u4e0d\u5305\u62ec\u6bcf\u79cd\u65b9\u6cd5\u7b2c\u4e00\u6b21\u8c03\u7528\u7684\u65f6\u95f4\uff0c\u56e0\u6b64\u521d\u59cb\u5316\u65f6\u95f4\u4e0d\u662f\u7ed3\u679c\u4e2d\u7684\u4e00\u4e2a\u56e0\u7d20\u3002\u4e0b\u9762\u7684\u56fe\u6e05\u695a\u7684\u5411\u6211\u4eec\u5c55\u793a\u4e86\u6bcf\u79cd\u65b9\u6cd5\u5b57\u6bb5\u63a5\u5165\u7684\u65f6\u95f4\uff1a \u56fe 1\uff1a\u5b57\u6bb5\u63a5\u5165\u65f6\u95f4 \uff1a \u6211\u4eec\u53ef\u4ee5\u770b\u51fa\uff1a\u5728\u524d\u4e24\u526f\u56fe\u4e2d(Sun JVM)\uff0c\u4f7f\u7528\u53cd\u5c04\u7684\u6267\u884c\u65f6\u95f4\u8d85\u8fc7\u4f7f\u7528\u76f4\u63a5\u63a5\u5165\u76841000\u500d\u4ee5\u4e0a\u3002\u901a\u8fc7\u6bd4\u8f83\uff0cIBM JVM\u53ef\u80fd\u7a0d\u597d\u4e00\u4e9b\uff0c\u4f46\u53cd\u5c04\u65b9\u6cd5\u4ecd\u65e7\u9700\u8981\u6bd4\u5176\u5b83\u65b9\u6cd5\u957f700\u500d\u4ee5\u4e0a\u7684\u65f6\u95f4\u3002\u4efb\u4f55JVM\u4e0a\u5176\u5b83\u4e24\u79cd\u65b9\u6cd5\u4e4b\u95f4\u65f6\u95f4\u65b9\u9762\u65e0\u4efb\u4f55\u663e\u8457\u5dee\u5f02\uff0c\u4f46IBM JVM\u51e0\u4e4e\u6bd4Sun JVM\u5feb\u4e00\u500d\u3002\u6700\u6709\u53ef\u80fd\u7684\u662f\u8fd9\u79cd\u5dee\u5f02\u53cd\u6620\u4e86Sun Hot Spot JVM\u7684\u4e13\u4e1a\u4f18\u5316\uff0c\u5b83\u5728\u7b80\u5355\u57fa\u51c6\u65b9\u9762\u8868\u73b0\u5f97\u5f88\u7cdf\u7cd5\u3002\u53cd\u5c04\u6027\u80fd\u662fSun\u5f00\u53d11.4 JVM\u65f6\u5173\u6ce8\u7684\u4e00\u4e2a\u65b9\u9762\uff0c\u5b83\u5728\u53cd\u5c04\u65b9\u6cd5\u8c03\u7528\u7ed3\u679c\u4e2d\u663e\u793a\u3002\u5728\u8fd9\u7c7b\u64cd\u4f5c\u7684\u6027\u80fd\u65b9\u9762\uff0cSun 1.4.1 JVM\u663e\u793a\u4e86\u6bd41.3.1\u7248\u672c\u5f88\u5927\u7684\u6539\u8fdb\u3002 \u5982\u679c\u4e3a\u4e3a\u521b\u5efa\u4f7f\u7528\u53cd\u5c04\u7684\u5bf9\u8c61\u7f16\u5199\u4e86\u7c7b\u4f3c\u7684\u8ba1\u65f6\u6d4b\u8bd5\u7a0b\u5e8f\uff0c\u6211\u4eec\u4f1a\u53d1\u73b0\u8fd9\u79cd\u60c5\u51b5\u4e0b\u7684\u5dee\u5f02\u4e0d\u8c61\u5b57\u6bb5\u548c\u65b9\u6cd5\u8c03\u7528\u60c5\u51b5\u4e0b\u90a3\u4e48\u663e\u8457\u3002\u4f7f\u7528newInstance()\u8c03\u7528\u521b\u5efa\u4e00\u4e2a\u7b80\u5355\u7684java.lang.Object\u5b9e\u4f8b\u8017\u7528\u7684\u65f6\u95f4\u5927\u7ea6\u662f\u5728Sun 1.3.1 JVM\u4e0a\u4f7f\u7528new Object()\u768412\u500d\uff0c\u662f\u5728IBM 1.4.0 JVM\u7684\u56db\u500d\uff0c\u53ea\u662fSun 1.4.1 JVM\u4e0a\u7684\u4e24\u90e8\u3002\u4f7f\u7528Array.newInstance(type, size)\u521b\u5efa\u4e00\u4e2a\u6570\u7ec4\u8017\u7528\u7684\u65f6\u95f4\u662f\u4efb\u4f55\u6d4b\u8bd5\u7684JVM\u4e0a\u4f7f\u7528new type[size]\u7684\u4e24\u500d\uff0c\u968f\u7740\u6570\u7ec4\u5927\u5c0f\u7684\u589e\u52a0\uff0c\u5dee\u5f02\u9010\u6b65\u7f29\u5c0f\u3002 \u7ed3\u675f\u8bed\uff1a Java\u8bed\u8a00\u53cd\u5c04\u63d0\u4f9b\u4e00\u79cd\u52a8\u6001\u94fe\u63a5\u7a0b\u5e8f\u7ec4\u4ef6\u7684\u591a\u529f\u80fd\u65b9\u6cd5\u3002\u5b83\u5141\u8bb8\u7a0b\u5e8f\u521b\u5efa\u548c\u63a7\u5236\u4efb\u4f55\u7c7b\u7684\u5bf9\u8c61(\u6839\u636e\u5b89\u5168\u6027\u9650\u5236)\uff0c\u65e0\u9700\u63d0\u524d\u786c\u7f16\u7801\u76ee\u6807\u7c7b\u3002\u8fd9\u4e9b\u7279\u6027\u4f7f\u5f97\u53cd\u5c04\u7279\u522b\u9002\u7528\u4e8e\u521b\u5efa\u4ee5\u975e\u5e38\u666e\u901a\u7684\u65b9\u5f0f\u4e0e\u5bf9\u8c61\u534f\u4f5c\u7684\u5e93\u3002\u4f8b\u5982\uff0c\u53cd\u5c04\u7ecf\u5e38\u5728\u6301\u7eed\u5b58\u50a8\u5bf9\u8c61\u4e3a\u6570\u636e\u5e93\u3001XML\u6216\u5176\u5b83\u5916\u90e8\u683c\u5f0f\u7684\u6846\u67b6\u4e2d\u4f7f\u7528\u3002Java reflection \u975e\u5e38\u6709\u7528\uff0c\u5b83\u4f7f\u7c7b\u548c\u6570\u636e\u7ed3\u6784\u80fd\u6309\u540d\u79f0\u52a8\u6001\u68c0\u7d22\u76f8\u5173\u4fe1\u606f\uff0c\u5e76\u5141\u8bb8\u5728\u8fd0\u884c\u7740\u7684\u7a0b\u5e8f\u4e2d\u64cd\u4f5c\u8fd9\u4e9b\u4fe1\u606f\u3002Java \u7684\u8fd9\u4e00\u7279\u6027\u975e\u5e38\u5f3a\u5927\uff0c\u5e76\u4e14\u662f\u5176\u5b83\u4e00\u4e9b\u5e38\u7528\u8bed\u8a00\uff0c\u5982 C\u3001C++\u3001Fortran \u6216\u8005 Pascal \u7b49\u90fd\u4e0d\u5177\u5907\u7684\u3002 \u4f46\u53cd\u5c04\u6709\u4e24\u4e2a\u7f3a\u70b9\u3002\u7b2c\u4e00\u4e2a\u662f\u6027\u80fd\u95ee\u9898\u3002\u7528\u4e8e\u5b57\u6bb5\u548c\u65b9\u6cd5\u63a5\u5165\u65f6\u53cd\u5c04\u8981\u8fdc\u6162\u4e8e\u76f4\u63a5\u4ee3\u7801\u3002\u6027\u80fd\u95ee\u9898\u7684\u7a0b\u5ea6\u53d6\u51b3\u4e8e\u7a0b\u5e8f\u4e2d\u662f\u5982\u4f55\u4f7f\u7528\u53cd\u5c04\u7684\u3002\u5982\u679c\u5b83\u4f5c\u4e3a\u7a0b\u5e8f\u8fd0\u884c\u4e2d\u76f8\u5bf9\u5f88\u5c11\u6d89\u53ca\u7684\u90e8\u5206\uff0c\u7f13\u6162\u7684\u6027\u80fd\u5c06\u4e0d\u4f1a\u662f\u4e00\u4e2a\u95ee\u9898\u3002\u5373\u4f7f\u6d4b\u8bd5\u4e2d\u6700\u574f\u60c5\u51b5\u4e0b\u7684\u8ba1\u65f6\u56fe\u663e\u793a\u7684\u53cd\u5c04\u64cd\u4f5c\u53ea\u8017\u7528\u51e0\u5fae\u79d2\u3002\u4ec5\u53cd\u5c04\u5728\u6027\u80fd\u5173\u952e\u7684\u5e94\u7528\u7684\u6838\u5fc3\u903b\u8f91\u4e2d\u4f7f\u7528\u65f6\u6027\u80fd\u95ee\u9898\u624d\u53d8\u5f97\u81f3\u5173\u91cd\u8981\u3002 \u8bb8\u591a\u5e94\u7528\u4e2d\u66f4\u4e25\u91cd\u7684\u4e00\u4e2a\u7f3a\u70b9\u662f\u4f7f\u7528\u53cd\u5c04\u4f1a\u6a21\u7cca\u7a0b\u5e8f\u5185\u90e8\u5b9e\u9645\u8981\u53d1\u751f\u7684\u4e8b\u60c5\u3002\u7a0b\u5e8f\u4eba\u5458\u5e0c\u671b\u5728\u6e90\u4ee3\u7801\u4e2d\u770b\u5230\u7a0b\u5e8f\u7684\u903b\u8f91\uff0c\u53cd\u5c04\u7b49\u7ed5\u8fc7\u4e86\u6e90\u4ee3\u7801\u7684\u6280\u672f\u4f1a\u5e26\u6765\u7ef4\u62a4\u95ee\u9898\u3002\u53cd\u5c04\u4ee3\u7801\u6bd4\u76f8\u5e94\u7684\u76f4\u63a5\u4ee3\u7801\u66f4\u590d\u6742\uff0c\u6b63\u5982\u6027\u80fd\u6bd4\u8f83\u7684\u4ee3\u7801\u5b9e\u4f8b\u4e2d\u770b\u5230\u7684\u4e00\u6837\u3002\u89e3\u51b3\u8fd9\u4e9b\u95ee\u9898\u7684\u6700\u4f73\u65b9\u6848\u662f\u4fdd\u5b88\u5730\u4f7f\u7528\u53cd\u5c04\u2014\u2014\u4ec5\u5728\u5b83\u53ef\u4ee5\u771f\u6b63\u589e\u52a0\u7075\u6d3b\u6027\u7684\u5730\u65b9\u2014\u2014\u8bb0\u5f55\u5176\u5728\u76ee\u6807\u7c7b\u4e2d\u7684\u4f7f\u7528\u3002 \u6700\u8fd1\u5728\u6210\u90fd\u5199\u4e00\u4e2a\u79fb\u52a8\u589e\u503c\u9879\u76ee\uff0c\u4ffa\u8d1f\u8d23\u540e\u53f0server\u7aef\u3002\u529f\u80fd\u5f88\u7b80\u5355\uff0c\u624b\u673a\u7528\u6237\u901a\u8fc7GPRS\u6253\u5f00Socket\u4e0e\u670d\u52a1\u5668\u8fde\u63a5\uff0c\u6211\u5219\u6839\u636e\u7528\u6237\u4f20\u8fc7\u6765\u7684\u6570\u636e\u505a\u51fa\u54cd\u5e94\u3002\u505a\u8fc7\u7c7b\u4f3c\u9879\u76ee\u7684\u5144\u5f1f\u4e00\u5b9a\u90fd\u77e5\u9053\uff0c\u9996\u5148\u9700\u8981\u5b9a\u4e49\u4e00\u4e2a\u7c7b\u4f3c\u4e8eMSNP\u7684\u901a\u8baf\u534f\u8bae\uff0c\u4e0d\u8fc7\u4eca\u5929\u7684\u8bdd\u9898\u662f\u5982\u4f55\u628a\u8fd9\u4e2a\u7cfb\u7edf\u8bbe\u8ba1\u5f97\u5177\u6709\u9ad8\u5ea6\u7684\u6269\u5c55\u6027\u3002\u7531\u4e8e\u8fd9\u4e2a\u9879\u76ee\u672c\u8eab\u6ca1\u6709\u8fdb\u884c\u8fc7\u8f83\u4e3a\u5b8c\u5584\u7684\u5ba2\u6237\u6c9f\u901a\u548c\u9700\u6c42\u5206\u6790\uff0c\u6240\u4ee5\u4ee5\u540e\u80af\u5b9a\u4f1a\u6709\u5f88\u591a\u529f\u80fd\u4e0a\u7684\u6269\u5c55\uff0c\u901a\u8baf\u534f\u8bae\u80af\u5b9a\u4f1a\u8d8a\u6765\u8d8a\u5e9e\u5927\uff0c\u800c\u6211\u4f5c\u4e3a\u4e00\u4e2a\u4e0d\u90a3\u4e48\u52e4\u5feb\u7684\u4eba\uff0c\u5f53\u7136\u4e0d\u60f3\u4ee5\u540e\u518d\u53bb\u4fee\u6539\u5199\u597d\u7684\u7a0b\u5e8f\uff0c\u6240\u4ee5\u8fd9\u4e2a\u9879\u76ee\u662f\u5b9e\u8df5\u9762\u5411\u5bf9\u8c61\u8bbe\u8ba1\u7684\u597d\u673a\u4f1a\u3002 \u9996\u5148\u5b9a\u4e49\u4e00\u4e2a\u63a5\u53e3\u6765\u9694\u79bb\u7c7b\uff1a package org.bromon.reflect; public interface Operator { public java.util.List act(java.util.List params) } \u6839\u636e\u8bbe\u8ba1\u6a21\u5f0f\u7684\u539f\u7406\uff0c\u6211\u4eec\u53ef\u4ee5\u4e3a\u4e0d\u540c\u7684\u529f\u80fd\u7f16\u5199\u4e0d\u540c\u7684\u7c7b\uff0c\u6bcf\u4e2a\u7c7b\u90fd\u7ee7\u627fOperator\u63a5\u53e3\uff0c\u5ba2\u6237\u7aef\u53ea\u9700\u8981\u9488\u5bf9Operator\u63a5\u53e3\u7f16\u7a0b\u5c31\u53ef\u4ee5\u907f\u514d\u5f88\u591a\u9ebb\u70e6\u3002\u6bd4\u5982\u8fd9\u4e2a\u7c7b\uff1a package org.bromon.reflect.*; public class Success implements Operator { public java.util.List act(java.util.List params) { List result=new ArrayList();   Java \u7684\u53cd\u5c04\u673a\u5236\u662f\u4f7f\u5176\u5177\u6709\u52a8\u6001\u7279\u6027\u7684\u975e\u5e38\u5173\u952e\u7684\u4e00\u79cd\u673a\u5236\uff0c\u4e5f\u662f\u5728JavaBean \u4e2d\u5e7f\u6cdb\u5e94\u7528\u7684\u4e00\u79cd\u7279\u6027\u3002 \u8fd0\u7528JavaBean \u7684\u6700\u5e38\u89c1\u7684\u95ee\u9898\u662f\uff1a\u6839\u636e\u6307\u5b9a\u7684\u7c7b\u540d\uff0c\u7c7b\u5b57\u6bb5\u540d\u548c\u6240\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u5f97\u5230\u8be5\u7c7b\u7684\u5b9e\u4f8b\uff0c\u4e0b\u9762\u7684\u4e00\u4e2a\u4f8b\u5b50\u6f14\u793a\u4e86\u8fd9\u4e00\u5b9e\u73b0\u3002 -|Base.java //\u62bd\u8c61\u57fa\u7c7b |Son1.java //\u57fa\u7c7b\u6269\u5c551 |Son2.java //\u57fa\u7c7b\u6269\u5c552 |Util.java /** * @author metaphy * create 2005-4-14 9:06:56 * \u8bf4\u660e\uff1a */ \uff081\uff09Base.java \u62bd\u8c61\u57fa\u7c7b\u53ea\u662f\u4e00\u4e2a\u5b9a\u4e49 public abstract class Base { } \uff082\uff09Son1.java /Son2.java \u662f\u5df2\u7ecf\u5b9e\u73b0\u7684JavaBean public class Son1 extends Base{ private int id ; private String name ; public int getId() { return id; } public void setId(int id) { this.id = id; } public String getName() { return name; } public void setName(String name) { this.name = name; } public void son1Method(String s){ System.out.println(s) ; } } \uff083\uff09 public class Son2 extends Base{ private int id; private double salary; public int getId() { return id; } public void setId(int id) { this.id = id; } public double getSalary() { return salary; } public void setSalary(double salary) { this.salary = salary; } } \uff084\uff09Util.java \u6f14\u793a\u4e86\u5982\u4f55\u6839\u636e\u6307\u5b9a\u7684\u7c7b\u540d\uff0c\u7c7b\u5b57\u6bb5\u540d\u548c\u6240\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u5f97\u5230\u4e00\u4e2a\u7c7b\u7684\u5b9e\u4f8b import java.lang.reflect.Method; public class Util { //\u6b64\u65b9\u6cd5\u7684\u6700\u5927\u597d\u5904\u662f\u6ca1\u6709\u7c7b\u540dSon1,Son2 \u53ef\u4ee5\u901a\u8fc7\u53c2\u6570\u6765\u6307\u5b9a\uff0c\u7a0b\u5e8f\u91cc\u9762\u6839\u672c\u4e0d\u7528\u51fa\u73b0 public static Base convertStr2ServiceBean(String beanName,String fieldSetter,String paraValue){ Base base = null ; try { Class cls = Class.forName(beanName) ; base = (Base)cls.newInstance() ; Class[] paraTypes = new Class[]{String.class }; Method method = cls.getMethod(fieldSetter, paraTypes) ; String[] paraValues = new String[]{paraValue} ; method.invoke(base, paraValues) ; } catch (Throwable e) { System.err.println(e); } return base ; } public static void main(String[] args){ Son1 son1 =(Son1) Util.convertStr2ServiceBean('trying.reflect.Son1','setName','wang da sha'); System.out.println('son1.getName() :'+son1.getName()) ; } } //\u8c03\u7528\u7ed3\u679c\uff1a //son1.getName() :wang da sha \u8c22\u8c22\uff01\u5e0c\u671b\u80fd\u7ed9\u5927\u5bb6\u4e00\u70b9\u542f\u53d1\uff01 \uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d\uff0d \u9644\uff1a //\u4e0b\u9762\u8fd9\u7bc7\u6587\u6863\u6765\u6e90\u4e8eInternet\uff0c\u4f5c\u8005\u4e0d\u8be6 Reflection \u662f Java \u7a0b\u5e8f\u5f00\u53d1\u8bed\u8a00\u7684\u7279\u5f81\u4e4b\u4e00\uff0c\u5b83\u5141\u8bb8\u8fd0\u884c\u4e2d\u7684 Java \u7a0b\u5e8f\u5bf9\u81ea\u8eab\u8fdb\u884c\u68c0\u67e5\uff0c\u6216\u8005\u8bf4\u201c\u81ea\u5ba1\u201d\uff0c\u5e76\u80fd\u76f4\u63a5\u64cd\u4f5c\u7a0b\u5e8f\u7684\u5185\u90e8\u5c5e\u6027\u3002\u4f8b\u5982\uff0c\u4f7f\u7528\u5b83\u80fd\u83b7\u5f97 Java \u7c7b\u4e2d\u5404\u6210\u5458\u7684\u540d\u79f0\u5e76\u663e\u793a\u51fa\u6765\u3002 Java \u7684\u8fd9\u4e00\u80fd\u529b\u5728\u5b9e\u9645\u5e94\u7528\u4e2d\u4e5f\u8bb8\u7528\u5f97\u4e0d\u662f\u5f88\u591a\uff0c\u4f46\u662f\u5728\u5176\u5b83\u7684\u7a0b\u5e8f\u8bbe\u8ba1\u8bed\u8a00\u4e2d\u6839\u672c\u5c31\u4e0d\u5b58\u5728\u8fd9\u4e00\u7279\u6027\u3002\u4f8b\u5982\uff0cPascal\u3001C \u6216\u8005 C++ \u4e2d\u5c31\u6ca1\u6709\u529e\u6cd5\u5728\u7a0b\u5e8f\u4e2d\u83b7\u5f97\u51fd\u6570\u5b9a\u4e49\u76f8\u5173\u7684\u4fe1\u606f\u3002 JavaBean \u662f reflection \u7684\u5b9e\u9645\u5e94\u7528\u4e4b\u4e00\uff0c\u5b83\u80fd\u8ba9\u4e00\u4e9b\u5de5\u5177\u53ef\u89c6\u5316\u7684\u64cd\u4f5c\u8f6f\u4ef6\u7ec4\u4ef6\u3002\u8fd9\u4e9b\u5de5\u5177\u901a\u8fc7 reflection \u52a8\u6001\u7684\u8f7d\u5165\u5e76\u53d6\u5f97 Java \u7ec4\u4ef6(\u7c7b) \u7684\u5c5e\u6027\u3002 1. \u4e00\u4e2a\u7b80\u5355\u7684\u4f8b\u5b50 \u8003\u8651\u4e0b\u9762\u8fd9\u4e2a\u7b80\u5355\u7684\u4f8b\u5b50\uff0c\u8ba9\u6211\u4eec\u770b\u770b reflection \u662f\u5982\u4f55\u5de5\u4f5c\u7684\u3002 import java.lang.reflect.*; public class DumpMethods { public static void main(String args[]) { try { Class c = Class.forName(args[0]); Method m[] = c.getDeclaredMethods(); for (int i = 0; i < m.length; i++) System.out.println(m[i].toString()); } catch (Throwable e) { System.err.println(e); } } } \u6309\u5982\u4e0b\u8bed\u53e5\u6267\u884c\uff1a java DumpMethods java.util.Stack \u5b83\u7684\u7ed3\u679c\u8f93\u51fa\u4e3a\uff1a public java.lang.Object java.util.Stack.push(java.lang.Object) public synchronized java.lang.Object java.util.Stack.pop() public synchronized java.lang.Object java.util.Stack.peek() public boolean java.util.Stack.empty() public synchronized int java.util.Stack.search(java.lang.Object) \u8fd9\u6837\u5c31\u5217\u51fa\u4e86java.util.Stack \u7c7b\u7684\u5404\u65b9\u6cd5\u540d\u4ee5\u53ca\u5b83\u4eec\u7684\u9650\u5236\u7b26\u548c\u8fd4\u56de\u7c7b\u578b\u3002 \u8fd9\u4e2a\u7a0b\u5e8f\u4f7f\u7528 Class.forName \u8f7d\u5165\u6307\u5b9a\u7684\u7c7b\uff0c\u7136\u540e\u8c03\u7528 getDeclaredMethods \u6765\u83b7\u53d6\u8fd9\u4e2a\u7c7b\u4e2d\u5b9a\u4e49\u4e86\u7684\u65b9\u6cd5\u5217\u8868\u3002java.lang.reflect.Methods \u662f\u7528\u6765\u63cf\u8ff0\u67d0\u4e2a\u7c7b\u4e2d\u5355\u4e2a\u65b9\u6cd5\u7684\u4e00\u4e2a\u7c7b\u3002 2.\u5f00\u59cb\u4f7f\u7528 Reflection \u7528\u4e8e reflection \u7684\u7c7b\uff0c\u5982 Method\uff0c\u53ef\u4ee5\u5728 java.lang.relfect \u5305\u4e2d\u627e\u5230\u3002\u4f7f\u7528\u8fd9\u4e9b\u7c7b\u7684\u65f6\u5019\u5fc5\u987b\u8981\u9075\u5faa\u4e09\u4e2a\u6b65\u9aa4\uff1a\u7b2c\u4e00\u6b65\u662f\u83b7\u5f97\u4f60\u60f3\u64cd\u4f5c\u7684\u7c7b\u7684 java.lang.Class \u5bf9\u8c61\u3002\u5728\u8fd0\u884c\u4e2d\u7684 Java \u7a0b\u5e8f\u4e2d\uff0c\u7528 java.lang.Class \u7c7b\u6765\u63cf\u8ff0\u7c7b\u548c\u63a5\u53e3\u7b49\u3002 \u4e0b\u9762\u5c31\u662f\u83b7\u5f97\u4e00\u4e2a Class \u5bf9\u8c61\u7684\u65b9\u6cd5\u4e4b\u4e00\uff1a Class c = Class.forName('java.lang.String'); \u8fd9\u6761\u8bed\u53e5\u5f97\u5230\u4e00\u4e2a String \u7c7b\u7684\u7c7b\u5bf9\u8c61\u3002\u8fd8\u6709\u53e6\u4e00\u79cd\u65b9\u6cd5\uff0c\u5982\u4e0b\u9762\u7684\u8bed\u53e5\uff1a Class c = int.class; \u6216\u8005 Class c = Integer.TYPE; \u5b83\u4eec\u53ef\u83b7\u5f97\u57fa\u672c\u7c7b\u578b\u7684\u7c7b\u4fe1\u606f\u3002\u5176\u4e2d\u540e\u4e00\u79cd\u65b9\u6cd5\u4e2d\u8bbf\u95ee\u7684\u662f\u57fa\u672c\u7c7b\u578b\u7684\u5c01\u88c5\u7c7b (\u5982 Integer) \u4e2d\u9884\u5148\u5b9a\u4e49\u597d\u7684 TYPE \u5b57\u6bb5\u3002 \u7b2c\u4e8c\u6b65\u662f\u8c03\u7528\u8bf8\u5982 getDeclaredMethods \u7684\u65b9\u6cd5\uff0c\u4ee5\u53d6\u5f97\u8be5\u7c7b\u4e2d\u5b9a\u4e49\u7684\u6240\u6709\u65b9\u6cd5\u7684\u5217\u8868\u3002 \u4e00\u65e6\u53d6\u5f97\u8fd9\u4e2a\u4fe1\u606f\uff0c\u5c31\u53ef\u4ee5\u8fdb\u884c\u7b2c\u4e09\u6b65\u4e86\u2014\u2014\u4f7f\u7528 reflection API \u6765\u64cd\u4f5c\u8fd9\u4e9b\u4fe1\u606f\uff0c\u5982\u4e0b\u9762\u8fd9\u6bb5\u4ee3\u7801\uff1a Class c = Class.forName('java.lang.String'); Method m[] = c.getDeclaredMethods(); System.out.println(m[0].toString()); \u5b83\u5c06\u4ee5\u6587\u672c\u65b9\u5f0f\u6253\u5370\u51fa String \u4e2d\u5b9a\u4e49\u7684\u7b2c\u4e00\u4e2a\u65b9\u6cd5\u7684\u539f\u578b\u3002 \u5728\u4e0b\u9762\u7684\u4f8b\u5b50\u4e2d\uff0c\u8fd9\u4e09\u4e2a\u6b65\u9aa4\u5c06\u4e3a\u4f7f\u7528 reflection \u5904\u7406\u7279\u6b8a\u5e94\u7528\u7a0b\u5e8f\u63d0\u4f9b\u4f8b\u8bc1\u3002 \u6a21\u62df instanceof \u64cd\u4f5c\u7b26 \u5f97\u5230\u7c7b\u4fe1\u606f\u4e4b\u540e\uff0c\u901a\u5e38\u4e0b\u4e00\u4e2a\u6b65\u9aa4\u5c31\u662f\u89e3\u51b3\u5173\u4e8e Class \u5bf9\u8c61\u7684\u4e00\u4e9b\u57fa\u672c\u7684\u95ee\u9898\u3002\u4f8b\u5982\uff0cClass.isInstance \u65b9\u6cd5\u53ef\u4ee5\u7528\u4e8e\u6a21\u62df instanceof \u64cd\u4f5c\u7b26\uff1a class A { } public class instance1 { public static void main(String args[]) { try { Class cls = Class.forName('A'); boolean b1 = cls.isInstance(new Integer(37)); System.out.println(b1); boolean b2 = cls.isInstance(new A()); System.out.println(b2); } catch (Throwable e) { System.err.println(e); } } } \u5728\u8fd9\u4e2a\u4f8b\u5b50\u4e2d\u521b\u5efa\u4e86\u4e00\u4e2a A \u7c7b\u7684 Class \u5bf9\u8c61\uff0c\u7136\u540e\u68c0\u67e5\u4e00\u4e9b\u5bf9\u8c61\u662f\u5426\u662f A \u7684\u5b9e\u4f8b\u3002Integer(37) \u4e0d\u662f\uff0c\u4f46 new A() \u662f\u3002 3.\u627e\u51fa\u7c7b\u7684\u65b9\u6cd5 \u627e\u51fa\u4e00\u4e2a\u7c7b\u4e2d\u5b9a\u4e49\u4e86\u4e9b\u4ec0\u4e48\u65b9\u6cd5\uff0c\u8fd9\u662f\u4e00\u4e2a\u975e\u5e38\u6709\u4ef7\u503c\u4e5f\u975e\u5e38\u57fa\u7840\u7684 reflection \u7528\u6cd5\u3002\u4e0b\u9762\u7684\u4ee3\u7801\u5c31\u5b9e\u73b0\u4e86\u8fd9\u4e00\u7528\u6cd5\uff1a import java.lang.reflect.*; public class method1 { private int f1(Object p, int x) throws NullPointerException { if (p == null) throw new NullPointerException(); return x; } public static void main(String args[]) { try { Class cls = Class.forName('method1'); Method methlist[] = cls.getDeclaredMethods(); for (int i = 0; i < methlist.length; i++) { Method m = methlist[i]; System.out.println('name = ' + m.getName()); System.out.println('decl class = ' + m.getDeclaringClass()); Class pvec[] = m.getParameterTypes(); for (int j = 0; j < pvec.length; j++) System.out.println('param #' + j + ' ' + pvec[j]); Class evec[] = m.getExceptionTypes(); for (int j = 0; j < evec.length; j++) System.out.println('exc #' + j + ' ' + evec[j]); System.out.println('return type = ' + m.getReturnType()); System.out.println('-----'); } } catch (Throwable e) { System.err.println(e); } } } \u8fd9\u4e2a\u7a0b\u5e8f\u9996\u5148\u53d6\u5f97 method1 \u7c7b\u7684\u63cf\u8ff0\uff0c\u7136\u540e\u8c03\u7528 getDeclaredMethods \u6765\u83b7\u53d6\u4e00\u7cfb\u5217\u7684 Method \u5bf9\u8c61\uff0c\u5b83\u4eec\u5206\u522b\u63cf\u8ff0\u4e86\u5b9a\u4e49\u5728\u7c7b\u4e2d\u7684\u6bcf\u4e00\u4e2a\u65b9\u6cd5\uff0c\u5305\u62ec public \u65b9\u6cd5\u3001protected \u65b9\u6cd5\u3001package \u65b9\u6cd5\u548c private \u65b9\u6cd5\u7b49\u3002\u5982\u679c\u4f60\u5728\u7a0b\u5e8f\u4e2d\u4f7f\u7528 getMethods \u6765\u4ee3\u66ff getDeclaredMethods\uff0c\u4f60\u8fd8\u80fd\u83b7\u5f97\u7ee7\u627f\u6765\u7684\u5404\u4e2a\u65b9\u6cd5\u7684\u4fe1\u606f\u3002 \u53d6\u5f97\u4e86 Method \u5bf9\u8c61\u5217\u8868\u4e4b\u540e\uff0c\u8981\u663e\u793a\u8fd9\u4e9b\u65b9\u6cd5\u7684\u53c2\u6570\u7c7b\u578b\u3001\u5f02\u5e38\u7c7b\u578b\u548c\u8fd4\u56de\u503c\u7c7b\u578b\u7b49\u5c31\u4e0d\u96be\u4e86\u3002\u8fd9\u4e9b\u7c7b\u578b\u662f\u57fa\u672c\u7c7b\u578b\u8fd8\u662f\u7c7b\u7c7b\u578b\uff0c\u90fd\u53ef\u4ee5\u7531\u63cf\u8ff0\u7c7b\u7684\u5bf9\u8c61\u6309\u987a\u5e8f\u7ed9\u51fa\u3002 \u8f93\u51fa\u7684\u7ed3\u679c\u5982\u4e0b\uff1a name = f1 decl class = class method1 param #0 class java.lang.Object param #1 int exc #0 class java.lang.NullPointerException return type = int ----- name = main decl class = class method1 param #0 class [Ljava.lang.String; return type = void ----- 4.\u83b7\u53d6\u6784\u9020\u5668\u4fe1\u606f \u83b7\u53d6\u7c7b\u6784\u9020\u5668\u7684\u7528\u6cd5\u4e0e\u4e0a\u8ff0\u83b7\u53d6\u65b9\u6cd5\u7684\u7528\u6cd5\u7c7b\u4f3c\uff0c\u5982\uff1a import java.lang.reflect.*; public class constructor1 { public constructor1() { } protected constructor1(int i, double d) { } public static void main(String args[]) { try { Class cls = Class.forName('constructor1'); Constructor ctorlist[] = cls.getDeclaredConstructors(); for (int i = 0; i < ctorlist.length; i++) { Constructor ct = ctorlist[i]; System.out.println('name = ' + ct.getName()); System.out.println('decl class = ' + ct.getDeclaringClass()); Class pvec[] = ct.getParameterTypes(); for (int j = 0; j < pvec.length; j++) System.out.println('param #' + j + ' ' + pvec[j]); Class evec[] = ct.getExceptionTypes(); for (int j = 0; j < evec.length; j++) System.out.println('exc #' + j + ' ' + evec[j]); System.out.println('-----'); } } catch (Throwable e) { System.err.println(e); } } } \u8fd9\u4e2a\u4f8b\u5b50\u4e2d\u6ca1\u80fd\u83b7\u5f97\u8fd4\u56de\u7c7b\u578b\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u90a3\u662f\u56e0\u4e3a\u6784\u9020\u5668\u6ca1\u6709\u8fd4\u56de\u7c7b\u578b\u3002 \u8fd9\u4e2a\u7a0b\u5e8f\u8fd0\u884c\u7684\u7ed3\u679c\u662f\uff1a name = constructor1 decl class = class constructor1 ----- name = constructor1 decl class = class constructor1 param #0 int param #1 double ----- 5.\u83b7\u53d6\u7c7b\u7684\u5b57\u6bb5(\u57df) \u627e\u51fa\u4e00\u4e2a\u7c7b\u4e2d\u5b9a\u4e49\u4e86\u54ea\u4e9b\u6570\u636e\u5b57\u6bb5\u4e5f\u662f\u53ef\u80fd\u7684\uff0c\u4e0b\u9762\u7684\u4ee3\u7801\u5c31\u5728\u5e72\u8fd9\u4e2a\u4e8b\u60c5\uff1a import java.lang.reflect.*; public class field1 { private double d; public static final int i = 37; String s = 'testing'; public static void main(String args[]) { try { Class cls = Class.forName('field1'); Field fieldlist[] = cls.getDeclaredFields(); for (int i = 0; i < fieldlist.length; i++) { Field fld = fieldlist[i]; System.out.println('name = ' + fld.getName()); System.out.println('decl class = ' + fld.getDeclaringClass()); System.out.println('type = ' + fld.getType()); int mod = fld.getModifiers(); System.out.println('modifiers = ' + Modifier.toString(mod)); System.out.println('-----'); } } catch (Throwable e) { System.err.println(e); } } } \u8fd9\u4e2a\u4f8b\u5b50\u548c\u524d\u9762\u90a3\u4e2a\u4f8b\u5b50\u975e\u5e38\u76f8\u4f3c\u3002\u4f8b\u4e2d\u4f7f\u7528\u4e86\u4e00\u4e2a\u65b0\u4e1c\u897f Modifier\uff0c\u5b83\u4e5f\u662f\u4e00\u4e2a reflection \u7c7b\uff0c\u7528\u6765\u63cf\u8ff0\u5b57\u6bb5\u6210\u5458\u7684\u4fee\u9970\u8bed\uff0c\u5982\u201cprivate int\u201d\u3002\u8fd9\u4e9b\u4fee\u9970\u8bed\u81ea\u8eab\u7531\u6574\u6570\u63cf\u8ff0\uff0c\u800c\u4e14\u4f7f\u7528 Modifier.toString \u6765\u8fd4\u56de\u4ee5\u201c\u5b98\u65b9\u201d\u987a\u5e8f\u6392\u5217\u7684\u5b57\u7b26\u4e32\u63cf\u8ff0 (\u5982\u201cstatic\u201d\u5728\u201cfinal\u201d\u4e4b\u524d)\u3002\u8fd9\u4e2a\u7a0b\u5e8f\u7684\u8f93\u51fa\u662f\uff1a name = d decl class = class field1 type = double modifiers = private ----- name = i decl class = class field1 type = int modifiers = public static final ----- name = s decl class = class field1 type = class java.lang.String modifiers = ----- \u548c\u83b7\u53d6\u65b9\u6cd5\u7684\u60c5\u51b5\u4e00\u4e0b\uff0c\u83b7\u53d6\u5b57\u6bb5\u7684\u65f6\u5019\u4e5f\u53ef\u4ee5\u53ea\u53d6\u5f97\u5728\u5f53\u524d\u7c7b\u4e2d\u7533\u660e\u4e86\u7684\u5b57\u6bb5\u4fe1\u606f (getDeclaredFields)\uff0c\u6216\u8005\u4e5f\u53ef\u4ee5\u53d6\u5f97\u7236\u7c7b\u4e2d\u5b9a\u4e49\u7684\u5b57\u6bb5 (getFields) \u3002 6.\u6839\u636e\u65b9\u6cd5\u7684\u540d\u79f0\u6765\u6267\u884c\u65b9\u6cd5 \u6587\u672c\u5230\u8fd9\u91cc\uff0c\u6240\u4e3e\u7684\u4f8b\u5b50\u65e0\u4e00\u4f8b\u5916\u90fd\u4e0e\u5982\u4f55\u83b7\u53d6\u7c7b\u7684\u4fe1\u606f\u6709\u5173\u3002\u6211\u4eec\u4e5f\u53ef\u4ee5\u7528 reflection \u6765\u505a\u4e00\u4e9b\u5176\u5b83\u7684\u4e8b\u60c5\uff0c\u6bd4\u5982\u6267\u884c\u4e00\u4e2a\u6307\u5b9a\u4e86\u540d\u79f0\u7684\u65b9\u6cd5\u3002\u4e0b\u9762\u7684\u793a\u4f8b\u6f14\u793a\u4e86\u8fd9\u4e00\u64cd\u4f5c\uff1a import java.lang.reflect.*; public class method2 { public int add(int a, int b) { return a + b; } public static void main(String args[]) { try { Class cls = Class.forName('method2'); Class partypes[] = new Class[2]; partypes[0] = Integer.TYPE; partypes[1] = Integer.TYPE; Method meth = cls.getMethod('add', partypes); method2 methobj = new method2(); Object arglist[] = new Object[2]; arglist[0] = new Integer(37); arglist[1] = new Integer(47); Object retobj = meth.invoke(methobj, arglist); Integer retval = (Integer) retobj; System.out.println(retval.intvalue()); } catch (Throwable e) { System.err.println(e); } } } \u5047\u5982\u4e00\u4e2a\u7a0b\u5e8f\u5728\u6267\u884c\u7684\u67d0\u5904\u7684\u65f6\u5019\u624d\u77e5\u9053\u9700\u8981\u6267\u884c\u67d0\u4e2a\u65b9\u6cd5\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u7684\u540d\u79f0\u662f\u5728\u7a0b\u5e8f\u7684\u8fd0\u884c\u8fc7\u7a0b\u4e2d\u6307\u5b9a\u7684 (\u4f8b\u5982\uff0cJavaBean \u5f00\u53d1\u73af\u5883\u4e2d\u5c31\u4f1a\u505a\u8fd9\u6837\u7684\u4e8b)\uff0c\u90a3\u4e48\u4e0a\u9762\u7684\u7a0b\u5e8f\u6f14\u793a\u4e86\u5982\u4f55\u505a\u5230\u3002 \u4e0a\u4f8b\u4e2d\uff0cgetMethod \u7528\u4e8e\u67e5\u627e\u4e00\u4e2a\u5177\u6709\u4e24\u4e2a\u6574\u578b\u53c2\u6570\u4e14\u540d\u4e3a add \u7684\u65b9\u6cd5\u3002\u627e\u5230\u8be5\u65b9\u6cd5\u5e76\u521b\u5efa\u4e86\u76f8\u5e94\u7684 Method \u5bf9\u8c61\u4e4b\u540e\uff0c\u5728\u6b63\u786e\u7684\u5bf9\u8c61\u5b9e\u4f8b\u4e2d\u6267\u884c\u5b83\u3002\u6267\u884c\u8be5\u65b9\u6cd5\u7684\u65f6\u5019\uff0c\u9700\u8981\u63d0\u4f9b\u4e00\u4e2a\u53c2\u6570\u5217\u8868\uff0c\u8fd9\u5728\u4e0a\u4f8b\u4e2d\u662f\u5206\u522b\u5305\u88c5\u4e86\u6574\u6570 37 \u548c 47 \u7684\u4e24\u4e2a Integer \u5bf9\u8c61\u3002\u6267\u884c\u65b9\u6cd5\u7684\u8fd4\u56de\u7684\u540c\u6837\u662f\u4e00\u4e2a Integer \u5bf9\u8c61\uff0c\u5b83\u5c01\u88c5\u4e86\u8fd4\u56de\u503c 84\u3002 7.\u521b\u5efa\u65b0\u7684\u5bf9\u8c61 \u5bf9\u4e8e\u6784\u9020\u5668\uff0c\u5219\u4e0d\u80fd\u50cf\u6267\u884c\u65b9\u6cd5\u90a3\u6837\u8fdb\u884c\uff0c\u56e0\u4e3a\u6267\u884c\u4e00\u4e2a\u6784\u9020\u5668\u5c31\u610f\u5473\u7740\u521b\u5efa\u4e86\u4e00\u4e2a\u65b0\u7684\u5bf9\u8c61 (\u51c6\u786e\u7684\u8bf4\uff0c\u521b\u5efa\u4e00\u4e2a\u5bf9\u8c61\u7684\u8fc7\u7a0b\u5305\u62ec\u5206\u914d\u5185\u5b58\u548c\u6784\u9020\u5bf9\u8c61)\u3002\u6240\u4ee5\uff0c\u4e0e\u4e0a\u4f8b\u6700\u76f8\u4f3c\u7684\u4f8b\u5b50\u5982\u4e0b\uff1a import java.lang.reflect.*; public class constructor2 { public constructor2() { } public constructor2(int a, int b) { System.out.println('a = ' + a + ' b = ' + b); } public static void main(String args[]) { try { Class cls = Class.forName('constructor2'); Class partypes[] = new Class[2]; partypes[0] = Integer.TYPE; partypes[1] = Integer.TYPE; Constructor ct = cls.getConstructor(partypes); Object arglist[] = new Object[2]; arglist[0] = new Integer(37); arglist[1] = new Integer(47); Object retobj = ct.newInstance(arglist); } catch (Throwable e) { System.err.println(e); } } } \u6839\u636e\u6307\u5b9a\u7684\u53c2\u6570\u7c7b\u578b\u627e\u5230\u76f8\u5e94\u7684\u6784\u9020\u51fd\u6570\u5e76\u6267\u884c\u5b83\uff0c\u4ee5\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u5bf9\u8c61\u5b9e\u4f8b\u3002\u4f7f\u7528\u8fd9\u79cd\u65b9\u6cd5\u53ef\u4ee5\u5728\u7a0b\u5e8f\u8fd0\u884c\u65f6\u52a8\u6001\u5730\u521b\u5efa\u5bf9\u8c61\uff0c\u800c\u4e0d\u662f\u5728\u7f16\u8bd1\u7684\u65f6\u5019\u521b\u5efa\u5bf9\u8c61\uff0c\u8fd9\u4e00\u70b9\u975e\u5e38\u6709\u4ef7\u503c\u3002 8.\u6539\u53d8\u5b57\u6bb5(\u57df)\u7684\u503c reflection \u7684\u8fd8\u6709\u4e00\u4e2a\u7528\u5904\u5c31\u662f\u6539\u53d8\u5bf9\u8c61\u6570\u636e\u5b57\u6bb5\u7684\u503c\u3002reflection \u53ef\u4ee5\u4ece\u6b63\u5728\u8fd0\u884c\u7684\u7a0b\u5e8f\u4e2d\u6839\u636e\u540d\u79f0\u627e\u5230\u5bf9\u8c61\u7684\u5b57\u6bb5\u5e76\u6539\u53d8\u5b83\uff0c\u4e0b\u9762\u7684\u4f8b\u5b50\u53ef\u4ee5\u8bf4\u660e\u8fd9\u4e00\u70b9\uff1a import java.lang.reflect.*; public class field2 { public double d; public static void main(String args[]) { try { Class cls = Class.forName('field2'); Field fld = cls.getField('d'); field2 f2obj = new field2(); System.out.println('d = ' + f2obj.d); fld.setDouble(f2obj, 12.34); System.out.println('d = ' + f2obj.d); } catch (Throwable e) { System.err.println(e); } } } \u8fd9\u4e2a\u4f8b\u5b50\u4e2d\uff0c\u5b57\u6bb5 d \u7684\u503c\u88ab\u53d8\u4e3a\u4e86 12.34\u3002 9.\u4f7f\u7528\u6570\u7ec4 \u672c\u6587\u4ecb\u7ecd\u7684 reflection \u7684\u6700\u540e\u4e00\u79cd\u7528\u6cd5\u662f\u521b\u5efa\u7684\u64cd\u4f5c\u6570\u7ec4\u3002\u6570\u7ec4\u5728 Java \u8bed\u8a00\u4e2d\u662f\u4e00\u79cd\u7279\u6b8a\u7684\u7c7b\u7c7b\u578b\uff0c\u4e00\u4e2a\u6570\u7ec4\u7684\u5f15\u7528\u53ef\u4ee5\u8d4b\u7ed9 Object \u5f15\u7528\u3002\u89c2\u5bdf\u4e0b\u9762\u7684\u4f8b\u5b50\u770b\u770b\u6570\u7ec4\u662f\u600e\u4e48\u5de5\u4f5c\u7684\uff1a import java.lang.reflect.*; public class array1 { public static void main(String args[]) { try { Class cls = Class.forName('java.lang.String'); Object arr = Array.newInstance(cls, 10); Array.set(arr, 5, 'this is a test'); String s = (String) Array.get(arr, 5); System.out.println(s); } catch (Throwable e) { System.err.println(e); } } } \u4f8b\u4e2d\u521b\u5efa\u4e86 10 \u4e2a\u5355\u4f4d\u957f\u5ea6\u7684 String \u6570\u7ec4\uff0c\u4e3a\u7b2c 5 \u4e2a\u4f4d\u7f6e\u7684\u5b57\u7b26\u4e32\u8d4b\u4e86\u503c\uff0c\u6700\u540e\u5c06\u8fd9\u4e2a\u5b57\u7b26\u4e32\u4ece\u6570\u7ec4\u4e2d\u53d6\u5f97\u5e76\u6253\u5370\u4e86\u51fa\u6765\u3002 \u4e0b\u9762\u8fd9\u6bb5\u4ee3\u7801\u63d0\u4f9b\u4e86\u4e00\u4e2a\u66f4\u590d\u6742\u7684\u4f8b\u5b50\uff1a import java.lang.reflect.*; public class array2 { public static void main(String args[]) { int dims[] = new int[]{5, 10, 15}; Object arr = Array.newInstance(Integer.TYPE, dims); Object arrobj = Array.get(arr, 3); Class cls = arrobj.getClass().getComponentType(); System.out.println(cls); arrobj = Array.get(arrobj, 5); Array.setInt(arrobj, 10, 37); int arrcast[][][] = (int[][][]) arr; System.out.println(arrcast[3][5][10]); } } \u4f8b\u4e2d\u521b\u5efa\u4e86\u4e00\u4e2a 5 x 10 x 15 \u7684\u6574\u578b\u6570\u7ec4\uff0c\u5e76\u4e3a\u5904\u4e8e [3][5][10] \u7684\u5143\u7d20\u8d4b\u4e86\u503c\u4e3a 37\u3002\u6ce8\u610f\uff0c**\u6570\u7ec4\u5b9e\u9645\u4e0a\u5c31\u662f\u6570\u7ec4\u7684\u6570\u7ec4\uff0c\u4f8b\u5982\uff0c\u7b2c\u4e00\u4e2a Array.get \u4e4b\u540e\uff0carrobj \u662f\u4e00\u4e2a 10 x 15 \u7684\u6570\u7ec4\u3002\u8fdb\u800c\u53d6\u5f97\u5176\u4e2d\u7684\u4e00\u4e2a\u5143\u7d20\uff0c\u5373\u957f\u5ea6\u4e3a 15 \u7684\u6570\u7ec4\uff0c\u5e76\u4f7f\u7528 Array.setInt \u4e3a\u5b83\u7684\u7b2c 10 \u4e2a\u5143\u7d20\u8d4b\u503c\u3002 \u6ce8\u610f\u521b\u5efa\u6570\u7ec4\u65f6\u7684\u7c7b\u578b\u662f\u52a8\u6001\u7684\uff0c\u5728\u7f16\u8bd1\u65f6\u5e76\u4e0d\u77e5\u9053\u5176\u7c7b\u578b\u3002' 6302860, 0, 17, '2011-3-16 20:45:00', '\u4eba\u662f\u751f\u547d\u7684\u6709\u673a\u4f53\uff0c\u6210\u529f\u6709\u8d56\u4e8e\u826f\u597d\u7684\u4f11\u606f\uff0c\u7761\u7720\u662f\u5176\u4e2d\u7684\u5173\u952e\u3002\u7761\u7720\u4e0d\u5728\u4e8e\u7761\u591a\u4e45\uff0c\u800c\u5728\u4e8e\u7761\u591a\u597d\uff0c\u7761\u7720\u7684\u597d\u574f\u53d6\u51b3\u4e8e\u4f60\u653e\u677e\u7684\u7a0b\u5ea6\u3002\u50ac\u7720\u672f\u7684\u6838\u5fc3\u5c31\u5728\u4e8e\u5b8c\u5168\u7684\u653e\u677e\u3002\u4e16\u754c\u4e0a\u591a\u6570\u4eba\u90fd\u5728\u8ffd\u9010\u6c42\u7d22\u5982\u4f55\u6210\u529f\uff0c\u5374\u4e0d\u77e5\u6210\u529f\u7684\u5173\u952e\u4e4b\u4e00\u662f\u4ece\u6bcf\u5929\u5b89\u7136\u5165\u7720\u5f00\u59cb\u3002\u5e38\u5e38\u662f\u56e0\u4e3a\u592a\u60f3\u6210\u529f\u4e86\uff0c\u6240\u4ee5\u5bdd\u98df\u96be\u5b89\uff0c\u800c\u4e0e\u6210\u529f\u5931\u4e4b\u4ea4\u81c2\u7684\u4f8b\u8bc1\u4e0d\u80dc\u679a\u4e3e\u3002\u539f\u6765\uff0c\u9519\u5931\u6210\u529f\u7adf\u8fd9\u6837\u5bb9\u6613\u3002\u9c81\u8fc5\u8bf4\u8fc7\uff0c\u4f1a\u4f11\u606f\u7684\u4eba\u624d\u4f1a\u5de5\u4f5c\u3002\u800c\u7761\u7720\u662f\u6700\u597d\u7684\u4f11\u606f\u3002\u5f53\u4f60\u5728\u5fd9\u788c\u3001\u594b\u6597\u3001\u6253\u62fc\u4e86\u4e00\u5929\u7684\u65f6\u5019\uff0c\u665a\u4e0a\u8eba\u5728\u5e8a\u4e0a\u7684\u65f6\u5019\uff0c\u4e00\u5b9a\u8981\u653e\u677e\u8eab\u5fc3\uff0c\u53bb\u9664\u6742\u5ff5\uff0c\u629b\u5f00\u70e6\u7410\u7684\u4e00\u5207\uff0c\u5c3d\u60c5\u800c\u5145\u5206\u4eab\u53d7\u4e00\u987f\u7f8e\u89c9\u3002\u5f85\u7b2c\u4e8c\u5929\u6e05\u6668\u8d77\u6765\uff0c\u5d2d\u65b0\u7684\u4e00\u5929\u5f00\u59cb\u7684\u65f6\u5019\uff0c\u4f60\u5c06\u5145\u6ee1\u6d3b\u529b\uff0c\u7cbe\u795e\u7115\u53d1\uff0c\u529b\u91cf\u65e0\u7a77\u3002 -\u2014\u2014\u300a\u6bcf\u5929\u8fdb\u6b65\u300b' 6302862, 0, 0, '2011-3-16 20:54:00', ' \u4e00.\u6784\u9020\u51fd\u6570  1.\u6784\u9020\u51fd\u6570\u7684\u7279\u5f81:  \u6784\u9020\u51fd\u6570\u662f\u4e00\u4e2a\u7279\u6b8a\u7684\u51fd\u6570.  \u6ca1\u6709\u8fd4\u56de\u503c\u7c7b\u578b. \u6784\u9020\u51fd\u6570\u5728\u521b\u5efa\u5bf9\u8c61\u7684\u65f6\u5019, \u7531\u865a\u62df\u673a\u8c03\u7528. \u6ce8\u610f: \u6ca1\u6709\u8fd4\u56de\u503c\u7c7b\u578b, \u4e0d\u8981\u5199void  \u65b9\u6cd5\u540d\u548c\u7c7b\u540d\u76f8\u540c.  \u4e0d\u80fd\u4f7f\u7528return\u8fd4\u56de\u4e00\u4e2a\u503c. \u4f46\u53ef\u4ee5\u4f7f\u7528return\u7ed3\u675f\u65b9\u6cd5. 2.\u6784\u9020\u51fd\u6570\u7684\u4f5c\u7528:  \u5f53\u6211\u4eec\u4f7f\u7528new\u5173\u952e\u5b57\u521b\u5efa\u5bf9\u8c61\u7684\u65f6\u5019, \u4e00\u5b9a\u4f1a\u8c03\u7528\u6784\u9020\u51fd\u6570  \u6211\u4eec\u901a\u5e38\u5728\u6784\u9020\u51fd\u6570\u4e2d\u505a\u4e00\u4e9b\u521d\u59cb\u5316\u7684\u5de5\u4f5c 3.\u6784\u9020\u51fd\u6570\u53ef\u4ee5\u91cd\u8f7d  \u548c\u666e\u901a\u51fd\u6570\u76f8\u540c, \u53ea\u8981\u53c2\u6570\u5217\u8868\u4e0d\u540c\u5373\u53ef. 4.\u6784\u9020\u51fd\u6570\u4e4b\u95f4\u7684\u8c03\u7528  \u53ef\u4ee5\u4f7f\u7528this\u5173\u952e\u5b57\u52a0\u53c2\u6570\u5217\u8868\u8c03\u7528\u5176\u4ed6\u7684\u6784\u9020\u51fd\u6570  \u4f7f\u7528this\u8c03\u7528\u5176\u4ed6\u6784\u9020\u51fd\u6570\u65f6, \u53ea\u80fd\u5728\u6784\u9020\u51fd\u6570\u7684\u7b2c\u4e00\u884c. 5.\u6bcf\u4e2a\u7c7b\u81f3\u5c11\u8981\u6709\u4e00\u4e2a\u6784\u9020\u51fd\u6570  \u5982\u679c\u6ca1\u6709\u663e\u5f0f\u7684\u58f0\u660e. \u865a\u62df\u673a\u4f1a\u4e3a\u8fd9\u4e2a\u7c7b\u6dfb\u52a0\u4e0a\u4e00\u4e2a\u9ed8\u8ba4\u65e0\u53c2\u7684\u6784\u9020\u51fd\u6570  \u5982\u679c\u58f0\u660e\u4e86\u4e00\u4e2a\u6709\u53c2\u7684\u6784\u9020\u51fd\u6570, \u90a3\u4e48\u5c31\u4e0d\u4f1a\u6dfb\u52a0\u9ed8\u8ba4\u65e0\u53c2\u7684\u6784\u9020\u51fd\u6570\u4e86 6.\u6784\u9020\u51fd\u6570\u7684\u8bbf\u95ee\u6743\u9650  \u4e00\u822c\u6784\u9020\u51fd\u6570\u90fd\u4f1a\u58f0\u660e\u4e3apublic, \u53ef\u4ee5\u4f9b\u5176\u4ed6\u7c7b\u4e2d\u521b\u5efa\u5bf9\u8c61.  \u5728\u67d0\u4e9b\u7279\u6b8a\u7684\u60c5\u51b5\u4e0b, \u4e0d\u5411\u8ba9\u522b\u4eba\u521b\u5efa\u5bf9\u8c61, \u53ef\u4ee5\u8bbe\u7f6e\u4e3aprivate 7.\u6784\u9020\u51fd\u6570\u6267\u884c\u987a\u5e8f  new Person();  \u5806\u5185\u5b58\u4e2d\u521b\u5efa\u5bf9\u8c61, \u521d\u59cb\u5316\u6210\u5458\u53d8\u91cf  \u8fd0\u884c\u6784\u9020\u51fd\u6570' 6302863, 0, 13, '2011-3-16 20:59:00', '\u7761\u7720\u8d35\u597d\u4eba\u662f\u751f\u547d\u7684\u6709\u673a\u4f53\uff0c\u6210\u529f\u6709\u8d56\u4e8e\u826f\u597d\u7684\u4f11\u606f\uff0c\u7761\u7720\u662f\u5176\u4e2d\u7684\u5173\u952e\u3002\u7761\u7720\u4e0d\u5728\u4e8e\u7761\u591a\u4e45\uff0c\u800c\u5728\u4e8e\u7761\u591a\u597d\uff0c\u7761\u7720\u7684\u597d\u574f\u53d6\u51b3\u4e8e\u4f60\u653e\u677e\u7684\u7a0b\u5ea6\u3002\u50ac\u7720\u672f\u7684\u6838\u5fc3\u5c31\u5728\u4e8e\u5b8c\u5168\u7684\u653e\u677e\u3002\u4e16\u754c\u4e0a\u591a\u6570\u4eba\u90fd\u5728\u8ffd\u9010\u6c42\u7d22\u5982\u4f55\u6210\u529f\uff0c\u5374\u4e0d\u77e5\u6210\u529f\u7684\u5173\u952e\u4e4b\u4e00\u662f\u4ece\u6bcf\u5929\u5b89\u7136\u5165\u7720\u5f00\u59cb\u3002\u5e38\u5e38\u662f\u56e0\u4e3a\u592a\u60f3\u6210\u529f\u4e86\uff0c\u6240\u4ee5\u5bdd\u98df\u96be\u5b89\uff0c\u800c\u4e0e\u6210\u529f\u5931\u4e4b\u4ea4\u81c2\u7684\u4f8b\u8bc1\u4e0d\u80dc\u679a\u4e3e\u3002\u539f\u6765\uff0c\u9519\u5931\u6210\u529f\u7adf\u8fd9\u6837\u5bb9\u6613\u3002\u9c81\u8fc5\u8bf4\u8fc7\uff0c\u4f1a\u4f11\u606f\u7684\u4eba\u624d\u4f1a\u5de5\u4f5c\u3002\u800c\u7761\u7720\u662f\u6700\u597d\u7684\u4f11\u606f\u3002\u5f53\u4f60\u5728\u5fd9\u788c\u3001\u594b\u6597\u3001\u6253\u62fc\u4e86\u4e00\u5929\u7684\u65f6\u5019\uff0c\u665a\u4e0a\u8eba\u5728\u5e8a\u4e0a\u7684\u65f6\u5019\uff0c\u4e00\u5b9a\u8981\u653e\u677e\u8eab\u5fc3\uff0c\u53bb\u9664\u6742\u5ff5\uff0c\u629b\u5f00\u70e6\u7410\u7684\u4e00\u5207\uff0c\u5c3d\u60c5\u800c\u5145\u5206\u4eab\u53d7\u4e00\u987f\u7f8e\u89c9\u3002\u5f85\u7b2c\u4e8c\u5929\u6e05\u6668\u8d77\u6765\uff0c\u5d2d\u65b0\u7684\u4e00\u5929\u5f00\u59cb\u7684\u65f6\u5019\uff0c\u4f60\u5c06\u5145\u6ee1\u6d3b\u529b\uff0c\u7cbe\u795e\u7115\u53d1\uff0c\u529b\u91cf\u65e0\u7a77\u3002 ' 6302865, 0, 39, '2011-3-16 21:06:00', ' Dom4j\u7684\u7b80\u5355\u4ecb\u7ecd1\u3001 Dom4j\u662f\u4e00\u4e2a\u7b80\u5355\u3001\u7075\u6d3b\u7684\u5f00\u653e\u6e90\u4ee3\u7801\u7684\u5e93\u3002Dom4j\u662f\u7531\u65e9\u671f\u5f00\u53d1JDOM\u5f00\u53d1\u7684\u3002\u4e0eJDOM\u4e0d\u540c\u7684\u662f\uff0cdom4j\u4f7f\u7528\u63a5\u53e3\u548c\u62bd\u8c61\u7684\u4eba\u5206\u79bb\u51fa\u6765\u800c\u540e\u72ec\u7acb\u57fa\u7c7b\uff0c\u867d\u7136Dom4j\u7684API\u76f8\u5bf9\u8981\u590d\u6742\u4e00\u4e9b\uff0c\u4f46\u5b83\u63d0\u4f9b\u4e86\u6bd4JDOM\u66f4\u597d\u7684\u7075\u6d3b\u6027\u30022\u3001 Dom4j\u662f\u4e00\u4e2a\u975e\u5e38\u4f18\u79c0\u7684Java XML API\uff0c\u5177\u6709\u6027\u80fd\u4f18\u5f02\u3001\u529f\u80fd\u5f3a\u5927\u548c\u6781\u6613\u4f7f\u7528\u7684\u7279\u70b9\u3002\u73b0\u5728\u5f88\u591a\u8f6f\u4ef6\u91c7\u7528\u7684Dom4j\uff0c\u4f8b\u5982Hibernate\uff0c\u5305\u62ecsun\u516c\u53f8\u81ea\u5df1\u7684JAXM\u4e5f\u7528\u4e86Dom4j\u30023\u3001  \u4f7f\u7528Dom4j\u5f00\u53d1\uff0c\u9700\u4e0b\u8f7ddom4j\u76f8\u5e94\u7684jar\u6587\u4ef6\u3002DOM4j\u4e2d\uff0c\u83b7\u5f97Document\u5bf9\u8c61\u7684\u65b9\u5f0f\u6709\u4e09\u79cd\uff1a       1.\u8bfb\u53d6XML\u6587\u4ef6,\u83b7\u5f97document\u5bf9\u8c61                       SAXReader reader = new SAXReader();                 Document   document = reader.read(new File('input.xml'));        2.\u89e3\u6790XML\u5f62\u5f0f\u7684\u6587\u672c,\u5f97\u5230document\u5bf9\u8c61.                 String text = '<members></members>';                  Document document = DocumentHelper.parseText(text);        3.\u4e3b\u52a8\u521b\u5efadocument\u5bf9\u8c61.                  Document document = DocumentHelper.createDocument();             //\u521b\u5efa\u6839\u8282\u70b9            Element root = document.addElement('members');\u8282\u70b9\u5bf9\u8c61\uff1a1\u3001\u83b7\u53d6\u6587\u6863\u7684\u6839\u8282\u70b9.      Element root = document.getRootElement(); 2\u3001\u53d6\u5f97\u67d0\u4e2a\u8282\u70b9\u7684\u5b50\u8282\u70b9.       Element element=node.element(\u201c\u4e66\u540d'); 3\u3001\u53d6\u5f97\u8282\u70b9\u7684\u6587\u5b57      String text=node.getText();4\u3001\u53d6\u5f97\u67d0\u8282\u70b9\u4e0b\u6240\u6709\u540d\u4e3a\u201cmember\u201d\u7684\u5b50\u8282\u70b9\uff0c\u5e76\u8fdb\u884c\u904d\u5386. List nodes = rootElm.elements('member');  for (Iterator it = nodes.iterator(); it.hasNext();) {     Element elm = (Element) it.next();    // do something } 5\u3001\u5bf9\u67d0\u8282\u70b9\u4e0b\u7684\u6240\u6709\u5b50\u8282\u70b9\u8fdb\u884c\u904d\u5386.    for(Iterator it=root.elementIterator();it.hasNext();){       Element element = (Element) it.next();       // do something    } 6\u3001\u5728\u67d0\u8282\u70b9\u4e0b\u6dfb\u52a0\u5b50\u8282\u70b9.Element ageElm = newMemberElm.addElement('age'); 7\u3001\u8bbe\u7f6e\u8282\u70b9\u6587\u5b57. element.setText('29'); 8\u3001\u5220\u9664\u67d0\u8282\u70b9.//childElm\u662f\u5f85\u5220\u9664\u7684\u8282\u70b9,parentElm\u662f\u5176\u7236\u8282\u70b9    parentElm.remove(childElm);9\u3001\u6dfb\u52a0\u4e00\u4e2aCDATA\u8282\u70b9.Element contentElm = infoElm.addElement('content');contentElm.addCDATA(diary.getContent()); \u4e8b\u4f8b\uff1a              publicclass GoodWell03 {     publicstaticvoid main(String[] args) throws Exception {              SAXReader sreader = new SAXReader();              Document doc = sreader.read(new File('src//Book.xml'));              Element root = doc.getRootElement();               System.out.println(root.getName());              perse(root);    }        privatestaticvoid perse(Element root) {       atter(root);       for(Iterator<Element> it=root.elementIterator();it.hasNext();){           Element entity=it.next();           if(entity.isTextOnly()){              atter(entity);              System.out.println(entity.getText());//\u904d\u5386\u6240\u6709           }else{              perse(entity);           }       }           }    privatestaticvoid atter(Element root) {       // TODO Auto-generated method stub       for(Iterator<Attribute> it=root.attributeIterator();it.hasNext();){           Attribute entity=it.next();           System.out.println(entity.getName()+'    '+entity.getValue());                  }    }} \u8282\u70b9\u5bf9\u8c61\u5c5e\u6027\uff1a 1\u3001\u53d6\u5f97\u67d0\u8282\u70b9\u4e0b\u7684\u67d0\u5c5e\u6027    Element root=document.getRootElement();        //\u5c5e\u6027\u540dname         Attribute attribute=root.attribute('size');2\u3001\u53d6\u5f97\u5c5e\u6027\u7684\u6587\u5b57    String text=attribute.getText(); 3\u3001\u5220\u9664\u67d0\u5c5e\u6027 Attribute attribute=root.attribute('size'); root.remove(attribute);.\u904d\u5386\u67d0\u8282\u70b9\u7684\u6240\u6709\u5c5e\u6027   Element root=document.getRootElement();      for(Iterator it=root.attributeIterator();it.hasNext();){         Attribute attribute = (Attribute) it.next();         String text=attribute.getText();         System.out.println(text);    } 4\u3001\u8bbe\u7f6e\u67d0\u8282\u70b9\u7684\u5c5e\u6027\u548c\u6587\u5b57.   newMemberElm.addAttribute('name', 'sitinspring'); 5\u3001\u8bbe\u7f6e\u5c5e\u6027\u7684\u6587\u5b57   Attribute attribute=root.attribute('name');   attribute.setText('sitinspring');       \u5c06\u6587\u6863\u5199\u5165xml\u6587\u4ef61\u3001\u6587\u6863\u4e2d\u5168\u4e3a\u82f1\u6587,\u4e0d\u8bbe\u7f6e\u7f16\u7801,\u76f4\u63a5\u5199\u5165\u7684\u5f62\u5f0f. XMLWriter writer = new XMLWriter(new FileWriter('output.xml')); writer.write(document); writer.close(); 2\u3001\u6587\u6863\u4e2d\u542b\u6709\u4e2d\u6587,\u8bbe\u7f6e\u7f16\u7801\u683c\u5f0f\u5199\u5165\u7684\u5f62\u5f0f.OutputFormat format = OutputFormat.createPrettyPrint();// \u6307\u5b9aXML\u7f16\u7801                  format.setEncoding('GBK');       XMLWriter writer = new XMLWriter(newFileWriter('output.xml'),format);writer.write(document);writer.close(); \u4e8b\u4f8b\uff1a              Document doc=DocumentHelper.createDocument();              Element root=doc.addElement('books');              Element book=root.addElement('book');              book.addAttribute('isbn', '112');              Element name=book.addElement('name');              name.setText('java');              Element author=book.addElement('author');              author.setText('goodwell');              Element price=book.addElement('price');              price.setText('112');              OutputFormat format=new OutputFormat('    ',true,'UTF-8');       XMLWriter xw=new XMLWriter(new FileWriter('src//bk.xml'),format);              xw.write(doc);          xw.close(); dom4j\u5728\u6307\u5b9a\u4f4d\u7f6e\u63d2\u5165\u8282\u70b9\uff1a       1.\u5f97\u5230\u63d2\u5165\u4f4d\u7f6e\u7684\u8282\u70b9\u5217\u8868\uff08list\uff092.\u8c03\u7528list.add(index,elemnent)\uff0c\u7531index\u51b3\u5b9aelement\u7684\u63d2\u5165\u4f4d\u7f6e\u3002Element\u5143\u7d20\u53ef\u4ee5\u901a\u8fc7DocumentHelper\u5bf9\u8c61\u5f97\u5230\u3002\u793a\u4f8b\u4ee3\u7801\uff1aElement aaa = DocumentHelper.createElement('aaa');aaa.setText('aaa');List list = root.element('\u4e66').elements();list.add(1, aaa);//\u66f4\u65b0document                     SAXReader reader=new SAXReader();              Document doc=reader.read(new File('src//bk.xml'));              Element root=doc.getRootElement();              Element address=DocumentHelper.createElement('address');              address.setText('\u4fdd\u5b9a');              Element el= (Element) root.elements('book').get(1);              List list1=el.elements();              list1.add(2, address);              //\u5220\u9664\u7b2c\u4e8c\u4e2abook\u4e2d\u7684\u5730\u5740              Element element=(Element) root.elements('book').get(1);              Element el=element.element('address');              element.remove(el);              OutputFormat format=new OutputFormat('    ',true,'UTF-8');              XMLWriter xw=new XMLWriter(new FileWriter('src//bk.xml'),format);              xw.write(doc);              xw.close(); ' 6302866, 2, 44, '2011-3-16 21:07:00', 'JavaScript\u4e0eDOM\u4e00\u3001\u4ec0\u4e48\u662fDOM DOM\uff08Document Object Model\uff09\uff0c\u6587\u6863\u5bf9\u8c61\u6a21\u578b\uff0cDOM\u53ef\u4ee5\u4ee5\u4e00\u79cd\u72ec\u7acb\u4e8e\u5e73\u53f0\u548c\u8bed\u8a00\u7684\u65b9\u5f0f\u8bbf\u95ee\u548c\u4fee\u6539\u4e00\u4e2a\u6587\u6863\u7684\u5185\u5bb9\u548c\u7ed3\u6784\u3002\u6362\u53e5\u8bdd\u8bf4\uff0c\u8fd9\u662f\u8868\u793a\u548c\u5904\u7406\u4e00\u4e2aHTML\u6216XML\u6587\u6863\u7684\u5e38\u7528\u65b9\u6cd5\u3002\u6709\u4e00\u70b9\u5f88\u91cd\u8981\uff0cDOM\u7684\u8bbe\u8ba1\u662f\u4ee5\u5bf9\u8c61\u7ba1\u7406\u7ec4\u7ec7\uff08OMG\uff09\u7684\u89c4\u7ea6\u4e3a\u57fa\u7840\u7684\uff0c\u56e0\u6b64\u53ef\u4ee5\u7528\u4e8e\u4efb\u4f55\u7f16\u7a0b\u8bed\u8a00.\u4e8c\u3001DOM\u6811DOM\u6811\u987e\u540d\u601d\u4e49\u5c31\u50cf\u6811\u4e00\u6837\uff0c\u6709\u4e00\u4e2a\u4e3b\u5e72\u6d3e\u751f\u51fa\u5f88\u591a\u7684\u679d\u5e72\u3002DOM\u6811\u7684\u6839\u7edf\u4e00\u4e3a\u6587\u6863\u5bf9\u8c61\u2014document\uff0cDOM\u65e2\u7136\u662f\u6811\u72b6\u7ed3\u6784\uff0c\u90a3\u4e48\u5b83\u4eec\u81ea\u7136\u6709\u5982\u4e0b\u7684\u51e0\u79cd\u5173\u7cfb: \u6839\u7ed3\u70b9(document)   \u7236\u7ed3\u70b9(parentNode) \u5b50\u7ed3\u70b9(childNodes) \u5144\u5f1f\u7ed3\u70b9   \u5144\u5f1f\u7ed3\u70b9       (sibling)   (sibling)\u3002\u6211\u4eec\u518d\u6765\u770b\u4e00\u4e0bkHTML\u7684\u7ed3\u6784\uff1a<html> <head> <title> </title></head> <body></body></html>\u6211\u4eec\u53c2\u7167\u6811\u7684\u6982\u5ff5\uff0c\u753b\u51fa\u8be5HTML\u6587\u6863\u7ed3\u6784\u7684DOM\u6811\uff1a            html        body  head         div        title         \u6587\u672c        \u6587\u672c \u4ece\u4e0a\u9762\u7684\u56fe\u793a\u53ef\u4ee5\u770b\u51fa html\u6709\u4e24\u4e2a\u5b50\u7ed3\u70b9\uff0c\u800chtml\u5c31\u662f\u8fd9\u4e24\u4e2a\u5b50\u8282\u70b9\u7684\u7236\u7ed3\u70b9 head\u6709\u8282\u70b9title\uff0ctitle\u4e0b\u6709\u4e00\u4e2a\u6587\u672c\u8282\u70b9 body\u4e0b\u6709\u8282\u70b9div\uff0cdiv\u4e0b\u6709\u4e00\u4e2a\u6587\u672c\u8282\u70b9\u4e09\u3001\u64cd\u4f5cDOM\u6811\u8be6\u7ec6\u4ee3\u7801\u5982\u4e0b\uff1a<html>  <head>    <title>Dom.html</title><script type='text/javascript'>window.onload = function(){ //\u901a\u8fc7docuemnt.documentElement\u83b7\u53d6\u6839\u8282\u70b9 ==>html var zhwHtml = document.documentElement; //\u6253\u5370\u8282\u70b9\u540d\u79f0 HTML \u5927\u5199 alert(zhwHtml.nodeName); //\u83b7\u53d6body\u6807\u7b7e\u8282\u70b9 var zhwBody = document.body; //\u6253\u5370BODY\u8282\u70b9\u7684\u540d\u79f0 alert(zhwBody.nodeName); //\u83b7\u53d6body\u7684\u7b2c\u4e00\u4e2a\u5b50\u8282\u70b9 var fH = zhwBody.firstChild; alert(fH+'body\u7684\u7b2c\u4e00\u4e2a\u5b50\u8282\u70b9'); //\u83b7\u53d6body\u7684\u6700\u540e\u4e00\u4e2a\u5b50\u8282\u70b9 var lH = zhwBody.lastChild; alert(lH+'body\u7684\u6700\u540e\u4e00\u4e2a\u5b50\u8282\u70b9'); //\u901a\u8fc7id\u83b7\u53d6<h1> var ht = document.getElementById('zhw'); alert(ht.nodeName); var text = ht.childNodes; alert(text.length); var txt = ht.firstChild; alert(txt.nodeName); alert(txt.nodeValue); alert(ht.innerHTML); alert(ht.innerText+'Text'); }</script>  </head>    <body>    <h1 id='zhw'>\u4f60\u597d</h1>  </body></html>\u6b22\u8fce\u6765\u8bbf\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u7559\u8a00\u3002'";
        LearnTool learn = new LearnTool();
        List<Term> paser = NlpAnalysis.parse(StringUtil.rmHtmlTag((String)content), learn);
        List<Map.Entry<String, Double>> topTree = learn.getTopTree(100);
        System.out.println(topTree);
        System.out.println(paser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        BufferedReader filter = null;
        try {
            filter = DicReader.getReader("newWord/newWordFilter.dic");
            String temp = null;
            while ((temp = filter.readLine()) != null) {
                hs.add(temp.toLowerCase());
            }
            hs.add("\uff0d");
            hs.add("\u3000");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (filter != null) {
                try {
                    filter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

