/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.newWord;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import love.cq.domain.SmartForest;
import love.cq.util.CollectionUtil;
import org.ansj.app.newWord.NewWordDetection;
import org.ansj.app.newWord.PatHashMap;
import org.ansj.domain.NewWord;
import org.ansj.domain.TermNatures;
import org.ansj.recognition.AsianPersonRecognition;
import org.ansj.recognition.CompanyRecogntion;
import org.ansj.recognition.ForeignPersonRecognition;
import org.ansj.util.Graph;

public class LearnTool {
    public boolean isCompany = true;
    public boolean isNewWord = true;
    public boolean isAsianName = true;
    public boolean isForeignName = true;
    public int count;
    private final SmartForest<NewWord> sf = new SmartForest();

    public void learn(Graph graph) {
        if (this.isCompany) {
            this.findCompany(graph);
        }
        if (this.isAsianName) {
            this.findAsianPerson(graph);
        }
        if (this.isForeignName) {
            this.findForeignPerson(graph);
        }
        if (this.isNewWord) {
            this.newWordDetection(graph);
        }
    }

    private void findAsianPerson(Graph graph) {
        List<NewWord> newWords = new AsianPersonRecognition(graph.terms).getNewWords();
        this.addListToTerm(newWords);
    }

    private void findForeignPerson(Graph graph) {
        List<NewWord> newWords = new ForeignPersonRecognition(graph.terms).getNewWords();
        this.addListToTerm(newWords);
    }

    private void findCompany(Graph graph) {
        List<NewWord> newWords = new CompanyRecogntion(graph.terms).getNewWords();
        this.addListToTerm(newWords);
    }

    private void addListToTerm(List<NewWord> newWords) {
        if (newWords.size() == 0) {
            return;
        }
        for (NewWord newWord : newWords) {
            this.addTerm(newWord);
        }
    }

    private void newWordDetection(Graph graph) {
        Collection<PatHashMap.Node> newWords = null;
        try {
            newWords = new NewWordDetection().getNewWords(graph);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (newWords == null) {
            return;
        }
        NewWord newWord = null;
        for (PatHashMap.Node node : newWords) {
            newWord = new NewWord(node.getName(), TermNatures.NW, node.getScore(), node.getFreq());
            this.addTerm(newWord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTerm(NewWord newWord) {
        NewWord temp = null;
        SmartForest smartForest = null;
        smartForest = this.sf.getBranch(newWord.getName());
        if (smartForest != null && smartForest.getParam() != null) {
            temp = (NewWord)smartForest.getParam();
            temp.update(newWord.getScore(), newWord.getNature(), newWord.getAllFreq());
        } else {
            ++this.count;
            SmartForest<NewWord> smartForest2 = this.sf;
            synchronized (smartForest2) {
                this.sf.add(newWord.getName(), (Object)newWord);
            }
        }
    }

    public SmartForest<NewWord> getForest() {
        return this.sf;
    }

    public List<Map.Entry<String, Double>> getTopTree(int num) {
        return this.getTopTree(num, null);
    }

    public List<Map.Entry<String, Double>> getTopTree(int num, TermNatures nature) {
        if (this.sf.branches == null) {
            return null;
        }
        HashMap<String, Double> hm = new HashMap<String, Double>();
        for (int i = 0; i < this.sf.branches.length; ++i) {
            this.valueResult((SmartForest<NewWord>)this.sf.branches[i], hm, nature);
        }
        List sortMapByValue = CollectionUtil.sortMapByValue(hm, (int)-1);
        if (num == 0) {
            return sortMapByValue;
        }
        num = Math.min(num, sortMapByValue.size());
        return sortMapByValue.subList(0, num);
    }

    private void valueResult(SmartForest<NewWord> smartForest, HashMap<String, Double> hm, TermNatures nature) {
        for (int i = 0; i < smartForest.branches.length; ++i) {
            NewWord param = (NewWord)smartForest.branches[i].getParam();
            if (smartForest.branches[i].getStatus() == 3) {
                if (nature != null && !param.getNature().equals(nature)) continue;
                hm.put(param.getName(), param.getScore());
                continue;
            }
            if (smartForest.branches[i].getStatus() == 2) {
                if (nature == null || param.getNature().equals(nature)) {
                    hm.put(param.getName(), param.getScore());
                }
                this.valueResult((SmartForest<NewWord>)smartForest.branches[i], hm, nature);
                continue;
            }
            this.valueResult((SmartForest<NewWord>)smartForest.branches[i], hm, nature);
        }
    }
}

