/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.keyword;

public class Keyword
implements Comparable<Keyword> {
    private String name;
    private double score;
    private double idf;
    private int freq;

    public Keyword(String name, int docFreq, int weight) {
        this.name = name;
        this.idf = Math.log(10000.0 + 10000.0 / (double)(docFreq + 1));
        this.score = this.idf * (double)weight;
        ++this.freq;
    }

    public void updateWeight(int weight) {
        this.score += (double)weight * this.idf;
        ++this.freq;
    }

    public int getFreq() {
        return this.freq;
    }

    @Override
    public int compareTo(Keyword o) {
        if (this.score < o.score) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Keyword) {
            Keyword k = (Keyword)obj;
            return k.name.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

