/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.keyword;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.ansj.app.keyword.Keyword;
import org.ansj.app.newWord.LearnTool;
import org.ansj.domain.Term;
import org.ansj.splitWord.analysis.NlpAnalysis;

public class KeyWordComputer {
    private int nKeyword = 5;

    public KeyWordComputer() {
        this.nKeyword = 5;
    }

    public KeyWordComputer(int nKeyword) {
        this.nKeyword = nKeyword;
    }

    private List<Keyword> computeArticleTfidf(String content, int titleLength) {
        HashMap<String, Keyword> tm = new HashMap<String, Keyword>();
        LearnTool learn = new LearnTool();
        List<Term> parse = NlpAnalysis.parse(content, learn);
        parse = NlpAnalysis.parse(content, learn);
        for (Term term : parse) {
            int weight = this.getWeight(term, content.length(), titleLength);
            if (weight == 0) continue;
            Keyword keyword = (Keyword)tm.get(term.getName());
            if (keyword == null) {
                keyword = new Keyword(term.getName(), term.getNatrue().allFrequency, weight);
                tm.put(term.getName(), keyword);
                continue;
            }
            keyword.updateWeight(1);
        }
        TreeSet treeSet = new TreeSet(tm.values());
        ArrayList<Keyword> arrayList = new ArrayList<Keyword>(treeSet);
        if (treeSet.size() < this.nKeyword) {
            return arrayList;
        }
        return arrayList.subList(0, this.nKeyword);
    }

    public Collection<Keyword> computeArticleTfidf(String title, String content) {
        return this.computeArticleTfidf(title + "\t" + content, title.length());
    }

    public Collection<Keyword> computeArticleTfidf(String content) {
        return this.computeArticleTfidf(content, 30);
    }

    private int getWeight(Term term, int length, int titleLength) {
        if (term.getName().matches("(?s)\\d.*")) {
            return 0;
        }
        if (term.getName().trim().length() < 2) {
            return 0;
        }
        String pos = term.getNatrue().natureStr;
        if (!pos.startsWith("n") || "num".equals(pos)) {
            return 0;
        }
        int weight = 0;
        if (titleLength > term.getOffe()) {
            return 20;
        }
        double position = ((double)term.getOffe() + 0.0) / (double)length;
        if (position < 0.05) {
            return 10;
        }
        weight = (int)((double)weight + (5.0 - 5.0 * position));
        return weight;
    }
}

