/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.json;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.ext.com.google.common.collect.Sets;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.vocabulary.RDF;

public class SparqlBasedJsonLdFramer {
    public static final Node JSON_ROOT = NodeFactory.createURI((String)"http://www.w3.org/2001/XMLSchema#JsonRoot");

    public Set<Node> findRoots(Collection<Triple> triples) {
        Set subjects = triples.stream().map(Triple::getSubject).collect(Collectors.toSet());
        Set objects = triples.stream().map(Triple::getObject).collect(Collectors.toSet());
        Sets.SetView result = Sets.difference(subjects, objects);
        return result;
    }

    public Set<Node> findDesignatedRoots(Collection<Triple> triples) {
        LinkedHashSet<Node> result = new LinkedHashSet<Node>();
        for (Triple triple : triples) {
            if (!RDF.type.asNode().equals((Object)triple.getPredicate()) || !JSON_ROOT.equals((Object)triple.getObject())) continue;
            result.add(triple.getSubject());
        }
        return result;
    }

    public Set<Node> findRoots(Stream<Triple> triples) {
        Set subjects = triples.map(Triple::getSubject).collect(Collectors.toSet());
        Set objects = triples.map(Triple::getObject).collect(Collectors.toSet());
        Sets.SetView result = Sets.difference(subjects, objects);
        return result;
    }
}

