/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.RepositoryService;
import org.activiti.spring.resources.ResourceReader;

public class DeploymentResourceLoader<T> {
    private RepositoryService repositoryService;
    private Map<String, List<T>> loadedResources = new HashMap<String, List<T>>();

    public List<T> loadResourcesForDeployment(String deploymentId, ResourceReader<T> resourceLoaderDescriptor) {
        List<T> resources = this.loadedResources.get(deploymentId);
        if (resources != null) {
            return resources;
        }
        List resourceNames = this.repositoryService.getDeploymentResourceNames(deploymentId);
        if (resourceNames != null && !resourceNames.isEmpty()) {
            List<String> selectedResources = resourceNames.stream().filter(resourceLoaderDescriptor.getResourceNameSelector()).collect(Collectors.toList());
            resources = this.loadResources(deploymentId, resourceLoaderDescriptor, selectedResources);
        } else {
            resources = new ArrayList<T>();
        }
        this.loadedResources.put(deploymentId, resources);
        return resources;
    }

    private List<T> loadResources(String deploymentId, ResourceReader<T> resourceReader, List<String> selectedResources) {
        ArrayList<Object> resources = new ArrayList<Object>();
        for (String name : selectedResources) {
            try {
                InputStream resourceAsStream = this.repositoryService.getResourceAsStream(deploymentId, name);
                try {
                    Object resource = resourceReader.read(resourceAsStream);
                    if (resource == null) continue;
                    resources.add(resource);
                }
                finally {
                    if (resourceAsStream == null) continue;
                    resourceAsStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read process extension", e);
            }
        }
        return resources;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

