/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.spring.process.ProcessExtensionResourceReader;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.resources.DeploymentResourceLoader;
import org.activiti.spring.resources.ResourceReader;

public class ProcessExtensionService {
    private DeploymentResourceLoader<ProcessExtensionModel> processExtensionLoader;
    private ProcessExtensionResourceReader processExtensionReader;
    private RepositoryService repositoryService;
    private static final ProcessExtensionModel EMPTY_EXTENSIONS = new ProcessExtensionModel();
    private Map<String, Map<String, ProcessExtensionModel>> processExtensionModelDeploymentMap = new HashMap<String, Map<String, ProcessExtensionModel>>();

    public ProcessExtensionService(DeploymentResourceLoader<ProcessExtensionModel> processExtensionLoader, ProcessExtensionResourceReader processExtensionReader) {
        this.processExtensionLoader = processExtensionLoader;
        this.processExtensionReader = processExtensionReader;
    }

    private Map<String, ProcessExtensionModel> getProcessExtensionsForDeploymentId(String deploymentId) {
        Map<String, ProcessExtensionModel> processExtensionModelMap = this.processExtensionModelDeploymentMap.get(deploymentId);
        if (processExtensionModelMap != null) {
            return processExtensionModelMap;
        }
        List processExtensionModels = this.processExtensionLoader.loadResourcesForDeployment(deploymentId, (ResourceReader)this.processExtensionReader);
        processExtensionModelMap = processExtensionModels.stream().collect(Collectors.toMap(ProcessExtensionModel::getId, Function.identity()));
        this.processExtensionModelDeploymentMap.put(deploymentId, processExtensionModelMap);
        return processExtensionModelMap;
    }

    public boolean hasExtensionsFor(ProcessDefinition processDefinition) {
        return !EMPTY_EXTENSIONS.equals(this.getExtensionsFor(processDefinition));
    }

    public boolean hasExtensionsFor(String processDefinitionId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processDefinitionId);
        return this.hasExtensionsFor(processDefinition);
    }

    public ProcessExtensionModel getExtensionsFor(ProcessDefinition processDefinition) {
        ProcessExtensionModel processExtensionModel = null;
        Map<String, ProcessExtensionModel> processExtensionModelMap = this.getProcessExtensionsForDeploymentId(processDefinition.getDeploymentId());
        if (processExtensionModelMap != null) {
            processExtensionModel = processExtensionModelMap.get(processDefinition.getKey());
        }
        return processExtensionModel != null ? processExtensionModel : EMPTY_EXTENSIONS;
    }

    public ProcessExtensionModel getExtensionsForId(String processDefinitionId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processDefinitionId);
        ProcessExtensionModel processExtensionModel = this.getExtensionsFor(processDefinition);
        return processExtensionModel != null ? processExtensionModel : EMPTY_EXTENSIONS;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

