/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Predicate;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.process.model.VariableDefinition;
import org.activiti.spring.process.variable.types.VariableType;
import org.activiti.spring.resources.ResourceReader;

public class ProcessExtensionResourceReader
implements ResourceReader<ProcessExtensionModel> {
    private final ObjectMapper objectMapper;
    private final Map<String, VariableType> variableTypeMap;

    public ProcessExtensionResourceReader(ObjectMapper objectMapper, Map<String, VariableType> variableTypeMap) {
        this.objectMapper = objectMapper;
        this.variableTypeMap = variableTypeMap;
    }

    public Predicate<String> getResourceNameSelector() {
        return resourceName -> resourceName.endsWith("-extensions.json");
    }

    public ProcessExtensionModel read(InputStream inputStream) throws IOException {
        this.objectMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        ProcessExtensionModel mappedModel = (ProcessExtensionModel)this.objectMapper.readValue(inputStream, ProcessExtensionModel.class);
        return this.convertJsonVariables(mappedModel);
    }

    private ProcessExtensionModel convertJsonVariables(ProcessExtensionModel processExtensionModel) {
        if (processExtensionModel != null && processExtensionModel.getExtensions() != null && processExtensionModel.getExtensions().getProperties() != null) {
            for (VariableDefinition variableDefinition : processExtensionModel.getExtensions().getProperties().values()) {
                if (this.variableTypeMap.keySet().contains(variableDefinition.getType()) && !variableDefinition.getType().equals("json")) continue;
                variableDefinition.setValue(this.objectMapper.convertValue(variableDefinition.getValue(), JsonNode.class));
            }
        }
        return processExtensionModel;
    }
}

