/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import java.util.ArrayList;
import java.util.List;
import org.activiti.spring.resources.ResourceFinderDescriptor;
import org.springframework.core.io.Resource;

public class ProcessExtensionResourceFinderDescriptor
implements ResourceFinderDescriptor {
    private boolean checkResources;
    private String locationPrefix;
    private List<String> locationSuffixes;

    public ProcessExtensionResourceFinderDescriptor(boolean checkResources, String locationPrefix, String locationSuffix) {
        this.checkResources = checkResources;
        this.locationPrefix = locationPrefix;
        this.locationSuffixes = new ArrayList<String>();
        this.locationSuffixes.add(locationSuffix);
    }

    public List<String> getLocationSuffixes() {
        return this.locationSuffixes;
    }

    public String getLocationPrefix() {
        return this.locationPrefix;
    }

    public boolean shouldLookUpResources() {
        return this.checkResources;
    }

    public String getMsgForEmptyResources() {
        return "No process extensions were found for auto-deployment in the location '" + this.locationPrefix + "'";
    }

    public String getMsgForResourcesFound(List<String> processExtensionFiles) {
        return "The following process extension files will be deployed: " + processExtensionFiles;
    }

    public void validate(List<Resource> resources) {
    }
}

