/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.deploy;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.activiti.engine.impl.persistence.deploy.DefaultDeploymentCache;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class MultiSchemaMultiTenantProcessDefinitionCache
implements DeploymentCache<ProcessDefinitionEntity> {
    protected TenantInfoHolder tenantInfoHolder;
    protected int cacheLimit;
    protected Map<String, DeploymentCache<ProcessDefinitionEntity>> caches = new HashMap<String, DeploymentCache<ProcessDefinitionEntity>>();

    public MultiSchemaMultiTenantProcessDefinitionCache(TenantInfoHolder tenantInfoHolder, int cacheLimit) {
        this.tenantInfoHolder = tenantInfoHolder;
        this.cacheLimit = cacheLimit;
    }

    protected DeploymentCache<ProcessDefinitionEntity> getDeploymentCacheForCurrentTenant() {
        String currentTenantId = this.tenantInfoHolder.getCurrentTenantId();
        DeploymentCache<ProcessDefinitionEntity> tenantDeploymentCache = this.caches.get(currentTenantId);
        if (tenantDeploymentCache == null) {
            tenantDeploymentCache = this.createTenantDeploymentCache(currentTenantId);
        }
        return tenantDeploymentCache;
    }

    protected synchronized DeploymentCache<ProcessDefinitionEntity> createTenantDeploymentCache(String currentTenantId) {
        DeploymentCache<ProcessDefinitionEntity> tenantDeploymentCache = this.caches.get(currentTenantId);
        if (tenantDeploymentCache == null) {
            tenantDeploymentCache = new DefaultDeploymentCache<ProcessDefinitionEntity>(this.cacheLimit);
            this.caches.put(currentTenantId, tenantDeploymentCache);
        }
        return tenantDeploymentCache;
    }

    @Override
    public ProcessDefinitionEntity get(String id) {
        return this.getDeploymentCacheForCurrentTenant().get(id);
    }

    @Override
    public void add(String id, ProcessDefinitionEntity object) {
        DeploymentCache<ProcessDefinitionEntity> tenantDeploymentCache = this.getDeploymentCacheForCurrentTenant();
        tenantDeploymentCache.add(id, object);
        System.out.println("AAP");
    }

    @Override
    public void remove(String id) {
        this.getDeploymentCacheForCurrentTenant().remove(id);
    }

    @Override
    public void clear() {
        this.getDeploymentCacheForCurrentTenant().clear();
    }
}

