/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.db;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.service.BpmActivityLockingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiWrongDbException;
import org.activiti.engine.impl.DeploymentQueryImpl;
import org.activiti.engine.impl.ExecutionQueryImpl;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.HistoricDetailQueryImpl;
import org.activiti.engine.impl.HistoricProcessInstanceQueryImpl;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.HistoricVariableInstanceQueryImpl;
import org.activiti.engine.impl.JobQueryImpl;
import org.activiti.engine.impl.ModelQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti.engine.impl.ProcessInstanceQueryImpl;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.ActivitiVersion;
import org.activiti.engine.impl.db.DbSqlSessionFactory;
import org.activiti.engine.impl.db.EntityDependencyOrder;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.ListQueryParameterObject;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.db.upgrade.DbUpgradeStep;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.PropertyEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.variable.DeserializedObject;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSqlSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(DbSqlSession.class);
    protected static final Pattern CLEAN_VERSION_REGEX = Pattern.compile("\\d\\.\\d*");
    protected static final List<ActivitiVersion> ACTIVITI_VERSIONS = new ArrayList<ActivitiVersion>();
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected Map<Class<? extends PersistentObject>, List<PersistentObject>> insertedObjects = new HashMap<Class<? extends PersistentObject>, List<PersistentObject>>();
    protected Map<Class<?>, Map<String, CachedObject>> cachedObjects = new HashMap();
    protected List<DeleteOperation> deleteOperations = new ArrayList<DeleteOperation>();
    protected List<DeserializedObject> deserializedObjects = new ArrayList<DeserializedObject>();
    protected String connectionMetadataDefaultCatalog;
    protected String connectionMetadataDefaultSchema;
    public static String[] JDBC_METADATA_TABLE_TYPES;

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    public void insert(PersistentObject persistentObject) {
        Class<?> clazz;
        if (persistentObject.getId() == null) {
            String id = this.dbSqlSessionFactory.getIdGenerator().getNextId();
            persistentObject.setId(id);
        }
        if (!this.insertedObjects.containsKey(clazz = persistentObject.getClass())) {
            this.insertedObjects.put(clazz, new ArrayList());
        }
        this.insertedObjects.get(clazz).add(persistentObject);
        this.cachePut(persistentObject, false);
    }

    public void update(PersistentObject persistentObject) {
        this.cachePut(persistentObject, false);
    }

    public int update(String statement, Object parameters) {
        String updateStatement = this.dbSqlSessionFactory.mapStatement(statement);
        return this.getSqlSession().update(updateStatement, parameters);
    }

    public void delete(String statement, Object parameter) {
        this.deleteOperations.add(new BulkDeleteOperation(statement, parameter));
    }

    public void delete(PersistentObject persistentObject) {
        for (DeleteOperation deleteOperation : this.deleteOperations) {
            if (!deleteOperation.sameIdentity(persistentObject)) continue;
            log.debug("skipping redundant delete: {}", (Object)persistentObject);
            return;
        }
        this.deleteOperations.add(new CheckedDeleteOperation(persistentObject));
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter, Page page) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults());
        }
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, Page page) {
        if (page != null) {
            parameter.setFirstResult(page.getFirstResult());
            parameter.setMaxResults(page.getMaxResults());
        }
        return this.selectList(statement, parameter);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults));
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        return this.selectListWithRawParameter(statement, parameter, parameter.getFirstResult(), parameter.getMaxResults());
    }

    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        Context.getCommandContext().addAttribute("ACTIVITI_DB_SQL_SESSION_SELECT_LIST_TAG", "true");
        List loadedObjects = this.sqlSession.selectList(statement, parameter);
        Context.getCommandContext().removeAttribute("ACTIVITI_DB_SQL_SESSION_SELECT_LIST_TAG");
        return this.filterLoadedObjects(loadedObjects);
    }

    public List selectListWithRawParameterWithoutFilter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        return this.sqlSession.selectList(statement, parameter);
    }

    public Object selectOne(String statement, Object parameter) {
        Object result = this.sqlSession.selectOne(statement = this.dbSqlSessionFactory.mapStatement(statement), parameter);
        if (result instanceof PersistentObject) {
            PersistentObject loadedObject = (PersistentObject)result;
            result = this.cacheFilter(loadedObject);
        }
        return result;
    }

    public <T extends PersistentObject> T selectById(Class<T> entityClass, String id) {
        PersistentObject persistentObject = (PersistentObject)this.cacheGet(entityClass, id);
        if (persistentObject != null) {
            return (T)persistentObject;
        }
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(entityClass);
        persistentObject = (PersistentObject)this.sqlSession.selectOne(selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement), (Object)id);
        if (persistentObject == null) {
            return null;
        }
        this.cachePut(persistentObject, true);
        return (T)persistentObject;
    }

    protected List filterLoadedObjects(List<Object> loadedObjects) {
        if (loadedObjects.isEmpty()) {
            return loadedObjects;
        }
        if (!(loadedObjects.get(0) instanceof PersistentObject)) {
            return loadedObjects;
        }
        ArrayList<PersistentObject> filteredObjects = new ArrayList<PersistentObject>(loadedObjects.size());
        for (Object loadedObject : loadedObjects) {
            PersistentObject cachedPersistentObject = this.cacheFilter((PersistentObject)loadedObject);
            filteredObjects.add(cachedPersistentObject);
        }
        return filteredObjects;
    }

    protected CachedObject cachePut(PersistentObject persistentObject, boolean storeState) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObject.getClass());
        if (classCache == null) {
            classCache = new HashMap<String, CachedObject>();
            this.cachedObjects.put(persistentObject.getClass(), classCache);
        }
        CachedObject cachedObject = new CachedObject(persistentObject, storeState);
        classCache.put(persistentObject.getId(), cachedObject);
        return cachedObject;
    }

    protected PersistentObject cacheFilter(PersistentObject persistentObject) {
        PersistentObject cachedPersistentObject = (PersistentObject)this.cacheGet(persistentObject.getClass(), persistentObject.getId());
        if (cachedPersistentObject != null) {
            return cachedPersistentObject;
        }
        this.cachePut(persistentObject, true);
        return persistentObject;
    }

    protected <T> T cacheGet(Class<T> entityClass, String id) {
        CachedObject cachedObject = null;
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            cachedObject = classCache.get(id);
        }
        if (cachedObject != null) {
            return (T)cachedObject.getPersistentObject();
        }
        return null;
    }

    protected void cacheRemove(Class<?> persistentObjectClass, String persistentObjectId) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObjectClass);
        if (classCache == null) {
            return;
        }
        classCache.remove(persistentObjectId);
    }

    public <T> List<T> findInCache(Class<T> entityClass) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            ArrayList<PersistentObject> entities = new ArrayList<PersistentObject>(classCache.size());
            for (CachedObject cachedObject : classCache.values()) {
                entities.add(cachedObject.getPersistentObject());
            }
            return entities;
        }
        return Collections.emptyList();
    }

    public <T> List<T> findAliveEntityInCache(Class<T> entityClass) {
        Map<String, CachedObject> cachedObject = this.cachedObjects.get(entityClass);
        if (cachedObject == null) {
            return new ArrayList();
        }
        ArrayList<PersistentObject> classCache = new ArrayList<PersistentObject>();
        for (CachedObject object : cachedObject.values()) {
            classCache.add(object.getPersistentObject());
        }
        ArrayList<PersistentObject> removePersistentObjects = new ArrayList<PersistentObject>();
        block1: for (DeleteOperation deleteOperation : this.deleteOperations) {
            Class<? extends PersistentObject> deletedPersistentObjectClass = deleteOperation.getPersistentObjectClass();
            if (entityClass != deletedPersistentObjectClass) continue;
            for (PersistentObject persistentObject : classCache) {
                if (!deleteOperation.sameIdentity(persistentObject)) continue;
                removePersistentObjects.add(persistentObject);
                continue block1;
            }
        }
        classCache.removeAll(removePersistentObjects);
        return classCache;
    }

    public <T> List<T> findAddEntityInCache(Class<T> entityClass) {
        List<PersistentObject> addList = this.insertedObjects.get(entityClass);
        if (addList == null) {
            return new ArrayList();
        }
        ArrayList<PersistentObject> classCache = new ArrayList<PersistentObject>(addList);
        block0: for (DeleteOperation deleteOperation : this.deleteOperations) {
            Class<? extends PersistentObject> deletedPersistentObjectClass = deleteOperation.getPersistentObjectClass();
            if (entityClass != deletedPersistentObjectClass) continue;
            for (PersistentObject persistentObject : this.insertedObjects.get(entityClass)) {
                if (!deleteOperation.sameIdentity(persistentObject)) continue;
                classCache.remove(persistentObject);
                continue block0;
            }
        }
        return classCache;
    }

    public <T> List<T> findUpdateEntityInCache(Class<T> entityClass) {
        ArrayList<PersistentObject> updatedObjects = new ArrayList<PersistentObject>();
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache == null) {
            return new ArrayList();
        }
        List<PersistentObject> insertList = this.insertedObjects.get(entityClass);
        for (CachedObject cachedObject : classCache.values()) {
            PersistentObject persistentObject = cachedObject.getPersistentObject();
            if (this.isPersistentObjectDeleted(persistentObject)) continue;
            Object originalState = cachedObject.getPersistentObjectState();
            if (persistentObject.getPersistentState() != null && !persistentObject.getPersistentState().equals(originalState)) {
                if (!HussarUtils.isEmpty(insertList) && insertList.contains(persistentObject)) continue;
                updatedObjects.add(persistentObject);
                continue;
            }
            log.trace("loaded object '{}' was not updated", (Object)persistentObject);
        }
        return updatedObjects;
    }

    public <T> List<T> findRemoveEntityInCache(Class<T> entityClass) {
        ArrayList<PersistentObject> result = new ArrayList<PersistentObject>();
        block0: for (DeleteOperation deleteOperation : this.deleteOperations) {
            Map<String, CachedObject> classCache;
            Class<? extends PersistentObject> deletedPersistentObjectClass = deleteOperation.getPersistentObjectClass();
            if (entityClass == deletedPersistentObjectClass) {
                boolean isRemoveInsert = false;
                for (PersistentObject persistentObject : (List)this.insertedObjects.getOrDefault(entityClass, new ArrayList())) {
                    if (!deleteOperation.sameIdentity(persistentObject)) continue;
                    isRemoveInsert = true;
                    break;
                }
                if (isRemoveInsert) continue;
            }
            if ((classCache = this.cachedObjects.get(entityClass)) == null) continue;
            for (CachedObject cachedObject : classCache.values()) {
                if (!deleteOperation.sameIdentity(cachedObject.getPersistentObject())) continue;
                result.add(cachedObject.getPersistentObject());
                continue block0;
            }
        }
        return result;
    }

    public <T> List<T> findUpdateIdentityLinkTaskEntityInCache(Class<T> entityClass) {
        HashSet<PersistentObject> updatedObjects = new HashSet<PersistentObject>();
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (HussarUtils.isNotEmpty(classCache)) {
            CachedObject cachedObject;
            List<IdentityLinkEntity> identityLinkEntities = this.findAddEntityInCache(IdentityLinkEntity.class);
            if (identityLinkEntities != null) {
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                    cachedObject = classCache.get(identityLinkEntity.getTaskId());
                    if (cachedObject == null) continue;
                    updatedObjects.add(cachedObject.getPersistentObject());
                }
            }
            if ((identityLinkEntities = this.findUpdateEntityInCache(IdentityLinkEntity.class)) != null) {
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                    cachedObject = classCache.get(identityLinkEntity.getTaskId());
                    if (cachedObject == null) continue;
                    updatedObjects.add(cachedObject.getPersistentObject());
                }
            }
            if ((identityLinkEntities = this.findRemoveEntityInCache(IdentityLinkEntity.class)) != null) {
                for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                    cachedObject = classCache.get(identityLinkEntity.getTaskId());
                    if (cachedObject == null) continue;
                    updatedObjects.add(cachedObject.getPersistentObject());
                }
            }
        }
        return new ArrayList(updatedObjects);
    }

    public <T> T findInCache(Class<T> entityClass, String id) {
        return this.cacheGet(entityClass, id);
    }

    public void addDeserializedObject(DeserializedObject deserializedObject) {
        this.deserializedObjects.add(deserializedObject);
    }

    @Override
    public void flush() {
        List<DeleteOperation> removedOperations = this.removeUnnecessaryOperations();
        this.flushDeserializedObjects();
        List<PersistentObject> updatedObjects = this.getUpdatedObjects();
        if (log.isDebugEnabled()) {
            Collection<List<PersistentObject>> insertedObjectLists = this.insertedObjects.values();
            int nrOfInserts = 0;
            int nrOfUpdates = 0;
            int nrOfDeletes = 0;
            for (List<PersistentObject> insertedObjectList : insertedObjectLists) {
                for (PersistentObject insertedObject : insertedObjectList) {
                    log.debug("  insert {}", (Object)insertedObject);
                    ++nrOfInserts;
                }
            }
            for (PersistentObject updatedObject : updatedObjects) {
                log.debug("  update {}", (Object)updatedObject);
                ++nrOfUpdates;
            }
            for (DeleteOperation deleteOperation : this.deleteOperations) {
                log.debug("  {}", (Object)deleteOperation);
                ++nrOfDeletes;
            }
            log.debug("flush summary: {} insert, {} update, {} delete.", new Object[]{nrOfInserts, nrOfUpdates, nrOfDeletes});
            log.debug("now executing flush...");
        }
        this.flushInserts();
        this.flushUpdates(updatedObjects);
        this.flushDeletes(removedOperations);
    }

    protected List<DeleteOperation> removeUnnecessaryOperations() {
        ArrayList<DeleteOperation> removedDeleteOperations = new ArrayList<DeleteOperation>();
        Iterator<DeleteOperation> deleteIterator = this.deleteOperations.iterator();
        while (deleteIterator.hasNext()) {
            DeleteOperation deleteOperation = deleteIterator.next();
            Class<? extends PersistentObject> deletedPersistentObjectClass = deleteOperation.getPersistentObjectClass();
            List<PersistentObject> insertedObjectsOfSameClass = this.insertedObjects.get(deletedPersistentObjectClass);
            if (insertedObjectsOfSameClass != null && insertedObjectsOfSameClass.size() > 0) {
                Iterator<PersistentObject> insertIterator = insertedObjectsOfSameClass.iterator();
                while (insertIterator.hasNext()) {
                    PersistentObject insertedObject = insertIterator.next();
                    if (!deleteOperation.sameIdentity(insertedObject)) continue;
                    insertIterator.remove();
                    deleteIterator.remove();
                    removedDeleteOperations.add(deleteOperation);
                }
                if (this.insertedObjects.get(deletedPersistentObjectClass).size() == 0) {
                    this.insertedObjects.remove(deletedPersistentObjectClass);
                }
            }
            deleteOperation.clearCache();
        }
        for (Class<? extends PersistentObject> persistentObjectClass : this.insertedObjects.keySet()) {
            for (PersistentObject insertedObject : this.insertedObjects.get(persistentObjectClass)) {
                this.cacheRemove(insertedObject.getClass(), insertedObject.getId());
            }
        }
        return removedDeleteOperations;
    }

    protected void flushDeserializedObjects() {
        for (DeserializedObject deserializedObject : this.deserializedObjects) {
            deserializedObject.flush();
        }
    }

    public List<PersistentObject> getUpdatedObjects() {
        ArrayList<PersistentObject> updatedObjects = new ArrayList<PersistentObject>();
        for (Class<?> clazz : this.cachedObjects.keySet()) {
            Map<String, CachedObject> classCache = this.cachedObjects.get(clazz);
            for (CachedObject cachedObject : classCache.values()) {
                PersistentObject persistentObject = cachedObject.getPersistentObject();
                if (this.isPersistentObjectDeleted(persistentObject)) continue;
                Object originalState = cachedObject.getPersistentObjectState();
                if (persistentObject.getPersistentState() != null && !persistentObject.getPersistentState().equals(originalState)) {
                    updatedObjects.add(persistentObject);
                    continue;
                }
                log.trace("loaded object '{}' was not updated", (Object)persistentObject);
            }
        }
        return updatedObjects;
    }

    protected boolean isPersistentObjectDeleted(PersistentObject persistentObject) {
        for (DeleteOperation deleteOperation : this.deleteOperations) {
            if (!deleteOperation.sameIdentity(persistentObject)) continue;
            return true;
        }
        return false;
    }

    public <T extends PersistentObject> List<T> pruneDeletedEntities(List<T> listToPrune) {
        ArrayList<T> prunedList = new ArrayList<T>(listToPrune);
        for (PersistentObject potentiallyDeleted : listToPrune) {
            for (DeleteOperation deleteOperation : this.deleteOperations) {
                if (!deleteOperation.sameIdentity(potentiallyDeleted)) continue;
                prunedList.remove(potentiallyDeleted);
            }
        }
        return prunedList;
    }

    protected void flushInserts() {
        for (Class<? extends PersistentObject> persistentObjectClass : EntityDependencyOrder.INSERT_ORDER) {
            if (!this.insertedObjects.containsKey(persistentObjectClass)) continue;
            this.flushPersistentObjects(persistentObjectClass, this.insertedObjects.get(persistentObjectClass));
            this.insertedObjects.remove(persistentObjectClass);
        }
        if (this.insertedObjects.size() > 0) {
            for (Class<? extends PersistentObject> persistentObjectClass : this.insertedObjects.keySet()) {
                this.flushPersistentObjects(persistentObjectClass, this.insertedObjects.get(persistentObjectClass));
            }
        }
        this.insertedObjects.clear();
    }

    protected void flushPersistentObjects(Class<? extends PersistentObject> persistentObjectClass, List<PersistentObject> persistentObjectsToInsert) {
        if (persistentObjectsToInsert.size() == 1) {
            this.flushRegularInsert(persistentObjectsToInsert.get(0), persistentObjectClass);
        } else if (Boolean.FALSE.equals(this.dbSqlSessionFactory.isBulkInsertable(persistentObjectClass))) {
            for (PersistentObject persistentObject : persistentObjectsToInsert) {
                this.flushRegularInsert(persistentObject, persistentObjectClass);
            }
        } else {
            this.flushBulkInsert(this.insertedObjects.get(persistentObjectClass), persistentObjectClass);
        }
    }

    protected void flushRegularInsert(PersistentObject persistentObject, Class<? extends PersistentObject> clazz) {
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(persistentObject);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new ActivitiException("no insert statement for " + persistentObject.getClass() + " in the ibatis mapping files");
        }
        log.debug("inserting: {}", (Object)persistentObject);
        this.sqlSession.insert(insertStatement, (Object)persistentObject);
        if (persistentObject instanceof HasRevision) {
            ((HasRevision)((Object)persistentObject)).setRevision(((HasRevision)((Object)persistentObject)).getRevisionNext());
        }
    }

    protected void flushBulkInsert(List<PersistentObject> persistentObjectList, Class<? extends PersistentObject> clazz) {
        String insertStatement = this.dbSqlSessionFactory.getBulkInsertStatement(clazz);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new ActivitiException("no insert statement for " + persistentObjectList.get(0).getClass() + " in the ibatis mapping files");
        }
        if (persistentObjectList.size() <= this.dbSqlSessionFactory.getMaxNrOfStatementsInBulkInsert()) {
            this.sqlSession.insert(insertStatement, persistentObjectList);
        } else {
            for (int start = 0; start < persistentObjectList.size(); start += this.dbSqlSessionFactory.getMaxNrOfStatementsInBulkInsert()) {
                List<PersistentObject> subList = persistentObjectList.subList(start, Math.min(start + this.dbSqlSessionFactory.getMaxNrOfStatementsInBulkInsert(), persistentObjectList.size()));
                this.sqlSession.insert(insertStatement, subList);
            }
        }
        if (persistentObjectList.get(0) instanceof HasRevision) {
            for (PersistentObject insertedObject : persistentObjectList) {
                ((HasRevision)((Object)insertedObject)).setRevision(((HasRevision)((Object)insertedObject)).getRevisionNext());
            }
        }
    }

    protected void flushUpdates(List<PersistentObject> updatedObjects) {
        for (PersistentObject updatedObject : updatedObjects) {
            String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(updatedObject);
            if ((updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement)) == null) {
                throw new ActivitiException("no update statement for " + updatedObject.getClass() + " in the ibatis mapping files");
            }
            log.debug("updating: {}", (Object)updatedObject);
            int updatedRecords = this.sqlSession.update(updateStatement, (Object)updatedObject);
            if (updatedRecords != 1) {
                this.throwBpmActivityLockingException(updatedObject);
            }
            if (!(updatedObject instanceof HasRevision)) continue;
            ((HasRevision)((Object)updatedObject)).setRevision(((HasRevision)((Object)updatedObject)).getRevisionNext());
        }
        updatedObjects.clear();
    }

    protected void flushDeletes(List<DeleteOperation> removedOperations) {
        this.flushRegularDeletes();
        this.deleteOperations.clear();
    }

    protected void flushRegularDeletes() {
        for (DeleteOperation delete : this.deleteOperations) {
            log.debug("executing: {}", (Object)delete);
            delete.execute();
        }
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void rollback() {
        this.sqlSession.rollback();
    }

    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"5.22.0.0".equals(dbVersion)) {
                throw new ActivitiWrongDbException("5.22.0.0", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (this.dbSqlSessionFactory.isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (this.dbSqlSessionFactory.isDbIdentityUsed() && !this.isIdentityTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "identity");
            }
            if (errorMessage != null) {
                throw new ActivitiException("Activiti database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new ActivitiException("no activiti tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in activiti.cfg.xml for automatic schema creation", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ActivitiException("couldn't get db schema version", e);
        }
        log.debug("activiti db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        String selectSchemaVersionStatement = this.dbSqlSessionFactory.mapStatement("selectDbSchemaVersion");
        return (String)this.sqlSession.selectOne(selectSchemaVersionStatement);
    }

    public void dbSchemaCreate() {
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"5.22.0.0".equals(dbVersion)) {
                throw new ActivitiWrongDbException("5.22.0.0", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
    }

    protected void dbSchemaCreateIdentity() {
        this.executeMandatorySchemaResource("create", "identity");
    }

    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    public void dbSchemaDrop() {
        this.executeMandatorySchemaResource("drop", "engine");
        if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void dbSchemaPrune() {
        if (this.isHistoryTablePresent() && !this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.isIdentityTablePresent() && this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void executeMandatorySchemaResource(String operation, String component) {
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component), false);
    }

    public String dbSchemaUpdate() {
        String feedback = null;
        boolean isUpgradeNeeded = false;
        int matchingVersionIndex = -1;
        if (this.isEngineTablePresent()) {
            PropertyEntity dbVersionProperty = this.selectById(PropertyEntity.class, "schema.version");
            String dbVersion = dbVersionProperty.getValue();
            int index = 0;
            while (matchingVersionIndex < 0 && index < ACTIVITI_VERSIONS.size()) {
                if (ACTIVITI_VERSIONS.get(index).matches(dbVersion)) {
                    matchingVersionIndex = index;
                    continue;
                }
                ++index;
            }
            if (matchingVersionIndex < 0) {
                throw new ActivitiException("Could not update Activiti database schema: unknown version from database: '" + dbVersion + "'");
            }
            boolean bl = isUpgradeNeeded = matchingVersionIndex != ACTIVITI_VERSIONS.size() - 1;
            if (isUpgradeNeeded) {
                PropertyEntity dbHistoryProperty;
                dbVersionProperty.setValue("5.22.0.0");
                if ("5.0".equals(dbVersion)) {
                    dbHistoryProperty = new PropertyEntity("schema.history", "create(5.0)");
                    this.insert(dbHistoryProperty);
                } else {
                    dbHistoryProperty = this.selectById(PropertyEntity.class, "schema.history");
                }
                String dbHistoryValue = dbHistoryProperty.getValue() + " upgrade(" + dbVersion + "->" + "5.22.0.0" + ")";
                dbHistoryProperty.setValue(dbHistoryValue);
                this.dbSchemaUpgrade("engine", matchingVersionIndex);
                feedback = "upgraded Activiti from " + dbVersion + " to " + "5.22.0.0";
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (this.isHistoryTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("history", matchingVersionIndex);
            }
        } else if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (this.isIdentityTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("identity", matchingVersionIndex);
            }
        } else if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        return feedback;
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    public boolean isIdentityTablePresent() {
        return this.isTablePresent("ACT_ID_USER");
    }

    public boolean isTablePresent(String tableName) {
        return true;
    }

    protected boolean isUpgradeNeeded(String versionInDatabase) {
        if ("5.22.0.0".equals(versionInDatabase)) {
            return false;
        }
        String cleanDbVersion = this.getCleanVersion(versionInDatabase);
        String[] cleanDbVersionSplitted = cleanDbVersion.split("\\.");
        int dbMajorVersion = Integer.valueOf(cleanDbVersionSplitted[0]);
        int dbMinorVersion = Integer.valueOf(cleanDbVersionSplitted[1]);
        String cleanEngineVersion = this.getCleanVersion("5.22.0.0");
        String[] cleanEngineVersionSplitted = cleanEngineVersion.split("\\.");
        int engineMajorVersion = Integer.valueOf(cleanEngineVersionSplitted[0]);
        int engineMinorVersion = Integer.valueOf(cleanEngineVersionSplitted[1]);
        if (dbMajorVersion > engineMajorVersion || dbMajorVersion <= engineMajorVersion && dbMinorVersion > engineMinorVersion) {
            throw new ActivitiException("Version of activiti database (" + versionInDatabase + ") is more recent than the engine (" + "5.22.0.0" + ")");
        }
        if (cleanDbVersion.compareTo(cleanEngineVersion) == 0) {
            log.warn("Engine-version is the same, but not an exact match: {} vs. {}. Not performing database-upgrade.", (Object)versionInDatabase, (Object)"5.22.0.0");
            return false;
        }
        return true;
    }

    protected String getCleanVersion(String versionString) {
        Matcher matcher = CLEAN_VERSION_REGEX.matcher(versionString);
        if (!matcher.find()) {
            throw new ActivitiException("Illegal format for version: " + versionString);
        }
        String cleanString = matcher.group();
        try {
            Double.parseDouble(cleanString);
            return cleanString;
        }
        catch (NumberFormatException nfe) {
            throw new ActivitiException("Illegal format for version: " + versionString);
        }
    }

    protected String prependDatabaseTablePrefix(String tableName) {
        return this.dbSqlSessionFactory.getDatabaseTablePrefix() + tableName;
    }

    protected void dbSchemaUpgrade(String component, int currentDatabaseVersionsIndex) {
        ActivitiVersion activitiVersion = ACTIVITI_VERSIONS.get(currentDatabaseVersionsIndex);
        String dbVersion = activitiVersion.getMainVersion();
        log.info("upgrading activiti {} schema from {} to {}", new Object[]{component, dbVersion, "5.22.0.0"});
        for (int i = currentDatabaseVersionsIndex + 1; i < ACTIVITI_VERSIONS.size(); ++i) {
            String nextVersion = ACTIVITI_VERSIONS.get(i).getMainVersion();
            if (nextVersion.endsWith("-SNAPSHOT")) {
                nextVersion = nextVersion.substring(0, nextVersion.length() - "-SNAPSHOT".length());
            }
            dbVersion = dbVersion.replace(".", "");
            nextVersion = nextVersion.replace(".", "");
            log.info("Upgrade needed: {} -> {}. Looking for schema update resource for component '{}'", new Object[]{dbVersion, nextVersion, component});
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + dbVersion + ".to." + nextVersion, component), true);
            dbVersion = nextVersion;
        }
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        return "org/activiti/db/" + directory + "/activiti." + databaseType + "." + operation + "." + component + ".sql";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream(resourceName);
            if (inputStream == null) {
                if (!isOptional) throw new ActivitiException("resource '" + resourceName + "' is not available");
                log.info("no schema resource {} for {}", (Object)resourceName, (Object)operation);
                return;
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
            return;
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        log.info("performing {} on {} with resource {}", new Object[]{operation, component, resourceName});
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        try {
            Connection connection = this.sqlSession.getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes);
            String databaseType = this.dbSqlSessionFactory.getDatabaseType();
            try {
                if ("mysql".equals(databaseType)) {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    int majorVersion = databaseMetaData.getDatabaseMajorVersion();
                    int minorVersion = databaseMetaData.getDatabaseMinorVersion();
                    log.info("Found MySQL: majorVersion=" + majorVersion + " minorVersion=" + minorVersion);
                    if (majorVersion <= 5 && minorVersion < 6) {
                        ddlStatements = this.updateDdlForMySqlVersionLowerThan56(ddlStatements);
                    }
                }
            }
            catch (Exception e) {
                log.info("Could not get database metadata", (Throwable)e);
            }
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            boolean inOraclePlsqlBlock = false;
            while (line != null) {
                if (line.startsWith("# ")) {
                    log.debug(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    log.debug(line.substring(3));
                } else {
                    if (line.startsWith("execute java ")) {
                        String upgradestepClassName = line.substring(13).trim();
                        DbUpgradeStep dbUpgradeStep = null;
                        try {
                            dbUpgradeStep = (DbUpgradeStep)ReflectUtil.instantiate(upgradestepClassName);
                        }
                        catch (ActivitiException e) {
                            throw new ActivitiException("database update java class '" + upgradestepClassName + "' can't be instantiated: " + e.getMessage(), e);
                        }
                        try {
                            log.debug("executing upgrade step java class {}", (Object)upgradestepClassName);
                            dbUpgradeStep.execute(this);
                        }
                        catch (Exception e) {
                            throw new ActivitiException("error while executing database update java class '" + upgradestepClassName + "': " + e.getMessage(), e);
                        }
                    }
                    if (line.length() > 0) {
                        if ("oracle".equals(databaseType) && line.startsWith("begin")) {
                            inOraclePlsqlBlock = true;
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        } else if (line.endsWith(";") && !inOraclePlsqlBlock || line.startsWith("/") && inOraclePlsqlBlock) {
                            if (inOraclePlsqlBlock) {
                                inOraclePlsqlBlock = false;
                            } else {
                                sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                            }
                            Statement jdbcStatement = connection.createStatement();
                            try {
                                log.debug("SQL: {}", (Object)sqlStatement);
                                jdbcStatement.execute(sqlStatement);
                                jdbcStatement.close();
                            }
                            catch (Exception e) {
                                if (exception == null) {
                                    exception = e;
                                    exceptionSqlStatement = sqlStatement;
                                }
                                log.error("problem during schema {}, statement {}", new Object[]{operation, sqlStatement, e});
                            }
                            finally {
                                sqlStatement = null;
                            }
                        } else {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        }
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            if (exception != null) {
                throw exception;
            }
            log.debug("activiti db schema {} for component {} successful", (Object)operation, (Object)component);
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't " + operation + " db schema: " + exceptionSqlStatement, e);
        }
    }

    protected String updateDdlForMySqlVersionLowerThan56(String ddlStatements) {
        return ddlStatements.replace("timestamp(3)", "timestamp").replace("datetime(3)", "datetime").replace("TIMESTAMP(3)", "TIMESTAMP").replace("DATETIME(3)", "DATETIME");
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsProcessEngineBuild() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                this.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            this.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            this.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            this.dbSchemaUpdate();
        }
    }

    public void performSchemaOperationsProcessEngineClose() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("create-drop".equals(databaseSchemaUpdate)) {
            this.dbSchemaDrop();
        }
    }

    public <T> T getCustomMapper(Class<T> type) {
        return (T)this.sqlSession.getMapper(type);
    }

    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    public ModelQueryImpl createModelQueryImpl() {
        return new ModelQueryImpl();
    }

    public ProcessDefinitionQueryImpl createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl();
    }

    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    public ExecutionQueryImpl createExecutionQuery() {
        return new ExecutionQueryImpl();
    }

    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    public HistoricProcessInstanceQueryImpl createHistoricProcessInstanceQuery() {
        return new HistoricProcessInstanceQueryImpl();
    }

    public HistoricActivityInstanceQueryImpl createHistoricActivityInstanceQuery() {
        return new HistoricActivityInstanceQueryImpl();
    }

    public HistoricTaskInstanceQueryImpl createHistoricTaskInstanceQuery() {
        return new HistoricTaskInstanceQueryImpl();
    }

    public HistoricDetailQueryImpl createHistoricDetailQuery() {
        return new HistoricDetailQueryImpl();
    }

    public HistoricVariableInstanceQueryImpl createHistoricVariableInstanceQuery() {
        return new HistoricVariableInstanceQueryImpl();
    }

    public UserQueryImpl createUserQuery() {
        return new UserQueryImpl();
    }

    public GroupQueryImpl createGroupQuery() {
        return new GroupQueryImpl();
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public void deleteNewHisTask(String taskId) {
        Map<String, CachedObject> map = this.cachedObjects.get(HistoricTaskInstanceEntity.class);
        if (map == null) {
            return;
        }
        CachedObject cachedObject = map.get(taskId);
        if (cachedObject != null) {
            Map<String, CachedObject> identityLinkMap = this.cachedObjects.get(HistoricIdentityLinkEntity.class);
            if (identityLinkMap != null) {
                ArrayList<PersistentObject> deleteList = new ArrayList<PersistentObject>();
                for (CachedObject identityLink : identityLinkMap.values()) {
                    if (!taskId.equals(((HistoricIdentityLinkEntity)identityLink.getPersistentObject()).getTaskId())) continue;
                    deleteList.add(identityLink.getPersistentObject());
                }
                for (PersistentObject deleteMsg : deleteList) {
                    this.insertedObjects.get(HistoricIdentityLinkEntity.class).remove(deleteMsg);
                    this.cachedObjects.get(HistoricIdentityLinkEntity.class).remove(deleteMsg.getId());
                }
            }
            this.insertedObjects.get(HistoricTaskInstanceEntity.class).remove(cachedObject.getPersistentObject());
            this.cachedObjects.get(HistoricTaskInstanceEntity.class).remove(taskId);
        }
    }

    public List<TaskEntity> findTasksByProcessInstanceIdFromCache(String processInstanceId) {
        List<PersistentObject> taskEntities = this.insertedObjects.get(TaskEntity.class);
        ArrayList<TaskEntity> taskEntityList = new ArrayList<TaskEntity>();
        for (PersistentObject task : taskEntities) {
            TaskEntity taskEntity = (TaskEntity)task;
            if (!taskEntity.getProcessInstanceId().equals(processInstanceId)) continue;
            taskEntityList.add(taskEntity);
        }
        return taskEntityList;
    }

    public HistoricTaskInstanceEntity findLastFinishedTaskFromCache(String processInstanceId, String taskDefKey, String subProcessKey) {
        Map<String, CachedObject> map = this.cachedObjects.get(HistoricTaskInstanceEntity.class);
        HistoricTaskInstanceEntity result = null;
        if (map != null) {
            for (CachedObject cachedObject : map.values()) {
                HistoricTaskInstanceEntity historicTaskInstanceEntity = (HistoricTaskInstanceEntity)cachedObject.getPersistentObject();
                if ("2".equals(historicTaskInstanceEntity.getTaskType()) || "3".equals(historicTaskInstanceEntity.getTaskType()) || "4".equals(historicTaskInstanceEntity.getTaskType()) || !processInstanceId.equals(historicTaskInstanceEntity.getProcessInstanceId()) || subProcessKey != null && !subProcessKey.equals(historicTaskInstanceEntity.getSubProcessKey()) || !taskDefKey.equals(historicTaskInstanceEntity.getTaskDefinitionKey()) || result != null && historicTaskInstanceEntity.getEndTime() != null && !result.getEndTime().before(historicTaskInstanceEntity.getEndTime())) continue;
                result = historicTaskInstanceEntity;
            }
        }
        return result;
    }

    public List<HistoricTaskInstanceEntity> findAllHistoricTask(String processInstanceId, String taskDefKey, String subProcessKey) {
        ArrayList<HistoricTaskInstanceEntity> result = new ArrayList();
        HashMap<String, HistoricTaskInstanceEntity> historicTaskInstanceEntityMap = new HashMap<String, HistoricTaskInstanceEntity>();
        HistoricTaskInstanceQueryImpl historicTaskInstanceQuery = new HistoricTaskInstanceQueryImpl();
        historicTaskInstanceQuery.processInstanceId(processInstanceId).taskDefinitionKey(taskDefKey).subProcessKey(subProcessKey);
        List dataSourceEntityList = this.selectListWithRawParameterWithoutFilter("selectHistoricTaskInstancesByQueryCriteria", historicTaskInstanceQuery, 0, Integer.MAX_VALUE);
        for (HistoricTaskInstanceEntity historicTaskInstanceEntity : dataSourceEntityList) {
            historicTaskInstanceEntityMap.put(historicTaskInstanceEntity.getId(), historicTaskInstanceEntity);
        }
        Map<String, CachedObject> map = this.cachedObjects.get(HistoricTaskInstanceEntity.class);
        if (map != null) {
            for (CachedObject cachedObject : map.values()) {
                HistoricTaskInstanceEntity historicTaskInstanceEntity = (HistoricTaskInstanceEntity)cachedObject.getPersistentObject();
                if (!processInstanceId.equals(historicTaskInstanceEntity.getProcessInstanceId()) || subProcessKey != null && !subProcessKey.equals(historicTaskInstanceEntity.getSubProcessKey()) || taskDefKey != null && !taskDefKey.equals(historicTaskInstanceEntity.getTaskDefinitionKey())) continue;
                historicTaskInstanceEntityMap.put(historicTaskInstanceEntity.getId(), historicTaskInstanceEntity);
            }
        }
        for (DeleteOperation deleteOperation : this.deleteOperations) {
            if (!(deleteOperation instanceof CheckedDeleteOperation) || !(((CheckedDeleteOperation)deleteOperation).getPersistentObject() instanceof HistoricTaskInstanceEntity)) continue;
            historicTaskInstanceEntityMap.remove(((CheckedDeleteOperation)deleteOperation).getPersistentObject().getId());
        }
        result = new ArrayList(historicTaskInstanceEntityMap.values());
        return result;
    }

    private void throwBpmActivityLockingException(PersistentObject updatedObject) {
        boolean isTaskException;
        boolean bl = isTaskException = updatedObject instanceof HistoricTaskInstanceEntity || updatedObject instanceof TaskEntity;
        if (isTaskException) {
            throw new BpmActivityLockingException("\u6d41\u7a0b\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u529e\u7406", updatedObject instanceof HistoricTaskInstanceEntity || updatedObject instanceof TaskEntity);
        }
        throw new BpmActivityLockingException("\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u529e\u7406", updatedObject instanceof HistoricTaskInstanceEntity || updatedObject instanceof TaskEntity);
    }

    static {
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.7"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.8"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.9"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.10"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.11"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.12", Arrays.asList("5.12.1", "5.12T")));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.13"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.14"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.15"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.15.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.2-SNAPSHOT"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.2"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.3.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.4.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.17.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.17.0.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.17.0.2"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.18.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.18.0.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.20.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.20.0.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.20.0.2"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.21.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.22.0.0"));
        JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};
    }

    public static class CachedObject {
        protected PersistentObject persistentObject;
        protected Object persistentObjectState;

        public CachedObject(PersistentObject persistentObject, boolean storeState) {
            this.persistentObject = persistentObject;
            if (storeState) {
                this.persistentObjectState = persistentObject.getPersistentState();
            }
        }

        public PersistentObject getPersistentObject() {
            return this.persistentObject;
        }

        public Object getPersistentObjectState() {
            return this.persistentObjectState;
        }
    }

    public class BulkCheckedDeleteOperation
    implements DeleteOperation {
        protected Class<? extends PersistentObject> persistentObjectClass;
        protected List<PersistentObject> persistentObjects = new ArrayList<PersistentObject>();

        public BulkCheckedDeleteOperation(Class<? extends PersistentObject> persistentObjectClass) {
            this.persistentObjectClass = persistentObjectClass;
        }

        public void addPersistentObject(PersistentObject persistentObject) {
            this.persistentObjects.add(persistentObject);
        }

        @Override
        public boolean sameIdentity(PersistentObject other) {
            for (PersistentObject persistentObject : this.persistentObjects) {
                if (!persistentObject.getClass().equals(other.getClass()) || !persistentObject.getId().equals(other.getId())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clearCache() {
            for (PersistentObject persistentObject : this.persistentObjects) {
                DbSqlSession.this.cacheRemove(persistentObject.getClass(), persistentObject.getId());
            }
        }

        @Override
        public void execute() {
            if (this.persistentObjects.isEmpty()) {
                return;
            }
            String bulkDeleteStatement = DbSqlSession.this.dbSqlSessionFactory.getBulkDeleteStatement(this.persistentObjectClass);
            if ((bulkDeleteStatement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(bulkDeleteStatement)) == null) {
                throw new ActivitiException("no bulk delete statement for " + this.persistentObjectClass + " in the mapping files");
            }
            if (this.persistentObjects.get(0) instanceof HasRevision) {
                int nrOfRowsDeleted = DbSqlSession.this.sqlSession.delete(bulkDeleteStatement, this.persistentObjects);
                if (nrOfRowsDeleted < this.persistentObjects.size()) {
                    DbSqlSession.this.throwBpmActivityLockingException(this.persistentObjects.get(0));
                }
            } else {
                DbSqlSession.this.sqlSession.delete(bulkDeleteStatement, this.persistentObjects);
            }
        }

        @Override
        public Class<? extends PersistentObject> getPersistentObjectClass() {
            return this.persistentObjectClass;
        }

        public void setPersistentObjectClass(Class<? extends PersistentObject> persistentObjectClass) {
            this.persistentObjectClass = persistentObjectClass;
        }

        public List<PersistentObject> getPersistentObjects() {
            return this.persistentObjects;
        }

        public void setPersistentObjects(List<PersistentObject> persistentObjects) {
            this.persistentObjects = persistentObjects;
        }

        public String toString() {
            return "bulk delete of " + this.persistentObjects.size() + (!this.persistentObjects.isEmpty() ? " entities of " + this.persistentObjects.get(0).getClass() : Integer.valueOf(0));
        }
    }

    public class CheckedDeleteOperation
    implements DeleteOperation {
        protected final PersistentObject persistentObject;

        public CheckedDeleteOperation(PersistentObject persistentObject) {
            this.persistentObject = persistentObject;
        }

        @Override
        public Class<? extends PersistentObject> getPersistentObjectClass() {
            return this.persistentObject.getClass();
        }

        @Override
        public boolean sameIdentity(PersistentObject other) {
            return this.persistentObject.getClass().equals(other.getClass()) && this.persistentObject.getId().equals(other.getId());
        }

        @Override
        public void clearCache() {
            DbSqlSession.this.cacheRemove(this.persistentObject.getClass(), this.persistentObject.getId());
        }

        @Override
        public void execute() {
            String deleteStatement = DbSqlSession.this.dbSqlSessionFactory.getDeleteStatement(this.persistentObject.getClass());
            if ((deleteStatement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(deleteStatement)) == null) {
                throw new ActivitiException("no delete statement for " + this.persistentObject.getClass() + " in the ibatis mapping files");
            }
            if (this.persistentObject instanceof HasRevision) {
                int nrOfRowsDeleted = DbSqlSession.this.sqlSession.delete(deleteStatement, (Object)this.persistentObject);
                if (nrOfRowsDeleted == 0) {
                    DbSqlSession.this.throwBpmActivityLockingException(this.persistentObject);
                }
            } else {
                DbSqlSession.this.sqlSession.delete(deleteStatement, (Object)this.persistentObject);
            }
        }

        public PersistentObject getPersistentObject() {
            return this.persistentObject;
        }

        public String toString() {
            return "delete " + this.persistentObject;
        }
    }

    public class BulkDeleteOperation
    implements DeleteOperation {
        private String statement;
        private Object parameter;

        public BulkDeleteOperation(String statement, Object parameter) {
            this.statement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(statement);
            this.parameter = parameter;
        }

        @Override
        public Class<? extends PersistentObject> getPersistentObjectClass() {
            return null;
        }

        @Override
        public boolean sameIdentity(PersistentObject other) {
            return false;
        }

        @Override
        public void clearCache() {
        }

        @Override
        public void execute() {
            DbSqlSession.this.sqlSession.delete(this.statement, this.parameter);
        }

        public String toString() {
            return "bulk delete: " + this.statement + "(" + this.parameter + ")";
        }
    }

    public static interface DeleteOperation {
        public Class<? extends PersistentObject> getPersistentObjectClass();

        public boolean sameIdentity(PersistentObject var1);

        public void clearCache();

        public void execute();
    }
}

