/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import com.jxdinfo.hussar.workflow.util.BpmActivityExceptionUtil;
import java.util.Iterator;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.message.ExceptionMessageParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExclusiveGatewayActivityBehavior.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void leave(ActivityExecution execution) {
        if (log.isDebugEnabled()) {
            log.debug("Leaving activity '{}'", (Object)execution.getActivity().getId());
        }
        PvmTransition outgoingSeqFlow = null;
        String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
        Iterator<PvmTransition> transitionIterator = execution.getActivity().getOutgoingTransitions().iterator();
        while (outgoingSeqFlow == null && transitionIterator.hasNext()) {
            PvmTransition seqFlow = transitionIterator.next();
            Expression skipExpression = seqFlow.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled(execution, skipExpression)) {
                Condition condition = (Condition)seqFlow.getProperty("condition");
                if ((condition != null || defaultSequenceFlow != null && defaultSequenceFlow.equals(seqFlow.getId())) && (condition == null || !condition.evaluate(seqFlow.getId(), execution))) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Sequence flow '{}'selected as outgoing sequence flow.", (Object)seqFlow.getId());
                }
                outgoingSeqFlow = seqFlow;
                continue;
            }
            if (!SkipExpressionUtil.shouldSkipFlowElement(execution, skipExpression)) continue;
            outgoingSeqFlow = seqFlow;
        }
        if (outgoingSeqFlow != null) {
            execution.take(outgoingSeqFlow);
            return;
        } else if (defaultSequenceFlow != null) {
            PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
            if (defaultTransition == null) throw new ActivitiException("Default sequence flow '" + defaultSequenceFlow + "' not found");
            execution.take(defaultTransition);
            return;
        } else {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            ExceptionMessageParam messageParam = new ExceptionMessageParam();
            messageParam.setProcessKey(executionEntity.getProcessDefinitionKey());
            messageParam.setProcessName(executionEntity.getProcessDefinition().getName());
            messageParam.setProcessNameTranslateKey(executionEntity.getProcessDefinition().getNameTranslateKey());
            messageParam.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
            messageParam.setTaskDefinitionKey(execution.getActivity().getId());
            messageParam.setTaskDefinitionName(String.valueOf(execution.getActivity().getProperty("name")));
            messageParam.setNodeNameTranslateKey(ActivitiTranslateUtil.getTranslateKey(messageParam.getProcessDefinitionId(), messageParam.getTaskDefinitionKey()));
            String startUserId = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(execution.getProcessInstanceId()).getStartUserId();
            messageParam.setStartUserId(startUserId);
            ActivitiException activitiException = new ActivitiException("No outgoing sequence flow of the exclusive gateway '" + execution.getActivity().getId() + "' could be selected for continuing the process", messageParam);
            BpmActivityExceptionUtil.pushExceptionMessage(activitiException);
            BpmActivityExceptionUtil.throwBpmException(activitiException);
        }
    }
}

