/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;

public class GetIdentityLinksType
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String identityLinkType;

    public GetIdentityLinksType(String taskId, String identityLinkType) {
        this.taskId = taskId;
        this.identityLinkType = identityLinkType;
    }

    @Override
    public List<IdentityLink> execute(CommandContext commandContext) {
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (task == null) {
            return new ArrayList<IdentityLink>();
        }
        List<IdentityLink> identityLinks = task.getIdentityLinks();
        if (this.identityLinkType == null) {
            return identityLinks;
        }
        ArrayList<IdentityLink> identityLinksType = new ArrayList<IdentityLink>();
        for (IdentityLink identityLink : identityLinks) {
            if (!this.identityLinkType.equals(identityLink.getType())) continue;
            identityLinksType.add(identityLink);
        }
        return identityLinksType;
    }
}

