/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.history;

import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.history.HistoryManager;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.activiti.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHistoryManager
extends AbstractManager
implements HistoryManager {
    private static Logger log = LoggerFactory.getLogger((String)DefaultHistoryManager.class.getName());
    private HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level) {
        if (Context.getCommandContext().getAttribute("ACTIVITI_DB_SQL_SESSION_SELECT_LIST_TAG") != null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Current history level: {}, level required: {}", (Object)this.historyLevel, (Object)level);
        }
        return this.historyLevel.isAtLeast(level);
    }

    @Override
    public boolean isHistoryEnabled() {
        if (log.isDebugEnabled()) {
            log.debug("Current history level: {}", (Object)this.historyLevel);
        }
        return !this.historyLevel.equals((Object)HistoryLevel.NONE);
    }

    @Override
    public void recordProcessInstanceEnd(String processInstanceId, String deleteReason, String activityId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = this.getHistoricProcessInstanceManager().findHistoricProcessInstance(processInstanceId)) != null) {
            historicProcessInstance.markEnded(deleteReason);
            historicProcessInstance.setEndActivityId(activityId);
            ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
            if (config != null && config.getEventDispatcher().isEnabled()) {
                config.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_PROCESS_INSTANCE_ENDED, historicProcessInstance));
            }
        }
    }

    @Override
    public void recordProcessInstanceNameChange(String processInstanceId, String newName) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = this.getHistoricProcessInstanceManager().findHistoricProcessInstance(processInstanceId)) != null) {
            historicProcessInstance.setName(newName);
        }
    }

    @Override
    public void recordProcessInstanceStart(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            String separatedVariable;
            HistoricProcessInstanceEntity historicProcessInstance = new HistoricProcessInstanceEntity(processInstance);
            this.getDbSqlSession().insert(historicProcessInstance);
            ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
            if (config != null && config.getEventDispatcher().isEnabled()) {
                config.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_PROCESS_INSTANCE_CREATED, historicProcessInstance));
            }
            IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
            String processDefinitionId = processInstance.getProcessDefinitionId();
            String processInstanceId = processInstance.getProcessInstanceId();
            String executionId = processInstance.getId();
            String processTitle = processInstance.getProcessTitle();
            String dataDetail = processInstance.getDataDetail();
            String isEmulation = processInstance.getIsEmulation();
            HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
            historicActivityInstance.setId(idGenerator.getNextId());
            historicActivityInstance.setProcessDefinitionId(processDefinitionId);
            historicActivityInstance.setProcessInstanceId(processInstanceId);
            historicActivityInstance.setExecutionId(executionId);
            historicActivityInstance.setActivityId(processInstance.getActivityId());
            historicActivityInstance.setActivityName((String)processInstance.getActivity().getProperty("name"));
            historicActivityInstance.setActivityType((String)processInstance.getActivity().getProperty("type"));
            historicActivityInstance.setProcessTitle(processTitle);
            historicActivityInstance.setDataDetail(dataDetail);
            historicActivityInstance.setIsEmulation(isEmulation);
            historicActivityInstance.setActivityNameTranslateKey(ActivitiTranslateUtil.getTranslateKey(processDefinitionId, processInstance.getActivityId()));
            Date now = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
            historicActivityInstance.setStartTime(now);
            if (processInstance.getTenantId() != null) {
                historicActivityInstance.setTenantId(processInstance.getTenantId());
            }
            if ((separatedVariable = processInstance.getSubProcessKey()) != null) {
                Integer cycleCount = processInstance.getCycleCount();
                historicActivityInstance.setSubProcessKey(separatedVariable);
                historicActivityInstance.setCycleCount(cycleCount);
            }
            this.getDbSqlSession().insert(historicActivityInstance);
            if (config != null && config.getEventDispatcher().isEnabled()) {
                config.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_ACTIVITY_INSTANCE_CREATED, historicActivityInstance));
            }
        }
    }

    @Override
    public void recordSubProcessInstanceStart(ExecutionEntity parentExecution, ExecutionEntity subProcessInstance, Integer securityLevel) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricActivityInstanceEntity activitiyInstance;
            HistoricProcessInstanceEntity historicProcessInstance = new HistoricProcessInstanceEntity(subProcessInstance);
            ActivityImpl initialActivity = subProcessInstance.getActivity();
            if (historicProcessInstance.getStartActivityId() == null) {
                historicProcessInstance.setStartActivityId(subProcessInstance.getProcessDefinition().getInitial().getId());
                initialActivity = subProcessInstance.getProcessDefinition().getInitial();
            }
            HistoricProcessInstanceEntity superProcess = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(parentExecution.getProcessInstanceId());
            if (securityLevel != null) {
                historicProcessInstance.setSecurityLevel(securityLevel);
            } else {
                historicProcessInstance.setSecurityLevel(superProcess.getSecurityLevel());
            }
            historicProcessInstance.setProcessCycleCount(subProcessInstance.getProcessCycleCount());
            this.getDbSqlSession().insert(historicProcessInstance);
            ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
            if (config != null && config.getEventDispatcher().isEnabled()) {
                config.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_PROCESS_INSTANCE_CREATED, historicProcessInstance));
            }
            if ((activitiyInstance = this.findActivityInstance(parentExecution)) != null) {
                activitiyInstance.setCalledProcessInstanceId(subProcessInstance.getProcessInstanceId());
            }
            IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
            HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
            String separatedVariable = subProcessInstance.getSubProcessKey();
            if (separatedVariable != null) {
                Integer cycleCount = subProcessInstance.getCycleCount();
                historicActivityInstance.setSubProcessKey(separatedVariable);
                historicActivityInstance.setCycleCount(cycleCount);
            }
            historicActivityInstance.setProcessCycleCount(subProcessInstance.getProcessCycleCount());
            historicActivityInstance.setId(idGenerator.getNextId());
            historicActivityInstance.setProcessDefinitionId(subProcessInstance.getProcessDefinitionId());
            historicActivityInstance.setProcessInstanceId(subProcessInstance.getProcessInstanceId());
            historicActivityInstance.setExecutionId(subProcessInstance.getId());
            historicActivityInstance.setActivityId(initialActivity.getId());
            historicActivityInstance.setActivityName((String)initialActivity.getProperty("name"));
            historicActivityInstance.setActivityType((String)initialActivity.getProperty("type"));
            historicActivityInstance.setActivityNameTranslateKey(ActivitiTranslateUtil.getTranslateKey(subProcessInstance.getProcessDefinitionId(), initialActivity.getId()));
            Date now = Context.getProcessEngineConfiguration().getClock().getCurrentTime();
            historicActivityInstance.setStartTime(now);
            this.getDbSqlSession().insert(historicActivityInstance);
            if (config != null && config.getEventDispatcher().isEnabled()) {
                config.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_ACTIVITY_INSTANCE_CREATED, historicActivityInstance));
            }
        }
    }

    @Override
    public void recordActivityStart(ExecutionEntity executionEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && executionEntity.getActivity() != null) {
            String subProcessKey;
            IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
            String processDefinitionId = executionEntity.getProcessDefinitionId();
            String processInstanceId = executionEntity.getProcessInstanceId();
            String executionId = executionEntity.getId();
            HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
            historicActivityInstance.setId(idGenerator.getNextId());
            historicActivityInstance.setProcessDefinitionId(processDefinitionId);
            historicActivityInstance.setProcessInstanceId(processInstanceId);
            historicActivityInstance.setExecutionId(executionId);
            historicActivityInstance.setActivityId(executionEntity.getActivityId());
            historicActivityInstance.setActivityName((String)executionEntity.getActivity().getProperty("name"));
            historicActivityInstance.setActivityType((String)executionEntity.getActivity().getProperty("type"));
            historicActivityInstance.setActivityNameTranslateKey(ActivitiTranslateUtil.getTranslateKey(processDefinitionId, executionEntity.getActivityId()));
            historicActivityInstance.setStartTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            if (executionEntity.getTenantId() != null) {
                historicActivityInstance.setTenantId(executionEntity.getTenantId());
            }
            if ((subProcessKey = executionEntity.getSubProcessKey()) != null) {
                Integer cycleCount = executionEntity.getCycleCount();
                historicActivityInstance.setSubProcessKey(subProcessKey);
                historicActivityInstance.setCycleCount(cycleCount);
            }
            historicActivityInstance.setProcessCycleCount(executionEntity.getProcessCycleCount());
            this.getDbSqlSession().insert(historicActivityInstance);
            ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
            if (config != null && config.getEventDispatcher().isEnabled()) {
                config.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_ACTIVITY_INSTANCE_CREATED, historicActivityInstance));
            }
        }
    }

    @Override
    public void recordTaskNameTranslateKeyChange(String taskId, String taskNameTranslateKey) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setNameTranslateKey(taskNameTranslateKey);
        }
    }

    @Override
    public void recordProcessNameTranslateKeyChange(String taskId, String procNameTranslateKey) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setProcNameTranslateKey(procNameTranslateKey);
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity) {
        HistoricActivityInstanceEntity historicActivityInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicActivityInstance = this.findActivityInstance(executionEntity)) != null) {
            this.endHistoricActivityInstance(historicActivityInstance);
        }
    }

    protected void endHistoricActivityInstance(HistoricActivityInstanceEntity historicActivityInstance) {
        historicActivityInstance.markEnded(null);
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        if (config != null && config.getEventDispatcher().isEnabled()) {
            config.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstance));
        }
    }

    @Override
    public void recordStartEventEnded(ExecutionEntity execution, String activityId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            if (activityId == null) {
                return;
            }
            HistoricActivityInstanceEntity historicActivityInstance = this.findActivityInstance(execution, activityId, false);
            if (historicActivityInstance != null) {
                this.endHistoricActivityInstance(historicActivityInstance);
            }
        }
    }

    @Override
    public HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution) {
        return this.findActivityInstance(execution, execution.getActivityId(), true);
    }

    protected HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution, String activityId, boolean checkPersistentStore) {
        String executionId = execution.getId();
        List<HistoricActivityInstanceEntity> cachedHistoricActivityInstances = this.getDbSqlSession().findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (!executionId.equals(cachedHistoricActivityInstance.getExecutionId()) || activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || cachedHistoricActivityInstance.getEndTime() != null) continue;
            return cachedHistoricActivityInstance;
        }
        List historicActivityInstances = null;
        if (checkPersistentStore) {
            historicActivityInstances = new HistoricActivityInstanceQueryImpl(Context.getCommandContext()).executionId(executionId).activityId(activityId).unfinished().listPage(0, 1);
        }
        if (historicActivityInstances != null && !historicActivityInstances.isEmpty()) {
            return (HistoricActivityInstanceEntity)historicActivityInstances.get(0);
        }
        if (execution.getParentId() != null) {
            return this.findActivityInstance(execution.getParent(), activityId, checkPersistentStore);
        }
        return null;
    }

    @Override
    public void recordExecutionReplacedBy(ExecutionEntity execution, InterpretableExecution replacedBy) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List<HistoricActivityInstanceEntity> cachedHistoricActivityInstances = this.getDbSqlSession().findInCache(HistoricActivityInstanceEntity.class);
            for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
                if (cachedHistoricActivityInstance.getEndTime() != null || !execution.getId().equals(cachedHistoricActivityInstance.getExecutionId())) continue;
                cachedHistoricActivityInstance.setExecutionId(replacedBy.getId());
            }
            List historicActivityInstances = new HistoricActivityInstanceQueryImpl(Context.getCommandContext()).executionId(execution.getId()).unfinished().list();
            for (HistoricActivityInstanceEntity historicActivityInstance : historicActivityInstances) {
                historicActivityInstance.setExecutionId(replacedBy.getId());
            }
        }
    }

    @Override
    public void recordProcessDefinitionChange(String processInstanceId, String processDefinitionId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = this.getHistoricProcessInstanceManager().findHistoricProcessInstance(processInstanceId)) != null) {
            historicProcessInstance.setProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricTaskInstanceEntity historicTaskInstance = new HistoricTaskInstanceEntity(task, execution);
            this.getDbSqlSession().insert(historicTaskInstance);
        }
    }

    @Override
    public void recordTaskAssignment(TaskEntity task) {
        HistoricActivityInstanceEntity historicActivityInstance;
        ExecutionEntity executionEntity = task.getExecution();
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && executionEntity != null && (historicActivityInstance = this.findActivityInstance(executionEntity)) != null) {
            historicActivityInstance.setAssignee(task.getAssignee());
        }
    }

    @Override
    public void recordTaskClaim(String taskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setClaimTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        }
    }

    @Override
    public void recordTaskId(TaskEntity task) {
        HistoricActivityInstanceEntity historicActivityInstance;
        ExecutionEntity execution;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (execution = task.getExecution()) != null && (historicActivityInstance = task.isNewTask() ? this.findActivityInstanceWithNewTask(execution, execution.getActivityId(), true) : this.findActivityInstance(execution, execution.getActivityId(), true)) != null) {
            historicActivityInstance.setTaskId(task.getId());
        }
    }

    protected HistoricActivityInstanceEntity findActivityInstanceWithNewTask(ExecutionEntity execution, String activityId, boolean checkPersistentStore) {
        String executionId = execution.getId();
        List<HistoricActivityInstanceEntity> cachedHistoricActivityInstances = this.getDbSqlSession().findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (!executionId.equals(cachedHistoricActivityInstance.getExecutionId()) || activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || cachedHistoricActivityInstance.getEndTime() != null) continue;
            return cachedHistoricActivityInstance;
        }
        List historicActivityInstances = null;
        if (historicActivityInstances != null && !historicActivityInstances.isEmpty()) {
            return (HistoricActivityInstanceEntity)historicActivityInstances.get(0);
        }
        if (execution.getParentId() != null) {
            return this.findActivityInstance(execution.getParent(), activityId, checkPersistentStore);
        }
        return null;
    }

    @Override
    public void recordTaskEnd(String taskId, String deleteReason) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.markEnded(deleteReason);
        }
    }

    @Override
    public void recordTaskEnd(String taskId, String deleteReason, Date date) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setDeleteReason(deleteReason);
            historicTaskInstance.setEndTime(date);
            historicTaskInstance.setDurationInMillis(date.getTime() - historicTaskInstance.getStartTime().getTime());
        }
    }

    @Override
    public void recordTaskEnd(String taskId, String deleteReason, String mandator, String taskState, String assistInitiator) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.markEnded(deleteReason);
            if (mandator != null && taskState != null) {
                historicTaskInstance.setOwner(mandator);
                historicTaskInstance.setTaskState(taskState);
            }
            if (assistInitiator != null) {
                historicTaskInstance.setAssistInitiator(assistInitiator);
            }
        }
    }

    @Override
    public void recordTaskAssigneeChange(String taskId, String assignee) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setAssignee(assignee);
        }
    }

    @Override
    public void recordTaskOwnerChange(String taskId, String owner) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setOwner(owner);
        }
    }

    @Override
    public void recordTaskReceiverChange(String taskId, String receiver) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setReceiver(receiver);
        }
    }

    @Override
    public void recordAddDelAssigneesChange(String taskId, String addDelAssignees) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setAddDelAssignees(addDelAssignees);
        }
    }

    @Override
    public void recordAddAssigneeOperatorChange(String taskId, String addAssigneeOperator) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setAddAssigneeOperator(addAssigneeOperator);
        }
    }

    @Override
    public void recordTaskFormIdChange(String taskId, String formId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setFormId(formId);
        }
    }

    @Override
    public void recordTaskNameChange(String taskId, String taskName) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setName(taskName);
        }
    }

    @Override
    public void recordTaskDescriptionChange(String taskId, String description) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setDescription(description);
        }
    }

    @Override
    public void recordTaskDueDateChange(String taskId, Date dueDate) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setDueDate(dueDate);
        }
    }

    @Override
    public void recordTaskWarningDateChange(String taskId, Date warningDate) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setWarningDate(warningDate);
        }
    }

    @Override
    public void recordTaskErrorMsgChange(String taskId, String errorMsg) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setErrorMsg(errorMsg);
        }
    }

    @Override
    public void recordTaskPriorityChange(String taskId, int priority) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setPriority(priority);
        }
    }

    @Override
    public void recordTaskCategoryChange(String taskId, String category) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setCategory(category);
        }
    }

    @Override
    public void recordTaskFormKeyChange(String taskId, String formKey) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setFormKey(formKey);
        }
    }

    @Override
    public void recordSendUserChange(String taskId, String sendUser) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setSendUser(sendUser);
        }
    }

    @Override
    public void recordTaskParentTaskIdChange(String taskId, String parentTaskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setParentTaskId(parentTaskId);
        }
    }

    @Override
    public void recordTaskTypeChange(String taskId, String taskType) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setTaskType(taskType);
        }
    }

    @Override
    public void recordTaskExecutionIdChange(String taskId, String executionId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setExecutionId(executionId);
        }
    }

    @Override
    public void recordTaskDefinitionKeyChange(TaskEntity task, String taskDefinitionKey) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, task.getId())) != null) {
            Object formValue;
            Expression taskFormExpression;
            historicTaskInstance.setTaskDefinitionKey(taskDefinitionKey);
            if (taskDefinitionKey != null && (taskFormExpression = task.getTaskDefinition().getFormKeyExpression()) != null && (formValue = taskFormExpression.getValue(task.getExecution())) != null) {
                historicTaskInstance.setFormKey(formValue.toString());
            }
        }
    }

    @Override
    public void recordTaskProcessDefinitionChange(String taskId, String processDefinitionId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceEntity.copyAndInsert(variable);
        }
    }

    @Override
    public void recordHistoricDetailVariableCreate(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution, boolean useActivityId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.FULL)) {
            HistoricActivityInstanceEntity historicActivityInstance;
            HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = HistoricDetailVariableInstanceUpdateEntity.copyAndInsert(variable);
            if (useActivityId && sourceActivityExecution != null && (historicActivityInstance = this.findActivityInstance(sourceActivityExecution)) != null) {
                historicVariableUpdate.setActivityInstanceId(historicActivityInstance.getId());
            }
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceEntity historicProcessVariable = this.getDbSqlSession().findInCache(HistoricVariableInstanceEntity.class, variable.getId());
            if (historicProcessVariable == null) {
                historicProcessVariable = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findHistoricVariableInstanceByVariableInstanceId(variable.getId());
            }
            if (historicProcessVariable != null) {
                historicProcessVariable.copyValue(variable);
            } else {
                HistoricVariableInstanceEntity.copyAndInsert(variable);
            }
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceEntity historicProcessVariable = this.getDbSqlSession().findInCache(HistoricVariableInstanceEntity.class, variable.getId());
            if (historicProcessVariable == null) {
                historicProcessVariable = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findHistoricVariableInstanceByVariableInstanceId(variable.getId());
            }
            if (historicProcessVariable != null) {
                Context.getCommandContext().getHistoricVariableInstanceEntityManager().delete(historicProcessVariable);
            }
        }
    }

    @Override
    public void createIdentityLinkComment(String taskId, String userId, String groupId, String type, boolean create) {
        this.createIdentityLinkComment(taskId, userId, groupId, type, create, false);
    }

    @Override
    public void createIdentityLinkComment(String taskId, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        if (this.isHistoryEnabled()) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = new CommentEntity();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            comment.setTaskId(taskId);
            if (userId != null || forceNullUserId) {
                if (create) {
                    comment.setAction("AddUserLink");
                } else {
                    comment.setAction("DeleteUserLink");
                }
                comment.setMessage(new String[]{userId, type});
            } else {
                if (create) {
                    comment.setAction("AddGroupLink");
                } else {
                    comment.setAction("DeleteGroupLink");
                }
                comment.setMessage(new String[]{groupId, type});
            }
            this.getSession(CommentEntityManager.class).insert(comment);
        }
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(String processInstanceId, String userId, String groupId, String type, boolean create) {
        this.createProcessInstanceIdentityLinkComment(processInstanceId, userId, groupId, type, create, false);
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(String processInstanceId, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        if (this.isHistoryEnabled()) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = new CommentEntity();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            comment.setProcessInstanceId(processInstanceId);
            if (userId != null || forceNullUserId) {
                if (create) {
                    comment.setAction("AddUserLink");
                } else {
                    comment.setAction("DeleteUserLink");
                }
                comment.setMessage(new String[]{userId, type});
            } else {
                if (create) {
                    comment.setAction("AddGroupLink");
                } else {
                    comment.setAction("DeleteGroupLink");
                }
                comment.setMessage(new String[]{groupId, type});
            }
            this.getSession(CommentEntityManager.class).insert(comment);
        }
    }

    @Override
    public void createAttachmentComment(String taskId, String processInstanceId, String attachmentName, boolean create) {
        if (this.isHistoryEnabled()) {
            String userId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = new CommentEntity();
            comment.setUserId(userId);
            comment.setType("event");
            comment.setTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            comment.setTaskId(taskId);
            comment.setProcessInstanceId(processInstanceId);
            if (create) {
                comment.setAction("AddAttachment");
            } else {
                comment.setAction("DeleteAttachment");
            }
            comment.setMessage(attachmentName);
            this.getSession(CommentEntityManager.class).insert(comment);
        }
    }

    @Override
    public void reportFormPropertiesSubmitted(ExecutionEntity processInstance, Map<String, String> properties, String taskId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            for (String propertyId : properties.keySet()) {
                String propertyValue = properties.get(propertyId);
                HistoricFormPropertyEntity historicFormProperty = new HistoricFormPropertyEntity(processInstance, propertyId, propertyValue, taskId);
                this.getDbSqlSession().insert(historicFormProperty);
            }
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
    }

    @Override
    public void deleteHistoricIdentityLink(String id) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            this.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLink(id);
        }
    }

    @Override
    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        if (this.isHistoryEnabled()) {
            HistoricProcessInstanceEntity historicProcessInstance;
            if (log.isDebugEnabled()) {
                log.debug("updateProcessBusinessKeyInHistory : {}", (Object)processInstance.getId());
            }
            if (processInstance != null && (historicProcessInstance = this.getDbSqlSession().selectById(HistoricProcessInstanceEntity.class, processInstance.getId())) != null) {
                historicProcessInstance.setBusinessKey(processInstance.getProcessBusinessKey());
                this.getDbSqlSession().update(historicProcessInstance);
            }
        }
    }

    @Override
    public void recordTaskSourceFlagChange(TaskEntity task, String taskSourceFlag) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, task.getId())) != null) {
            historicTaskInstance.setTaskSourceFlag(taskSourceFlag);
        }
    }

    @Override
    public void recordAppointAssigneeChange(TaskEntity task, String appointAssignee) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, task.getId())) != null) {
            historicTaskInstance.setAppointAssignee(appointAssignee);
        }
    }

    @Override
    public void updateProcessInstance(HistoricProcessInstanceEntity historicProcessInstance) {
        this.getDbSqlSession().update(historicProcessInstance);
    }
}

